<?php

namespace App\Exceptions;

use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Validation\ValidationException;
use Symfony\Component\HttpKernel\Exception\HttpException;

use PDOException; 

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that should not be reported.
     *
     * @var array
     */
    protected $dontReport = [
        AuthorizationException::class,
        HttpException::class,
        ModelNotFoundException::class,
        ValidationException::class,
        TokenMismatchException::class,
    ];

    /**
     * Report or log an exception.
     *
     * This is a great spot to send exceptions to Sentry, Bugsnag, etc.
     *
     * @param \Exception $e
     *
     * @return void
     */
    public function report(Exception $e)
    {
        parent::report($e);
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Exception               $e
     *
     * @return \Illuminate\Http\Response
     */
    public function render($request, Exception $e)
    {
        $uri = $request->getRequestUri();

        if(strpos($uri,'/uploads') || strpos($uri,'/images') || strpos($uri,'.'))
        {
            return parent::render($request, $e);
        }
        
        $redirect = \App\Models\Redirect::where('old_page',$uri)->orWhere('old_page',ltrim($uri,'/'))->first();
        if (!empty($redirect)) {
            
            $slug = explode('/',$uri);
            $movie_slug = end($slug);
            
        
            $movie = \App\Models\Movie::where('slug',$movie_slug)->first();            
           
            if(!empty($movie)){ 
                \App\Models\Redirect::where('old_page','like','%'.$movie->slug.'%')->delete();
            }
            else{ 
                return redirect($redirect->new_page,301);
            }
            
        }

        if($e instanceof \Illuminate\Database\Eloquent\ModelNotFoundException){

            if((strpos($e->getMessage(), 'App\Models\Page') || strpos($e->getMessage(), 'App\Models\Movie')) && !empty($request->slug) && strpos($request->getRequestUri(), 'admin') === false)
            {

                $old_slug = str_replace('/movies/','',$uri);
                $old_link = \App\Models\OldLink::with('movie')->where('slug',$old_slug)->orderBy('id','DESC')->first();
                if(!empty($old_link)){
                    if(!empty($old_link->movie)) return redirect($old_link->movie->url,301);
                }


                $word = str_replace('-', ' ', $request->slug);
                $word = preg_replace("/[^a-zA-Z0-9\s]/", ' ', $word);
                $word_count = count(preg_split('/\s+/', $word));

                for ($i=1; $i <= $word_count; $i++) { 

                    $movie = \App\Models\Movie::where(function($query) use($word){
                                $query->orWhere('slug','like','%'.$word.'%');
                                $query->orWhere('title','like','%'.$word.'%');
                                $query->orWhere('title_long','like','%'.$word.'%');
                                $query->orWhere('imdb_code','like','%'.$word.'%');
                            })->orderBy('year','DESC')
                            ->first();

                    if(!empty($movie)) break;

                    $word_explode = explode(' ', $word);
                    $last_word = end($word_explode);
                    $word = trim(str_replace($last_word, '', $word));
                    
                }


                if(empty($movie))
                {
                    $word = str_replace('-', ' ', $request->slug);
                    $word = preg_replace("/[^a-zA-Z0-9\s]/", ' ', $word);
                    $word_count = count(preg_split('/\s+/', $word));

                    for ($i=1; $i <= $word_count; $i++) { 

                        $movie = \App\Models\Movie::where(function($query) use($word){
                                    $query->orWhere('slug','like','%'.$word.'%');
                                    $query->orWhere('title','like','%'.$word.'%');
                                    $query->orWhere('title_long','like','%'.$word.'%');
                                    $query->orWhere('genres','like','%'.$word.'%');
                                    $query->orWhere('description_full','like','%'.$word.'%');
                                    $query->orWhere('imdb_code','like','%'.$word.'%');
                                    $query->orWhere('cast','like','%'.$word.'%');
                                    $query->orWhere('director','like','%'.$word.'%'); 
                                })->orderBy('year','DESC')
                                ->first();

                        if(!empty($movie)) break;

                        $word_explode = explode(' ', $word);
                        $last_word = end($word_explode);
                        $word = trim(str_replace($last_word, '', $word));
                        
                    }
                }

                if(empty($movie))
                {
                    $word = str_replace('-', ' ', $request->slug);
                    $word = preg_replace("/[^a-zA-Z0-9\s]/", ' ', $word);
                    $word_count = count(preg_split('/\s+/', $word));
                    $word = (isset($word[0])) ? $word[0] : '';

                    $movie = \App\Models\Movie::where(function($query) use($word){
                                $query->orWhere('slug','like','%'.$word.'%');
                                $query->orWhere('title','like','%'.$word.'%');
                                $query->orWhere('title_long','like','%'.$word.'%');
                                $query->orWhere('imdb_code','like','%'.$word.'%');
                            })->orderBy('year','DESC')
                            ->first();
                }
                
               
                if (!empty($movie)) {

                  /*  $redirect = new \App\Models\Redirect();
                    $redirect->old_page = $uri;
                    $redirect->new_page = 'movies/'.$movie->slug;
                    $redirect->save(); */

                    return redirect($movie->url,301);
                }
                
            }


            if(strpos($e->getMessage(), 'App\Models\Series') && !empty($request->slug) && strpos($request->getRequestUri(), 'admin') === false)
            {

                $old_slug = str_replace('/series/','',$uri);
                $old_link = \App\Models\OldLinkSeries::with('series')->where('slug',$old_slug)->orderBy('id','DESC')->first();
                if(!empty($old_link)){
                    if(!empty($old_link->series)) return redirect($old_link->series->url,301);
                }
                                
            }             
                      
            if(strpos($e->getMessage(), 'App\Models\Season') && !empty($request->slug) && strpos($request->getRequestUri(), 'admin') === false)
            {

                $old_slug = str_replace('/seasons/','',$uri);
                $old_link = \App\Models\OldLinkSeason::with('season')->where('slug',$old_slug)->orderBy('id','DESC')->first();
                if(!empty($old_link)){
                    if(!empty($old_link->season)) return redirect($old_link->season->url,301);
                }
                
            }            

            if(strpos($e->getMessage(), 'App\Models\Episode') && !empty($request->slug) && strpos($request->getRequestUri(), 'admin') === false)
            {
                $old_slug = str_replace('/episodes/','',$uri);
                $old_link = \App\Models\OldLinkEpisode::with('episode')->where('slug',$old_slug)->orderBy('id','DESC')->first();
                if(!empty($old_link)){
                    if(!empty($old_link->episode)) return redirect($old_link->episode->url,301);
                }
                
            }


            if((strpos($e->getMessage(), 'App\Models\Series') || strpos($e->getMessage(), 'App\Models\Season') || strpos($e->getMessage(), 'App\Models\Episode')) && !empty($request->slug) && strpos($request->getRequestUri(), 'admin') === false)
            {

                $word = str_replace('-', ' ', $request->slug);
                $word = preg_replace("/[^a-zA-Z0-9\s]/", ' ', $word);
                $word_count = count(preg_split('/\s+/', $word));

                for ($i=1; $i <= $word_count; $i++) { 

                    $item = \App\Models\Series::where(function($query) use($word){
                                $query->orWhere('slug','like','%'.$word.'%');
                                $query->orWhere('title','like','%'.$word.'%');
                                $query->orWhere('title_long','like','%'.$word.'%');
                                $query->orWhere('imdb_code','like','%'.$word.'%');
                            })->orderBy('year','DESC')
                            ->first();

                    if(!empty($item)) break;

                    $word_explode = explode(' ', $word);
                    $last_word = end($word_explode);
                    $word = trim(str_replace($last_word, '', $word));
                    
                }


                if(empty($item))
                {
                    $word = str_replace('-', ' ', $request->slug);
                    $word = preg_replace("/[^a-zA-Z0-9\s]/", ' ', $word);
                    $word_count = count(preg_split('/\s+/', $word));

                    for ($i=1; $i <= $word_count; $i++) { 

                        $item = \App\Models\Series::where(function($query) use($word){
                                    $query->orWhere('slug','like','%'.$word.'%');
                                    $query->orWhere('title','like','%'.$word.'%');
                                    $query->orWhere('title_long','like','%'.$word.'%');
                                    $query->orWhere('genres','like','%'.$word.'%');
                                    $query->orWhere('description_full','like','%'.$word.'%');
                                    $query->orWhere('imdb_code','like','%'.$word.'%');
                                    $query->orWhere('cast','like','%'.$word.'%');
                                    $query->orWhere('director','like','%'.$word.'%'); 
                                })->orderBy('year','DESC')
                                ->first();

                        if(!empty($item)) break;

                        $word_explode = explode(' ', $word);
                        $last_word = end($word_explode);
                        $word = trim(str_replace($last_word, '', $word));
                        
                    }
                }

                if(empty($item))
                {
                    $word = str_replace('-', ' ', $request->slug);
                    $word = preg_replace("/[^a-zA-Z0-9\s]/", ' ', $word);
                    $word_count = count(preg_split('/\s+/', $word));
                    $word = (isset($word[0])) ? $word[0] : '';

                    $item = \App\Models\Series::where(function($query) use($word){
                                $query->orWhere('slug','like','%'.$word.'%');
                                $query->orWhere('title','like','%'.$word.'%');
                                $query->orWhere('title_long','like','%'.$word.'%');
                                $query->orWhere('imdb_code','like','%'.$word.'%');
                            })->orderBy('year','DESC')
                            ->first();
                }
                
               
                if (!empty($item)) {
                    return redirect($item->url,301);
                } 
                
            }
          
        }
              
        if($e instanceof PDOException)
        {
            \Log::info($e->getMessage());
            return 'query error';
        }

        return parent::render($request, $e);
    }
}
