<?php 
namespace App\Http\Controllers\Admin;

use Backpack\CRUD\app\Http\Controllers\CrudController;

// VALIDATION: change the requests to match your own file names if you need form validation
use App\Http\Requests\ArtistCrudRequest as StoreRequest;
use App\Http\Requests\ArtistCrudRequest as UpdateRequest;

class ArtistCrudController extends CrudController {

	public function setup() 
	{
        $this->crud->setModel("App\Models\Artist");
        $this->crud->setRoute("admin/artist");
        $this->crud->setEntityNameStrings('artist', 'artists');
		$this->crud->orderBy('name');
        $this->crud->setColumns(['name','imdb_code']);
	    $this->crud->addField(['name' => 'name','label' => "Artist name"]);
	    $this->crud->addField(['name' => 'imdb_code','label' => "IMDB Code"]);
	    $this->crud->addField(['name' => 'photo','label' => "Photo",'type'=>'browse','upload'=>true]);
        $this->crud->addButtonFromModelFunction('line', 'open_google', 'openGoogle', 'beginning'); 	
        $this->crud->enableAjaxTable(['name','imdb_code']);

        $this->crud->addFilter([ // dropdown filter
          'name' => 'photo',
          'type' => 'dropdown',
          'label'=> 'Photo',
          'placeholder' => 'Photo'
        ], [
          '1' => 'Has',
          '2' => 'Has not',
        ], function($value) { // if the filter is active
            if($value == '1') $this->crud->addClause('where', 'photo','!=','');
            else $this->crud->addClause('where', 'photo','=',null);
        });         
        $this->crud->enableDetailsRow();
    }

	public function store(StoreRequest $request)
	{
		return parent::storeCrud();
	}

	public function update(UpdateRequest $request)
	{
		return parent::updateCrud();
	}

	public function getArtists() {
	  $term = $this->request->input('term');
	  $options = \App\Models\Artist::where('name', 'like', '%'.$term.'%')->get();
	  $artists = array();
	  foreach($options as $artist){
	  	$artists[$artist->name] = $artist->name;
	  }
	  return $artists;
	}

	public function showDetailsRow($id)
    {
        $this->data['entry'] = $this->crud->getEntry($id);
        $this->data['crud'] = $this->crud;

        // load the view from /resources/views/vendor/backpack/crud/ if it exists, otherwise load the one in the package
        return view('crud::details_row.artist', $this->data);
    }
}