<?php 
namespace App\Http\Controllers\Admin;

use App\Models\Series;
use App\Models\Season;
use App\Models\Episode;
use App\Models\ETorrent;
use Illuminate\Support\Facades\Input;
use Illuminate\Http\Request;
use Validator;
use Config;

use Illuminate\Routing\Controller as BaseController;

class ETorrentController extends BaseController
{
	public function index($episode_id)
	{
		$episode = Episode::where('id',$episode_id)->with('series')->with('season')->firstOrfail();
        $season = $episode->season;
        $series = $episode->series;
		$torrents = ETorrent::where('series_id',$series->id)->where('season_number',$season->season_number)->where('episode_number',$episode->episode_number)->get();
		return view('admin.episode.torrent.index',compact('series','season','episode','torrents'));
	}

	public function create($episode_id)
	{
        $episode = Episode::where('id',$episode_id)->with('series')->with('season')->firstOrfail();
        $season = $episode->season;
        $series = $episode->series;
		return view('admin.episode.torrent.create',compact('season','series','episode'));
	}

	public function save($episode_id,Request $request)
	{
        $episode = Episode::where('id',$episode_id)->with('series')->with('season')->firstOrfail();
        $season = $episode->season;
        $series = $episode->series;

		$validator = Validator::make($request->all(), [
            'name' => 'required|max:255',
            'quality' => 'required|max:255',
            'resolution' => 'required|max:255',
            'hash' => 'required|max:255|unique:torrent,hash',
            'peers' => 'required|numeric',
            'seeds' => 'required|numeric',
            'fps' => 'required',
            'size_bytes' => 'required|numeric',            
            'torrent_file' => 'required|max:'.Config::Get('settings.max_torrent_size'),            
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }
        else {  
        	$torrent = new ETorrent();
        	$torrent->name = $request->name;
            $torrent->series_id = $episode->series_id;
            $torrent->season_number = $episode->season_number;
            $torrent->episode_number = $episode->episode_number;
        	$torrent->hash = $request->hash;
        	$torrent->quality = $request->quality;
        	$torrent->resolution = $request->resolution;
        	$torrent->peers = $request->peers;
        	$torrent->seeds = $request->seeds;
        	$torrent->size_bytes = $request->size_bytes*1024*1024;
        	$torrent->fps = $request->fps;
        	$torrent->magnet = $request->magnet;

 			$destinationPath = 'uploads/series/'.str_slug($series->title_long).'/'.str_slug('season '.$episode->season_number).'/'.str_slug('episode '.$episode->episode_number);
            if (!file_exists($destinationPath)) {
				mkdir($destinationPath, 0777, true);
				chmod($destinationPath, 0777);       
			}

        	$torrent_file = $request->file('torrent_file');
            $file_ext = $torrent_file->getClientOriginalExtension();				     
            $new_file_name = str_slug($season->title_long)."-".$request->quality.".".$file_ext;
			$torrent_file->move($destinationPath,$new_file_name);    
			$torrent->file = "/".$destinationPath."/".$new_file_name;

			$torrent->save();
			return redirect()->back()->withSuccess('Torrent successfully added.');
        }
	}


	public function edit($episode_id,$torrent_id)
	{
        $episode = Episode::where('id',$episode_id)->with('series')->with('season')->firstOrfail();
        $season = $episode->season;
        $series = $episode->series;


		$torrent = ETorrent::findOrfail($torrent_id);

		return view('admin.episode.torrent.edit',compact('series','season','episode','torrent'));
	}


	public function update($episode_id,$torrent_id,Request $request)
	{
        $episode = Episode::where('id',$episode_id)->with('series')->with('season')->firstOrfail();
        $season = $episode->season;
        $series = $episode->series;


		$validator = Validator::make($request->all(), [
            'quality' => 'required|max:255',
            'name' => 'required|max:255',
            'resolution' => 'required|max:255',
            'hash' => 'required|max:255|unique:torrent,hash,'.$torrent_id,
            'peers' => 'required|numeric',
            'seeds' => 'required|numeric',
            'fps' => 'required',
            'size_bytes' => 'required|numeric',            
            'torrent_file' => 'max:'.Config::Get('settings.max_torrent_size'),            
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }
        else {  
        	$torrent = ETorrent::findOrfail($torrent_id);
            $torrent->name = $request->name;
        	$torrent->hash = $request->hash;
        	$torrent->quality = $request->quality;
        	$torrent->resolution = $request->resolution;
        	$torrent->peers = $request->peers;
        	$torrent->seeds = $request->seeds;
        	$torrent->size_bytes = $request->size_bytes*1024*1024;
        	$torrent->fps = $request->fps;
        	$torrent->magnet = $request->magnet;

        	if($request->hasFile('torrent_file'))
        	{
	 			$destinationPath = 'uploads/series/'.str_slug($series->title_long).'/'.str_slug('season '.$episode->season_number).'/'.str_slug('episode '.$episode->episode_number);
	            if (!file_exists($destinationPath)) {
					mkdir($destinationPath, 0777, true);
					chmod($destinationPath, 0777);       
				}

	        	$torrent_file = $request->file('torrent_file');
	            $file_ext = $torrent_file->getClientOriginalExtension();				     
	            $new_file_name = str_slug($season->name)."-".$request->quality.".".$file_ext;
				$torrent_file->move($destinationPath,$new_file_name);    
				$torrent->file = "/".$destinationPath."/".$new_file_name;
			}

			$torrent->save();
			return redirect()->back()->withSuccess('Torrent successfully updated.');
        }
	}

	public function destroy($episode_id,$torrent_id)
	{
		$torrent = ETorrent::findOrfail($torrent_id);
		if(file_exists($torrent->file)) unlink($torrent->file);
		$torrent->delete();
		return redirect()->back()->withSuccess('Torrent successfully deleted.');
	}
}
	