<?php 
namespace App\Http\Controllers\Admin;

use Backpack\CRUD\app\Http\Controllers\CrudController;

// VALIDATION: change the requests to match your own file names if you need form validation
use App\Http\Requests\GenreCrudRequest as StoreRequest;
use App\Http\Requests\GenreCrudRequest as UpdateRequest;

class GenreCrudController extends CrudController {

	public function setup() 
	{
        $this->crud->setModel("App\Models\Genre");
        $this->crud->setRoute("admin/genre");
        $this->crud->setEntityNameStrings('genre', 'genres');
        $this->crud->orderBy('name');
        $this->crud->setColumns(['name']);
        $this->crud->addField([
	'name' => 'name',
	'label' => "Genre name"
	]);
        $this->crud->removeButton('delete');
        $this->crud->enableAjaxTable(['name']);
    }

	public function store(StoreRequest $request)
	{
		return parent::storeCrud();
	}

	public function update(UpdateRequest $request)
	{
		return parent::updateCrud();
	}
}