<?php 
namespace App\Http\Controllers\Admin;

use Backpack\CRUD\app\Http\Controllers\CrudController;

// VALIDATION: change the requests to match your own file names if you need form validation
use App\Http\Requests\RedirectCrudRequest;

class RedirectCrudController extends CrudController {

	public function setup() 
	{
        $this->crud->setModel("App\Models\Redirect");
        $this->crud->setRoute("admin/redirects");
        $this->crud->setEntityNameStrings('redirect', 'redirects');
        
        $this->crud->setColumns(['old_page','new_page']);
        $this->crud->addField([
			'name' => 'old_page',
			'label' => 'Old Page Slug'
		]);        

		$this->crud->addField([
			'name' => 'new_page',
			'label' => 'New Page Slug'
		]);

        $this->crud->enableAjaxTable(['old_page','new_page']);
    }

	public function store(RedirectCrudRequest $request)
	{
		return parent::storeCrud();
	}

	public function update(RedirectCrudRequest $request)
	{
		return parent::updateCrud();
	}
}