<?php 
namespace App\Http\Controllers\Admin;

use App\Models\Series;
use App\Models\Season;
use App\Models\STorrent;
use Illuminate\Support\Facades\Input;
use Illuminate\Http\Request;
use Validator;
use Config;

use Illuminate\Routing\Controller as BaseController;

class STorrentController extends BaseController
{
	public function index($season_id)
	{
		$season = Season::findOrfail($season_id);
        $series = Series::findOrfail($season->series_id);
		$torrents = STorrent::where('series_id',$series->id)->where('season_number',$season->season_number)->get();
		return view('admin.season.torrent.index',compact('series','season','torrents'));
	}

	public function create($season_id)
	{
		$season = Season::findOrfail($season_id);
        $series = Series::findOrfail($season->series_id);
		return view('admin.season.torrent.create',compact('season','series'));
	}

	public function save($season,Request $request)
	{
        $season = Season::findOrfail($season);

		$series = Series::findOrfail($season->series_id);

		$validator = Validator::make($request->all(), [
            'season_id' => 'required|numeric|exists:season,id',
            'name' => 'required|max:255',
            'quality' => 'required|max:255',
            'resolution' => 'required|max:255',
            'hash' => 'required|max:255|unique:torrent,hash',
            'peers' => 'required|numeric',
            'seeds' => 'required|numeric',
            'fps' => 'required',
            'size_bytes' => 'required|numeric',            
            'torrent_file' => 'required|max:'.Config::Get('settings.max_torrent_size'),            
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }
        else {  
        	$torrent = new STorrent();
        	$torrent->name = $request->name;
            $torrent->series_id = $season->series_id;
            $torrent->season_number = $season->season_number;
        	$torrent->hash = $request->hash;
        	$torrent->quality = $request->quality;
        	$torrent->resolution = $request->resolution;
        	$torrent->peers = $request->peers;
        	$torrent->seeds = $request->seeds;
        	$torrent->size_bytes = $request->size_bytes*1024*1024;
        	$torrent->fps = $request->fps;
        	$torrent->magnet = $request->magnet;

 			$destinationPath = 'uploads/series/'.str_slug($series->title_long).'/'.str_slug($season->title_long);
            if (!file_exists($destinationPath)) {
				mkdir($destinationPath, 0777, true);
				chmod($destinationPath, 0777);       
			}

        	$torrent_file = $request->file('torrent_file');
            $file_ext = $torrent_file->getClientOriginalExtension();				     
            $new_file_name = str_slug($season->title_long)."-".$request->quality.".".$file_ext;
			$torrent_file->move($destinationPath,$new_file_name);    
			$torrent->file = "/".$destinationPath."/".$new_file_name;

			$torrent->save();
			return redirect()->back()->withSuccess('Torrent successfully added.');
        }
	}


	public function edit($season_id,$torrent_id)
	{
		$season = Season::findOrfail($season_id);
        $series = Series::findOrfail($season->series_id);
		$torrent = STorrent::findOrfail($torrent_id);
		return view('admin.season.torrent.edit',compact('series','season','torrent'));
	}


	public function update($season_id,$torrent_id,Request $request)
	{
		$season = Season::findOrfail($season_id);
        $series = Series::findOrfail($season->series_id);
		$validator = Validator::make($request->all(), [
            'quality' => 'required|max:255',
            'name' => 'required|max:255',
            'resolution' => 'required|max:255',
            'hash' => 'required|max:255|unique:torrent,hash,'.$torrent_id,
            'peers' => 'required|numeric',
            'seeds' => 'required|numeric',
            'fps' => 'required',
            'size_bytes' => 'required|numeric',            
            'torrent_file' => 'max:'.Config::Get('settings.max_torrent_size'),            
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }
        else {  
        	$torrent = STorrent::findOrfail($torrent_id);
            $torrent->name = $request->name;
        	$torrent->hash = $request->hash;
        	$torrent->quality = $request->quality;
        	$torrent->resolution = $request->resolution;
        	$torrent->peers = $request->peers;
        	$torrent->seeds = $request->seeds;
        	$torrent->size_bytes = $request->size_bytes*1024*1024;
        	$torrent->fps = $request->fps;
        	$torrent->magnet = $request->magnet;

        	if($request->hasFile('torrent_file'))
        	{
	 			$destinationPath = 'uploads/series/'.str_slug($series->title_long).'/'.str_slug($season->name);
	            if (!file_exists($destinationPath)) {
					mkdir($destinationPath, 0777, true);
					chmod($destinationPath, 0777);       
				}

	        	$torrent_file = $request->file('torrent_file');
	            $file_ext = $torrent_file->getClientOriginalExtension();				     
	            $new_file_name = str_slug($season->name)."-".$request->quality.".".$file_ext;
				$torrent_file->move($destinationPath,$new_file_name);    
				$torrent->file = "/".$destinationPath."/".$new_file_name;
			}

			$torrent->save();
			return redirect()->back()->withSuccess('Torrent successfully updated.');
        }
	}

	public function destroy($season_id,$torrent_id)
	{
		$torrent = STorrent::findOrfail($torrent_id);
		if(file_exists($torrent->file)) unlink($torrent->file);
		$torrent->delete();
		return redirect()->back()->withSuccess('Torrent successfully deleted.');
	}
}
	