<?php 
namespace App\Http\Controllers\Admin;

use App\Models\Season;
use App\Models\Series;
use App\Models\SVideo;
use Illuminate\Support\Facades\Input;
use Illuminate\Http\Request;
use Validator;
use Config;

use Illuminate\Routing\Controller as BaseController;

class SVideoController extends BaseController
{
	public function index($id)
	{
		$season = Season::findOrfail($id);
		$series = Series::findOrfail($season->series_id);
		$videos = SVideo::where('movie_id',$id)->get();
		return view('admin.season.video.index',compact('series','season','videos'));
	}

	public function create($series_id,$id)
	{
		$season = Season::findOrfail($id);
		$series = Series::findOrfail($season->series_id);
		return view('admin.season.video.create',compact('season','series'));
	}

	public function save($series_id,$id,Request $request)
	{
		$season = Season::findOrfail($id);
		$series = Series::findOrfail($season->series_id);
		$validator = Validator::make($request->all(), [
            'quality' => 'required|max:255',
            'source' => 'required|max:255',
            'video_link' => 'required'            
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }
        else {  
        	$video = new SVideo();
        	$video->season_id = $season->id;
        	$video->source = $request->source;
        	$video->quality = $request->quality;   
			$video->video_link = $request->video_link;

			$video->save();
			return redirect()->back()->withSuccess('Video successfully added.');
        }
	}


	public function edit($series_id,$id,$video)
	{
		$season = Season::findOrfail($id);
		$series = Series::findOrfail($season->series_id);
		$video = SVideo::findOrfail($video);
		return view('admin.season.video.edit',compact('series','season','video'));
	}


	public function update($series_id,$id,$video_id,Request $request)
	{
		$season = Season::findOrfail($id);
		$series = Series::findOrfail($season->series_id);
		$validator = Validator::make($request->all(), [
            'quality' => 'required|max:255',
            'source' => 'required|max:255',
            'video_link' => 'required',            
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }
        else {  
        	$video = SVideo::findOrfail($video_id);
        	$video->season_id = $season->id;
        	$video->quality = $request->quality;
        	$video->source = $request->source;
        	$video->video_link = $request->video_link;

        
			$video->save();
			return redirect()->back()->withSuccess('Video successfully updated.');
        }
	}

	public function destroy($series_id,$id,$video)
	{
		$video = SVideo::findOrfail($video);
		$video->delete();
		return redirect()->back()->withSuccess('Video successfully deleted.');
	}
}
	