<?php 
namespace App\Http\Controllers\Admin;

use App\Models\Movie;
use App\Models\Series;
use App\Models\Torrent;
use App\Models\Artist;
use App\Models\Video;
use App\Models\Subtitle;
use Illuminate\Support\Facades\Input;
use Illuminate\Http\Request;
use Validator;
use Config;
use Auth;
use Imdb;

use Illuminate\Routing\Controller as BaseController;
use Symfony\Component\DomCrawler\Crawler;

class ScrapController extends BaseController
{
	public function ytsShow()
	{
        return view('admin.scrapper.yts');
	}

	public function yts(Request $request)
	{
        if(empty($request->movie_id)) return redirect()->back()->withErrors('IMDB ID or YTS ID is required');
        $id = $request->movie_id;

        if(is_numeric($id)){
            try{
                $data = file_get_contents(config('settings.yts_api').'movie_details.json?movie_id='.$id.'&with_images=true&with_cast=true');
            }
            catch(\Exception $e)
            {
                return redirect()->back()->withErrors($e->getMessage());
            }
        }
        elseif(starts_with($id,'tt')){
            $data = file_get_contents(config('settings.yts_api').'list_movies.json?query_term='.$id);
            $data = json_decode($data);
            if($data->status == "ok"){
                if($data->data->movie_count == 1){
                    if(empty($data->data->movies)) return redirect()->back()->withErrors('Movie not available in API');
                    $id = $data->data->movies[0]->id;

                    try{
                        $data = file_get_contents(config('settings.yts_api').'movie_details.json?movie_id='.$id.'&with_images=true&with_cast=true');
                    }
                    catch(\Exception $e)
                    {
                        return redirect()->back()->withErrors($e->getMessage());
                    }
                }
                else{
                    return redirect()->back()->withErrors('IMDB ID or YTS ID is invalid');
                }
            }
            else{
                return redirect()->back()->withErrors('IMDB ID or YTS ID is invalid');
            }
        }	
        else{
            return redirect()->back()->withErrors('IMDB ID or YTS ID is invalid');
        }


        $data = json_decode($data);

        if($data->status == "ok")
        {
            $imdb_code = $data->data->movie->imdb_code;
            $title = $data->data->movie->title_english;
            $title_long = $data->data->movie->title_long;

            $check = Movie::where('imdb_code',$imdb_code)->first();
            if(empty($check)){
                $slug = $data->data->movie->slug;
                $year = $data->data->movie->year;
                $rating = $data->data->movie->rating;
                $runtime = $data->data->movie->runtime;
                $genres = (!empty($data->data->movie->genres)) ? str_replace('&',',',implode(',',$data->data->movie->genres)) : '';
                $description_full = $data->data->movie->description_full;
                $yt_trailer_code = (!empty($data->data->movie->yt_trailer_code)) ? $data->data->movie->yt_trailer_code : '';
                $language = $data->data->movie->language;
                $mpa_rating = $data->data->movie->mpa_rating;
                $download_count = 0;



  
                try{
                    $tmdb = file_get_contents('https://api.themoviedb.org/3/movie/'.$imdb_code.'?api_key=443880ff623cdfa7c3599a4d56c167ff');
                }
                catch(\Exception $e)
                {
                    $tmdb = json_encode([]);
                }  

                $tmdb = json_decode($tmdb);
                 
                if(!empty($tmdb->poster_path)) 
                {
                    $cover_image_path = 'https://image.tmdb.org/t/p/w342'.$tmdb->poster_path;
                }
                else{
                    $destinationPath = 'uploads/movies/'.str_slug($title_long.' '.$imdb_code);
                    if (!file_exists($destinationPath)) {
                        mkdir($destinationPath, 0775, true);
                        chmod($destinationPath, 0775);       
                    }
                
                    $small_cover_image = $destinationPath."/"."cover-small.jpg";
                    $medium_cover_image = $destinationPath."/"."cover-medium.jpg";
                    $large_cover_image = $destinationPath."/"."cover-large.jpg";

                    if(!empty($data->data->movie->medium_cover_image)){ 
                        try{
                            file_put_contents($medium_cover_image, fopen($data->data->movie->medium_cover_image, 'r'));
                        }
                        catch(\Exception $e)
                        {
                            $medium_cover_image = $destinationPath."/"."cover-medium.jpg";
                        }
                    }

                    $cover_image_path = "/".$medium_cover_image;
                    
                }
                
                if(!empty($tmdb->backdrop_path))
                {
                    $background_image_path = 'https://image.tmdb.org/t/p/w1280'.$tmdb->backdrop_path;
                }
                else{
                    
                    $destinationPath = 'uploads/movies/'.str_slug($title_long.' '.$imdb_code);
                    if (!file_exists($destinationPath)) {
                        mkdir($destinationPath, 0775, true);
                        chmod($destinationPath, 0775);       
                    }                    
  
                    $background_image = $destinationPath."/"."background.jpg";
                    if(!empty($data->data->movie->background_image)){
                        try{                        
                            file_put_contents($background_image, fopen($data->data->movie->background_image, 'r'));
                        }
                        catch(\Exception $e)
                        {
                            $background_image = $destinationPath."/"."background.jpg";
                        }                        
                    }
                    $background_image_path = "/".$background_image;                    
                }
  

                $artistPath = 'uploads/artists/';
                if (!file_exists($artistPath)) {
                    mkdir($artistPath, 0775, true);
                    chmod($artistPath, 0775);       
                }                  
                $artists = [];

                if(!empty($data->data->movie->cast))
                {
                    foreach ($data->data->movie->cast as $c) {
                        $artist_name = trim($c->name);

                        $check = Artist::where('name',$artist_name)->first();
                        if(empty($check)){
                            $artist = new Artist();
                            $artist->imdb_code = trim($c->imdb_code);
                            if(!empty($c->url_small_image)){
                                $artist_photo = $artistPath.str_slug($artist_name)."-".$artist->imdb_code.".jpg";
                                try{
                                  //  file_put_contents($artist_photo, fopen($c->url_small_image, 'r'));
                                }
                                catch(\Exception $e)
                                {
                                    continue;
                                }

                                $artist_photo = "/".$artist_photo;
                               // $artist->photo = $artist_photo;
                            }                       
                            $artist->name = $artist_name;
                            $artist->save();
                        }
                        array_push($artists, $artist_name);
                    }
                }

                $movie = new Movie();
                $movie->yts_id = $data->data->movie->id;
                $movie->imdb_code = $imdb_code;
                $movie->title = $title;
                $movie->title_long = $title_long;
                //$movie->slug = $slug;
                $movie->year = $year;
                $movie->rating = $rating;
                $movie->runtime = $runtime;
                $movie->genres = $genres;
                $movie->description_full = $description_full;
                if(!empty($yt_trailer_code)) $movie->yt_trailer_code = $yt_trailer_code;
                $movie->language = $language;
                $movie->mpa_rating = $mpa_rating;
                $movie->download_count = (!empty($data->data->movie->download_count)) ? $data->data->movie->download_count : 0;
                $movie->like_count = $data->data->movie->like_count;
                $movie->background_image = $background_image_path;
                $movie->cover_image = $cover_image_path;
                $movie->cast = implode(',', $artists);
                $movie->active = 1;
                $movie->user_id = 1;
                $movie->created_at = (!empty($data->data->movie->date_uploaded)) ? $data->data->movie->date_uploaded : date('Y-m-d H:i:s');
                $movie->save();

                if(!empty($data->data->movie->torrents))
                {
                    $torrentPath = 'uploads/movies/'.str_slug($title_long.' '.$imdb_code);
                    if (!file_exists($torrentPath)) 
                    {
                        mkdir($torrentPath, 0775, true);
                        chmod($torrentPath, 0775);       
                    }                     
                    foreach($data->data->movie->torrents as $t)
                    {
                        $torrent_hash = trim($t->hash);
                        $check = Torrent::where('hash',$torrent_hash)->first();
                        if(empty($check)){
                            $torrent_quality = trim($t->quality);
                            $torrent_type = trim($t->type);
                            $torrent_seeds = trim($t->seeds);
                            $torrent_peers = trim($t->peers);
                            $torrent_size_bytes = trim($t->size_bytes);
                            $torrent_file = $torrentPath."/".str_slug($title_long)."-".$torrent_quality.".torrent";

                            try{
                             //   file_put_contents($torrent_file, fopen($t->url, 'r'));
                            }
                            catch(\Exception $e)
                            {
                                continue;
                            }

                            if($torrent_quality == '3D'){
                                $torrent_resolution = '1920*1080';
                            }
                            elseif($torrent_quality == '2160p'){
                                $torrent_resolution = '3840*2160';
                            }                            
                            elseif($torrent_quality == '1080p'){
                                $torrent_resolution = '1920*1080';
                            }
                            elseif ($torrent_quality == '720p') {
                                $torrent_resolution = '1280*720';
                            }
                            else{
                                $torrent_resolution = '1280*720';
                            }

                            $torrent = new Torrent();
                            $torrent->movie_id = $movie->id;
                            $torrent->hash = $torrent_hash;
                            $torrent->quality = $torrent_quality;
                            $torrent->type = $torrent_type;
                            $torrent->seeds = $torrent_seeds;
                            $torrent->peers = $torrent_peers;
                            $torrent->size_bytes = $torrent_size_bytes;
                            $torrent->file = "/".$torrent_file;
                            $torrent->resolution = $torrent_resolution;
                            $torrent->created_at = (!empty($t->date_uploaded)) ? $t->date_uploaded : date('Y-m-d H:i:s');
                            $torrent->save();
                        }
                    }
                }

                $movie->omdbUpdate();
                $movie->save();

                return redirect()->back()->withSuccess($movie->title_long.' Movie & Torrents successfully added');
            }
            else{
                return redirect()->back()->withErrors($check->title_long.' Movie already exists in database');
            }

        }
        else{
            return redirect()->back()->withErrors('Invalid Movie Id');
        }
	}
	
	public function ytsGetDateUploaded()
	{
        $scrapper = \App\Models\Scrapper::where('name','yts_get_date_uploaded')->firstOrfail();
        if ($scrapper->active != 1) {
            return 'srapper inactive';
        }
        
        
        $movies = Movie::whereNull('date_uploaded')->whereNotNull('yts_id')->orderBy('created_at','DESC')->limit(10)->get();
        
        if(empty($movies)) return 'no movies to add date uploaded';
        
        foreach($movies as $movie)
        {
            try{
                $data = file_get_contents(config('settings.yts_api').'movie_details.json?movie_id='.$movie->yts_id);
            }               
            catch(\Exception $e)
            {
                return 'api error';
            }     
            

            $data = json_decode($data);
    
            if($data->status == "ok")
            {
                $date_uploaded = (!empty($data->data->movie->date_uploaded)) ? $data->data->movie->date_uploaded : '';
                Movie::where('id',$movie->id)->update(['date_uploaded' => $date_uploaded]);
                echo $movie->title_long." date uploaded added<br/>";
            }
        }        
	}

    public function ytsGetAll()
    {
        $scrapper = \App\Models\Scrapper::where('name','yts_get_all')->firstOrfail();
        if ($scrapper->active != 1) {
            return 'srapper inactive';
        }

        if (empty($scrapper->yts_ids)) 
        {            

            try{
                $list = file_get_contents(config('settings.yts_api').'list_movies.json?page='.$scrapper->page.'&limit='.$scrapper->limit.'&sort_by=year&order_by=asc');
                $list = json_decode($list);
            }
            catch(\Exception $e){
                return 'api error';
            }
            if($list->status != 'ok') return 'api error';

            if(empty($list->data->movies)){ 
                $scrapper->page = 1;
                $scrapper->save();
                return 'api error';
            }

            $yts_ids = [];
            foreach ($list->data->movies as $list_movie) {
                array_push($yts_ids, $list_movie->id);
            }
            
            $already_exists = Movie::whereIn('yts_id',$yts_ids)->get(['yts_id'])->pluck(['yts_id'])->toArray();
            $yts_ids = array_diff($yts_ids,$already_exists);            

            $scrapper->page = $scrapper->page + 1;            
            $scrapper->yts_ids = implode(',', $yts_ids);
            
            if(!empty($scrapper->reset_page_from))
            {
                if($scrapper->page >= $scrapper->reset_page_from) $scrapper->page = 1;
            }
            
            $scrapper->save();
        }   

        $yts_ids = explode(',', $scrapper->yts_ids);

        $yts_id = array_shift($yts_ids);

        $scrapper->yts_ids = implode(',', $yts_ids);
        $scrapper->save();

        $movie = Movie::where('yts_id',$yts_id)->first(['id','title']);
        if(!empty($movie)){
            return 'already exists';
        }
        return $this->getYTSMovie($yts_id);
    }

    public function ytsGetLatest()
    {
        $scrapper = \App\Models\Scrapper::where('name','yts_get_latest')->firstOrfail();
        if ($scrapper->active != 1) {
            return 'srapper inactive';
        }

        if (empty($scrapper->yts_ids)) 
        {            
            if (strtotime(date('Y-m-d')) == strtotime($scrapper->updated_at->format('Y-m-d'))) {
                return 'done for today';
            }

            try{
                $list = file_get_contents(config('settings.yts_api').'list_movies.json?page='.$scrapper->page.'&limit='.$scrapper->limit.'&sort_by=date_added&order_by=desc');
                $list = json_decode($list);
            }
            catch(\Exception $e){
                return 'api error';
            }
            if($list->status != 'ok') return 'api error';

            if(empty($list->data->movies)){ 
                $scrapper->page = 1;
                $scrapper->save();
                return 'api error';
            }

            $yts_ids = [];
            foreach ($list->data->movies as $list_movie) {
                array_push($yts_ids, $list_movie->id);
            }
            
            $already_exists = Movie::whereIn('yts_id',$yts_ids)->get(['yts_id'])->pluck(['yts_id'])->toArray();
            $yts_ids = array_diff($yts_ids,$already_exists);            

            $scrapper->page = $scrapper->page + 1;            
            $scrapper->yts_ids = implode(',', $yts_ids);

            if(!empty($scrapper->reset_page_from))
            {
                if($scrapper->page >= $scrapper->reset_page_from) $scrapper->page = 1;
            }            
            
            $scrapper->save();
        }   

        $yts_ids = explode(',', $scrapper->yts_ids);

        $yts_id = array_shift($yts_ids);

        $scrapper->yts_ids = implode(',', $yts_ids);
        $scrapper->save();

        $movie = Movie::where('yts_id',$yts_id)->first(['id','title']);
        if(!empty($movie)){
            return 'already exists';
        }
        return $this->getYTSMovie($yts_id);
    }

    public function ytsGetByQuery(Request $request)
    {
        $scrapper = \App\Models\Scrapper::where('name','yts_get_by_query_'.$request->term)->first();

        if (empty($scrapper)) {
            $scrapper = new \App\Models\Scrapper();
            $scrapper->name = 'yts_get_by_query_'.$request->term;
            $scrapper->page = 1;
            $scrapper->limit = 50;
            $scrapper->active = 1;
            $scrapper->save();         
        }

        if ($scrapper->active != 1) {
            return 'scrapper inactive';
        }

        if (empty($scrapper->yts_ids)) 
        {            
            try{
                $query_term = '';
                if (!empty($request->term)) {
                    $query_term = '&query_term='.$request->term;
                }
                $list = file_get_contents(config('settings.yts_api').'list_movies.json?page='.$scrapper->page.'&limit='.$scrapper->limit.'&sort_by=year&order_by=desc'.$query_term);
                $list = json_decode($list);
            }
            catch(\Exception $e){
                return 'api error - '.$e->getMessage();
            }
            if($list->status != 'ok') return 'api error';

            if(empty($list->data->movies)){ 
                $scrapper->page = 1;
                $scrapper->save();
                return 'api error';
            }

            $yts_ids = [];
            foreach ($list->data->movies as $list_movie) {
                array_push($yts_ids, $list_movie->id);
            }
            
            $already_exists = Movie::whereIn('yts_id',$yts_ids)->get(['yts_id'])->pluck(['yts_id'])->toArray();
            $yts_ids = array_diff($yts_ids,$already_exists);
            
            $scrapper->page = $scrapper->page + 1;            
            $scrapper->yts_ids = implode(',', $yts_ids);
            
            if(!empty($scrapper->reset_page_from))
            {
                if($scrapper->page >= $scrapper->reset_page_from) $scrapper->page = 1;
            }            
            
            $scrapper->save();
        }   
 
        $yts_ids = explode(',', $scrapper->yts_ids);

        $yts_id = array_shift($yts_ids);
        
        $scrapper->yts_ids = implode(',', $yts_ids);
        $scrapper->save();

        $movie = Movie::where('yts_id',$yts_id)->first(['id','title']);
        if(!empty($movie)){
            return 'already exists';
        }
        return $this->getYTSMovie($yts_id);
    }        

    protected static function getYTSMovie($id)
    {
        if(is_numeric($id)){
            try{
                $data = file_get_contents(config('settings.yts_api').'movie_details.json?movie_id='.$id.'&with_images=true&with_cast=true');
            }               
            catch(\Exception $e)
            {
                return 'api error';
            }            
        }
        elseif(starts_with($id,'tt')){
            $data = file_get_contents(config('settings.yts_api').'list_movies.json?query_term='.$id);
            $data = json_decode($data);
            if($data->status == "ok"){
                if($data->data->movie_count == 1){
                    if(empty($data->data->movies)) return 'api error';
                    $id = $data->data->movies[0]->id;

                    try{
                        $data = file_get_contents(config('settings.yts_api').'movie_details.json?movie_id='.$id.'&with_images=true&with_cast=true');
                    }
                    catch(\Exception $e)
                    {
                        return 'api error';
                    }                    
                }
                else{
                    return 'not added';
                }
            }
            else{
                return 'not added';
            }
        }   
        else{
            return 'not added';
        }


        $data = json_decode($data);

        if($data->status == "ok")
        {
            $imdb_code = $data->data->movie->imdb_code;
            $title = $data->data->movie->title_english;
            $title_long = $data->data->movie->title_long;

            $check = Movie::where('imdb_code',$imdb_code)->first();
            if(empty($check))
            {
                $slug = $data->data->movie->slug;
                $year = $data->data->movie->year;
                $rating = $data->data->movie->rating;
                $runtime = $data->data->movie->runtime;
                $genres = (!empty($data->data->movie->genres)) ? str_replace('&',',',implode(',',$data->data->movie->genres)) : '';
                $description_full = $data->data->movie->description_full;
                $yt_trailer_code = (!empty($data->data->movie->yt_trailer_code)) ? $data->data->movie->yt_trailer_code : '';
                $language = $data->data->movie->language;
                $mpa_rating = $data->data->movie->mpa_rating;
                $download_count = 0;

                try{
                    $tmdb = file_get_contents('https://api.themoviedb.org/3/movie/'.$imdb_code.'?api_key=443880ff623cdfa7c3599a4d56c167ff');
                }
                catch(\Exception $e)
                {
                    $tmdb = json_encode([]);
                }  

                $tmdb = json_decode($tmdb);
                 
                if(!empty($tmdb->poster_path)) 
                {
                    $cover_image_path = 'https://image.tmdb.org/t/p/w342'.$tmdb->poster_path;
                }
                else{
                    $destinationPath = 'images/movies/'.str_slug($title_long.' '.$imdb_code);
                    if (!file_exists($destinationPath)) {
                        mkdir($destinationPath, 0775, true);
                        chmod($destinationPath, 0775);       
                    }
                
                    $small_cover_image = $destinationPath."/"."cover-small.jpg";
                    $medium_cover_image = $destinationPath."/"."cover-medium.jpg";
                    $large_cover_image = $destinationPath."/"."cover-large.jpg";

                    if(!empty($data->data->movie->medium_cover_image)){ 
                        try{
                            file_put_contents($medium_cover_image, fopen($data->data->movie->medium_cover_image, 'r'));
                        }
                        catch(\Exception $e)
                        {
                            $medium_cover_image = $destinationPath."/"."cover-medium.jpg";
                        }
                    }

                    $cover_image_path = "/".$medium_cover_image;
                    
                }
                
                if(!empty($tmdb->backdrop_path))
                {
                    $background_image_path = 'https://image.tmdb.org/t/p/w1280'.$tmdb->backdrop_path;
                }
                else{
                    $destinationPath = 'images/movies/'.str_slug($title_long.' '.$imdb_code);
                    if (!file_exists($destinationPath)) {
                        mkdir($destinationPath, 0775, true);
                        chmod($destinationPath, 0775);       
                    }
                    $background_image = $destinationPath."/"."background.jpg";
                    if(!empty($data->data->movie->background_image)){
                        try{                        
                            file_put_contents($background_image, fopen($data->data->movie->background_image, 'r'));
                        }
                        catch(\Exception $e)
                        {
                            $background_image = $destinationPath."/"."background.jpg";
                        }                        
                    }
                    $background_image_path = "/".$background_image;                    
                }

                $artistPath = 'uploads/artists/';
                if (!file_exists($artistPath)) {
                    mkdir($artistPath, 0775, true);
                    chmod($artistPath, 0775);       
                }                
                $artists = [];

                if(!empty($data->data->movie->cast))
                {
                    foreach ($data->data->movie->cast as $c) {
                        $artist_name = trim($c->name);

                        $check = Artist::where('name',$artist_name)->first();
                        if(empty($check)){
                            $artist = new Artist();
                            $artist->imdb_code = trim($c->imdb_code);
                            if(!empty($c->url_small_image)){
                                $artist_photo = $artistPath.str_slug($artist_name)."-".$artist->imdb_code.".jpg";

                                try{
                                //    file_put_contents($artist_photo, fopen($c->url_small_image, 'r'));
                                }
                                catch(\Exception $e)
                                {
                                    continue;
                                }                                
                                $artist_photo = "/".$artist_photo;
                             //   $artist->photo = $artist_photo;
                            }                       
                            $artist->name = $artist_name;
                            $artist->save();
                        }
                        array_push($artists, $artist_name);
                    }
                }


                $movie = Movie::where('yts_id',$id)->first(['id','title']);
                if(!empty($movie)){
                    return 'already exists';
                }

                $movie = new Movie();
                $movie->yts_id = $data->data->movie->id;
                $movie->imdb_code = $imdb_code;
                $movie->title = $title;
                $movie->title_long = $title_long;
                //$movie->slug = $slug;
                $movie->year = $year;
                $movie->rating = $rating;
                $movie->runtime = $runtime;
                $movie->genres = $genres;
                $movie->description_full = $description_full;
                if(!empty($yt_trailer_code)) $movie->yt_trailer_code = $yt_trailer_code;
                $movie->language = $language;
                $movie->mpa_rating = $mpa_rating;
                $movie->download_count = (!empty($data->data->movie->download_count)) ? $data->data->movie->download_count : 0;
                $movie->like_count = $data->data->movie->like_count;
                $movie->background_image = $background_image_path;
                $movie->cover_image = $cover_image_path;
                $movie->cast = implode(',', $artists);
                $movie->active = 1;
                $movie->user_id = 1;
                $movie->created_at = (!empty($data->data->movie->date_uploaded)) ? $data->data->movie->date_uploaded : date('Y-m-d H:i:s'); 
                $movie->date_uploaded = (!empty($data->data->movie->date_uploaded)) ? $data->data->movie->date_uploaded : date('Y-m-d H:i:s');
                $movie->save();

                if(!empty($data->data->movie->torrents))
                {
                    $torrentPath = 'uploads/movies/'.str_slug($title_long.' '.$imdb_code);
                    if (!file_exists($torrentPath)) 
                    {
                        mkdir($torrentPath, 0775, true);
                        chmod($torrentPath, 0775);       
                    }                     
                    foreach($data->data->movie->torrents as $t)
                    {
                        $torrent_hash = trim($t->hash);
                        $check = Torrent::where('hash',$torrent_hash)->first();
                        if(empty($check))
                        {
                            $torrent_quality = trim($t->quality);
                            $torrent_type = trim($t->type);
                            $torrent_seeds = trim($t->seeds);
                            $torrent_peers = trim($t->peers);
                            $torrent_size_bytes = trim($t->size_bytes);
                            $torrent_file = $torrentPath."/".str_slug($title_long)."-".$torrent_quality.".torrent";
                            try{
                              //  file_put_contents($torrent_file, fopen($t->url, 'r'));
                            }
                            catch(\Exception $e)
                            {
                                continue;
                            }

                            if($torrent_quality == '3D'){
                                $torrent_resolution = '1920*1080';
                            }
                            elseif($torrent_quality == '2160p'){
                                $torrent_resolution = '3840*2160';
                            }                            
                            elseif($torrent_quality == '1080p'){
                                $torrent_resolution = '1920*1080';
                            }
                            elseif ($torrent_quality == '720p') {
                                $torrent_resolution = '1280*720';
                            }
                            else{
                                $torrent_resolution = '1280*720';
                            }

                            $torrent = new Torrent();
                            $torrent->movie_id = $movie->id;
                            $torrent->hash = $torrent_hash;
                            $torrent->quality = $torrent_quality;
                            $torrent->type = $torrent_type;
                            $torrent->seeds = $torrent_seeds;
                            $torrent->peers = $torrent_peers;
                            $torrent->size_bytes = $torrent_size_bytes;
                            $torrent->file = "/".$torrent_file;
                            $torrent->resolution = $torrent_resolution;
                            $torrent->created_at = $t->date_uploaded;
                            $torrent->save();
                        }
                    }
                }
                
                $movie->omdbUpdate();
                $movie->save();                

                return 'added';
            }
            else{
                return 'not added';
            }

        }
        else{
            return 'not added';
        }        
    }

    public function yifyGetAllSubtitles()
    {
        $scrapper = \App\Models\Scrapper::where('name','yify_get_all_subtitles')->firstOrfail();
        if ($scrapper->active != 1) {
            return 'srapper inactive';
        }    
        $movie = Movie::whereNull('subtitle_updated_at')->orderBy('created_at')->firstOrfail();
        $movie->subtitle_updated_at = date('Y-m-d H:i:s');
        $movie->save();

        return $movie->yifySubtitlesUpdate();
    }    

    public function yifyGetByYearSubtitles(Request $request)
    {
        if(empty($request->year)) die('year parameter missing');
        $scrapper = \App\Models\Scrapper::where('name','yify_get_year_subtitles')->firstOrfail();
        if ($scrapper->active != 1) {
            return 'srapper inactive';
        }    
        $movie = Movie::whereNull('subtitle_updated_at')->where('year',$request->year)->firstOrfail();
        if(empty($movie))
        {
            $movie = Movie::where('subtitle_updated_at',now()->subDays(30))->where('year',$request->year)->firstOrfail();
        }
        
        $movie->subtitle_updated_at = date('Y-m-d H:i:s');
        $movie->save();

        return $movie->yifySubtitlesUpdate();
    } 

    public function yifyUpdateSubtitles()
    {
        $scrapper = \App\Models\Scrapper::where('name','yify_update_subtitles')->firstOrfail();
        if ($scrapper->active != 1) {
            return 'srapper inactive';
        }    
        if (empty($scrapper->yts_ids)) {
            return 'nothing to scrap';
        }

        $imdb_codes = explode(',', $scrapper->yts_ids);

        $imdb_code = array_shift($imdb_codes);

        $scrapper->yts_ids = implode(',', $imdb_codes);
        $scrapper->save();

        $movie = Movie::where('imdb_code',$imdb_code)->firstOrfail();
        $movie->subtitle_updated_at = date('Y-m-d H:i:s');
        $movie->save();

        return $movie->yifySubtitlesUpdate();
    }


    public function yify(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'movie_id' => 'required|alpha_num|exists:movie,imdb_code',
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator);
        }        

        $scrapper = \App\Models\Scrapper::where('name','yify_update_subtitles')->firstOrfail();

        $imdb_codes = explode(',', $scrapper->yts_ids);

        if(!in_array($request->movie_id, $imdb_codes)) 
        {
            array_unshift($imdb_codes,$request->movie_id);
            $imdb_codes = array_filter($imdb_codes);
            $scrapper->yts_ids = implode(',', $imdb_codes);
            $scrapper->save();     
        }
        else{
            $pos = array_search($request->movie_id, $imdb_codes);
            unset($imdb_codes[$pos]);
            array_unshift($imdb_codes,$request->movie_id);
            $imdb_codes = array_filter($imdb_codes);
            $scrapper->yts_ids = implode(',', $imdb_codes);
            $scrapper->save();                
        }

        return redirect()->back()->withSuccess('Movie successfully added to queue for grab');
    }
}
	