<?php 
namespace App\Http\Controllers\Admin;

use Backpack\CRUD\app\Http\Controllers\CrudController;
use Illuminate\Http\Request;

// VALIDATION: change the requests to match your own file names if you need form validation
use App\Http\Requests\SeasonCrudRequest as StoreRequest;
use App\Http\Requests\SeasonCrudRequest as UpdateRequest;

use App\Models\Genre;
use App\Models\Series;
use App\Models\Season;
use App\Models\STorrent;
use App\Models\SDownload;
use App\Models\SVote;

use Validator;
use Config;
use Symfony\Component\DomCrawler\Crawler;

class SeasonCrudController extends CrudController {

    public function setup() 
    {
        $this->crud->setModel("App\Models\Season");
        $this->crud->setRoute("admin/seasons");
        $this->crud->setEntityNameStrings('season', 'seasons');
        if(!empty(request()->get('series_id'))) $this->crud->addClause('where', 'series_id', request()->get('series_id'));
        $this->crud->setCreateView("admin.season.create");
        $this->crud->setEditView("admin.season.edit");

        $this->crud->setColumns([
        [    // SELECT
            'label'         => 'Series',
            'type'          => 'select',
            'name'          => 'series_id',
            'entity'        => 'series',
            'attribute'     => 'title_long',
            'model'         => "App\Models\Series",
            'tab'           => 'Selects',
        ]
        ,'name','air_date','season_number','tmdb_id',['name'=>'active','type'=>'check']]);        

        $this->crud->addFields([
          [
            'name' => 'series_id',
            'type' => 'hidden',
            'value' => request()->get('series_id'),
          ],           
          [
            'name' => 'name',
            'type' => 'text',
            'wrapperAttributes' => ['class' => 'col-md-6 form-group'],
          ],          
          [
            'name' => 'slug',
            'type' => 'text',
            'wrapperAttributes' => ['class' => 'col-md-6 form-group'],
          ],          
          [
            'name' => 'season_number',
            'type' => 'number',
            'wrapperAttributes' => ['class' => 'col-md-6 form-group'],
          ],          
          [
            'name' => 'tmdb_id',
            'type' => 'number',
            'wrapperAttributes' => ['class' => 'col-md-6 form-group'],
          ],
          [
            'name' => 'air_date',
            'type' => 'date',
            'wrapperAttributes' => ['class' => 'col-md-6 form-group'],
          ],          
          [
            'name' => 'cover_image',
            'type' => 'text',
            'wrapperAttributes' => ['class' => 'col-md-6 form-group'],
          ],                   
          [
            'name' => 'description_full',
            'type' => 'textarea',
            'wrapperAttributes' => ['class' => 'col-md-12 form-group'],
          ],
          [
            'name' => 'active',
            'type' => 'checkbox',
            'value' => 1,
            'wrapperAttributes' => ['class' => 'col-md-6 form-group'],
          ] 

        ]);

        $this->crud->enableAjaxTable(['name','tmdb_id']);
        $this->crud->removeButton('create');
        //$this->crud->denyAccess('create');
        if(!empty(request()->get('series_id'))) $this->crud->addButtonFromView('top', 'add_season', 'add_season', 'end'); 
        //$this->crud->removeButton('update');
        //$this->crud->addButtonFromView('top', 'add_movie', 'add', 'end'); 
       // $this->crud->addButtonFromView('line', 'edit_movie', 'edit', 'beginning'); 
        $this->crud->addButtonFromView('line', 'episodes', 'episodes', 'beginning'); 
        if(!empty(request()->get('series_id'))) $this->crud->addButtonFromView('top', 'back_to_series', 'back_to_series', 'beginning'); 

        $this->crud->addButtonFromView('line', 'torrent', 'torrent', 'beginning'); 
       // $this->crud->addButtonFromView('line', 'video', 'video', 'beginning'); 
       // $this->crud->addButtonFromModelFunction('line', 'open_google', 'openGoogle', 'beginning'); 
        $this->crud->enableDetailsRow();
        $this->crud->allowAccess('details_row');


        $this->crud->addFilter([ // dropdown filter
          'name' => 'torrents',
          'type' => 'dropdown',
          'label'=> 'Torrents',
          'placeholder' => 'Torrents'
        ], [
          '1' => 'Has',
          '2' => 'Has not',
        ], function($value) { // if the filter is active

            $has = [];
            $hasNot = [];
            foreach($this->crud->getEntries() as $ce)
            {
                $check = \App\Models\STorrent::where('series_id',$ce->series_id)->where('season_number',$ce->season_number)->first(['id']);
                if(!empty($check)) array_push($has, $ce->id);
                else array_push($hasNot, $ce->id);
            }

            if($value == '1') $this->crud->addClause('whereIn', 'id',$has);
            else $this->crud->addClause('whereIn', 'id',$hasNot);
        });
           
        if(empty(request()->get('order'))) $this->crud->orderBy('created_at','DESC');            
    } 

   /* public function create()
    {
        $series = Series::findOrfail(\Route::current()->parameter('series'));
        return view('admin.season.create',compact('series'));
    }  

    public function store(Request $request)
    {
       $validator = Validator::make($request->all(), [
            'series_id' => 'required|numeric|exists:series,id',
            'title' => 'required|max:100',
            'title_long' => 'required|max:120|unique:season,title_long',
            'imdb_code' => 'required|max:120|unique:season,imdb_code',
            'year' => 'required|numeric',
            'rating' => 'required|numeric|min:1|max:10',
            'runtime' => 'required|numeric',
            'genres' => 'required',
            'cast' => 'required',
            'active' => 'required|in:0,1',
            'director' => '',
            'description_full' => 'required',
            'yt_trailer_code' => 'required',
            'language' => 'required',
            'mpa_rating' => 'required',
            'tomato_critics' => 'required|min:1|max:100',
            'tomato_audience' => 'required|min:1|max:100',
            'cover_image' => 'required|mimes:jpg,jpeg,png|max:'.Config::Get('settings.max_screenshot_size'),            
            'screenshots.*' => 'mimes:jpg,jpeg,png|max:'.Config::Get('settings.max_screenshot_size'),
            'background_image' => 'mimes:jpg,jpeg,png|max:'.Config::Get('settings.max_screenshot_size'),
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }
        else {   
          $season = new Season();
          $season->title = $request->title;
          $season->series_id = $request->series_id;
          $season->title_long = $request->title_long;
          $season->imdb_code = $request->imdb_code;
          $season->year = $request->year;
          $season->rating = $request->rating;
          $season->runtime = $request->runtime;
          $season->genres = implode(',', $request->genres);
          $season->cast = $request->cast;
          $season->director = $request->director;
          $season->description_full = $request->description_full;
          $season->yt_trailer_code = $request->yt_trailer_code;
          $season->language = $request->language;
          $season->mpa_rating = $request->mpa_rating;
          $season->tomato_critics = $request->tomato_critics;
          $season->tomato_audience = $request->tomato_audience;
          $season->active = $request->active;
          $season->direct_link = $request->direct_link;

          $series = Series::findOrfail($request->series_id);
            $destinationPath = 'images/series/'.str_slug($series->slug).'/'.str_slug($request->title_long);
            if (!file_exists($destinationPath)) {
        mkdir($destinationPath, 0777, true);
        chmod($destinationPath, 0777);       
      }

          $cover_image = $request->file('cover_image');
            $file_ext = $cover_image->getClientOriginalExtension();            
            $new_file_name = "cover-original.".$file_ext;
      $cover_image->move($destinationPath,$new_file_name);    
      $original_cover_image = $destinationPath."/".$new_file_name;


      $img = \Image::make($original_cover_image);
      $img->resize(230, 345);
      $resized_cover_image = $destinationPath."/"."cover-medium.".$file_ext;
      $img->save($resized_cover_image);      
      $season->cover_image = "/".$resized_cover_image;
      

      if ($request->hasFile('background_image')) {

            $background_image = $request->file('background_image');         
        $file_ext = $background_image->getClientOriginalExtension();  
        $new_file_name = "background.".$file_ext;
        $background_image->move($destinationPath,$new_file_name); 
        $season->background_image = "/".$destinationPath."/".$new_file_name;   
      }

      if($request->hasFile('screenshots')){
        $screenshots = array();
        $i = 1;
        foreach($request->file('screenshots') as $screenshot) {
          $file_ext = $screenshot->getClientOriginalExtension();  
          $new_file_name = "screenshot-".$i.".".$file_ext;
          $screenshot->move($destinationPath,$new_file_name); 
          array_push($screenshots, "/".$destinationPath."/".$new_file_name);
          $i++;                 
        }
        $season->screenshots = json_encode(array_values($screenshots));
      }


      $season->save();
      return redirect()->back()->withSuccess('Season successfully added.')->withInput();
        }

    }

    public function edit($series_id,$season_id)
    {
      $season = Season::findOrfail($season_id);
      $series = Series::findOrfail($series_id);
      return view('admin.season.edit',compact('series','season'));
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'series_id' => 'required|numeric|exists:series,id',
            'id' => ' required|numeric|exists:season,id',
            'title' => 'required|max:100',
            'title_long' => 'required|max:120|unique:season,title_long,'.$request->id,
            'imdb_code' => 'required|max:120|unique:season,imdb_code,'.$request->id,
            'year' => 'required|numeric',
            'rating' => 'required|numeric|min:1|max:10',
            'runtime' => 'required|numeric',
            'genres' => 'required',
            'cast' => 'required',
            'active' => 'required|in:0,1',
            'director' => '',
            'description_full' => 'required',
            'yt_trailer_code' => 'required',
            'language' => 'required',
            'mpa_rating' => 'required',
            'tomato_critics' => 'required|min:1|max:100',
            'tomato_audience' => 'required|min:1|max:100',
            'cover_image' => 'mimes:jpg,jpeg,png|max:'.Config::Get('settings.max_screenshot_size'),            
            'screenshots.*' => 'mimes:jpg,jpeg,png|max:'.Config::Get('settings.max_screenshot_size'),
            'background_image' => 'mimes:jpg,jpeg,png|max:'.Config::Get('settings.max_screenshot_size'),
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }
        else {   
          $series = Series::findOrfail($request->series_id);
          $season = Season::findOrfail($request->id);
          $season->title = $request->title;
          $season->title_long = $request->title_long;
          $season->imdb_code = $request->imdb_code;
          $season->year = $request->year;
          $season->rating = $request->rating;
          $season->runtime = $request->runtime;
          $season->genres = implode(',', $request->genres);
          $season->cast = $request->cast;
          $season->director = $request->director;
          $season->description_full = $request->description_full;
          $season->yt_trailer_code = $request->yt_trailer_code;
          $season->language = $request->language;
          $season->mpa_rating = $request->mpa_rating;
          $season->tomato_critics = $request->tomato_critics;
          $season->tomato_audience = $request->tomato_audience;
          $season->active = $request->active;
          $season->direct_link = $request->direct_link;

            $destinationPath = 'images/series/'.str_slug($series->slug).'/'.str_slug($request->title_long);
            if (!file_exists($destinationPath)) {
        mkdir($destinationPath, 0777, true);
        chmod($destinationPath, 0777);       
      }

      if ($request->hasFile('cover_image')) {
            $cover_image = $request->file('cover_image');
              $file_ext = $cover_image->getClientOriginalExtension();            
              $new_file_name = "cover-original.".$file_ext;
        $cover_image->move($destinationPath,$new_file_name);    
        $original_cover_image = $destinationPath."/".$new_file_name;


        $img = \Image::make($original_cover_image);
        $img->resize(230, 345);
        $resized_cover_image = $destinationPath."/"."cover-medium.".$file_ext;
        $img->save($resized_cover_image);      
        $season->cover_image = "/".$resized_cover_image;
      }

      if ($request->hasFile('background_image')) {
            $background_image = $request->file('background_image');         
        $file_ext = $background_image->getClientOriginalExtension();  
        $new_file_name = "background.".$file_ext;
        $background_image->move($destinationPath,$new_file_name); 
        $season->background_image = "/".$destinationPath."/".$new_file_name;   
      }

      if($request->hasFile('screenshots')){
        $screenshots = array();
        $i = 1;
        foreach($request->file('screenshots') as $screenshot) {
          $file_ext = $screenshot->getClientOriginalExtension();  
          $new_file_name = "screenshot-".$i.".".$file_ext;
          $screenshot->move($destinationPath,$new_file_name); 
          array_push($screenshots, "/".$destinationPath."/".$new_file_name);
          $i++;                 
        }
        $season->screenshots = json_encode(array_values($screenshots));
      }


      $season->save();
      return redirect()->back()->withSuccess('Season successfully updated');
        }       
    }
*/

    public function create()
    {
        $this->crud->hasAccessOrFail('create');

        // prepare the fields you need to show
        $this->data['crud'] = $this->crud;
        $this->data['saveAction'] = $this->getSaveAction();
        $this->data['fields'] = $this->crud->getCreateFields();
        $this->data['title'] = trans('backpack::crud.add').' '.$this->crud->entity_name;
        $entry = collect();
        $entry->series_id = 1;
        $this->data['entry'] = $entry;

        // load the view from /resources/views/vendor/backpack/crud/ if it exists, otherwise load the one in the package
        return view($this->crud->getCreateView(), $this->data);
    }

    public function store(StoreRequest $request)
    {
        // your additional operations before save here
        $redirect_location = parent::storeCrud();
        return redirect()->back();
        // your additional operations after save here
        // use $this->data['entry'] or $this->crud->entry
     //   return $redirect_location;
    }

    public function update(UpdateRequest $request)
    {
        // your additional operations before save here
        $redirect_location = parent::updateCrud();
        return redirect()->back();
       // dd($redirect_location);
        // your additional operations after save here
        // use $this->data['entry'] or $this->crud->entry
        return $redirect_location;
    }

    public function destroy($id)
    {
      $season = Season::findOrfail($id);
      $series = Series::findOrfail($season->series_id);
      $imageFolderPath = 'images/series/'.str_slug($series->title_long).'/'.str_slug($season->title_long);
      $torrentFolderPath = 'uploads/series/'.str_slug($series->title_long).'/'.str_slug($season->title_long);
      if(file_exists($imageFolderPath)){        
        chmod($imageFolderPath, 0777);  
        array_map('unlink', glob($imageFolderPath.'/*'));
        rmdir($imageFolderPath);
      }      
      if(file_exists($torrentFolderPath)){
        chmod($torrentFolderPath, 0777);  
        array_map('unlink', glob($torrentFolderPath.'/*'));
        rmdir($torrentFolderPath);
      }
      STorrent::where('season_id',$season->id)->delete();
      SDownload::where('season_id',$season->id)->delete();
      SVote::where('season_id',$season->id)->delete();
      return $this->crud->delete($id);
    } 

    public function showDetailsRow($id)
    {
        $this->data['entry'] = $this->crud->getEntry($id);
        $this->data['crud'] = $this->crud;

        // load the view from /resources/views/vendor/backpack/crud/ if it exists, otherwise load the one in the package
        return view('crud::details_row.season', $this->data);
    } 
    

    public function tgxStore(Request $request)
    {
        config(['app.debug'=>true]);
        $validator = Validator::make($request->all(), [
            'series_id' => 'required|numeric|exists:series,id',
            'season_number' => ' required|numeric',
            'page_link' => 'required|url'
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }  
        
        try{
            $html = $this->curl_get_contents($request->page_link);
        }
        catch(\Exception $e){
            return $e->getMessage();
        }
        
        $series = \App\Models\Series::where('id',$request->series_id)->firstOrfail();
        $season = \App\Models\Season::where('series_id',$request->series_id)->where('season_number',$request->season_number)->firstOrfail();

        $crawler = new Crawler($html);
        
        $torrent_name = $crawler->filter('span.linebreakup')->eq(0)->text();
        
        $hash = $crawler->filter('span.linebreakup')->eq(1)->text();
        
        $magnet = $crawler->filter('a.btn-danger')->eq(0)->attr('href');
        
        $torrent_url = $crawler->filter('a.btn-success')->attr('href');
        
        $seeds = ($crawler->filter('font[color="green"]')->count() > 0) ? $crawler->filter('font[color="green"]')->text() : 0;
        $peers = ($crawler->filter('font[color="#ff0000"]')->count() > 0) ? $crawler->filter('font[color="#ff0000"]')->text() : 0;
        
        $torrent_size = 0;

        $torrent_size = $crawler->filter('div.limitwidth > div.tprow')->each(function($node){
 
            if(strpos($node->filter('div')->text(),'Size:') > 0)
            {
                $torrent_size = str_replace('Total Size:','',$node->filter('div')->text());
                $torrent_size = str_replace(',','',$torrent_size);
                $torrent_size = $this->toByteSize(trim($torrent_size));
                return $torrent_size;
            }
        });
        $torrent_size = (!empty(array_values(array_filter($torrent_size))[0])) ? array_values(array_filter($torrent_size))[0] : 0;
        $torrent_size = str_replace(',','',$torrent_size);
        

        $storrent = \App\Models\STorrent::where('hash',$hash)->where('series_id',$series->id)->where('season_number',$request->season_number)->first();
        if(empty($storrent))
        { 

            $storrent = new \App\Models\STorrent();
            $storrent->series_id = $series->id;
            $storrent->season_number = $request->season_number;
            $storrent->name = $torrent_name;
            $storrent->hash = $hash;
            $storrent->quality = $this->getQuality($torrent_name);
            $storrent->resolution = $this->getResolution($storrent->quality);
            $storrent->size_bytes = $torrent_size; 
            $storrent->magnet = $magnet; 

            $torrentPath = 'uploads/series/'.str_slug($series->title_long).'/'.str_slug('season '.$request->season_number);
            if (!file_exists($torrentPath)) {
                mkdir($torrentPath, 0775, true);
                chmod($torrentPath, 0775);       
            }                    
            $torrent_file = $torrentPath."/".str_slug($series->title_long)."-".str_slug($storrent->quality)."-".str_random(3).".torrent";
            try{    
               // file_put_contents($torrent_file, fopen($torrent_url, 'r'));  
                $torrent_file = "/".$torrent_file;  
            }   
            catch(\Exception $e)    
            {   
                $torrent_file = $magnet; 
            } 

            $storrent->file = $torrent_file;      

            $series->created_at = date('Y-m-d H:i:s');             
            $series->save();
            
            $status = "added";

        }
        else{
            $status = "updated";
        }

        $storrent->seeds = $seeds; 
        $storrent->peers = $peers; 
        $storrent->save();
      
        return redirect()->back()->withSuccess('Successfully '.$status)->withInput();
    } 
    
    public function t1337Store(Request $request)
    {
        config(['app.debug'=>true]);
        $validator = Validator::make($request->all(), [
            'series_id' => 'required|numeric|exists:series,id',
            'season_number' => ' required|numeric',
            'page_link' => 'required|url'
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }  
        
        try{
            $html = $this->curl_get_contents($request->page_link);
        }
        catch(\Exception $e){
            return $e->getMessage();
        }
        
        $series = \App\Models\Series::where('id',$request->series_id)->firstOrfail();
        $season = \App\Models\Season::where('series_id',$request->series_id)->where('season_number',$request->season_number)->firstOrfail();

        $crawler = new Crawler($html);
        
        $torrent_name = $crawler->filter('.box-info-heading')->text();
        $torrent_name = trim($torrent_name);
        
        $hash = $crawler->filter('.infohash-box > p > span')->text();
        
        $magnet = $crawler->filter('.box-info > div')->eq(1)->filter('div > ul > li > a')->attr('href');
        
        $torrent_url = $crawler->filter('.box-info > div')->eq(1)->filter('div > ul > li.dropdown')->filter('ul > li > a')->attr('href');
        
        $seeds = ($crawler->filter('.seeds')->count() > 0) ? $crawler->filter('.seeds')->text() : 0;
        $peers = ($crawler->filter('.leeches')->count() > 0) ? $crawler->filter('.leeches')->text() : 0;
        
        $torrent_size = 0;

        $torrent_size = $crawler->filter('ul.list')->eq(1)->filter('li')->each(function($node){
          
            if(strpos($node->filter('strong')->text(),'size') > 0)
            {
                $torrent_size = str_replace(',','',$node->filter('span')->text());
                $torrent_size = $this->toByteSize(trim($torrent_size));
                   
                return $torrent_size;
                
            }
        });

        $torrent_size = (!empty(array_values(array_filter($torrent_size))[0])) ? array_values(array_filter($torrent_size))[0] : 0;
        $torrent_size = str_replace(',','',$torrent_size);

          
        $storrent = \App\Models\STorrent::where('hash',$hash)->where('series_id',$series->id)->where('season_number',$request->season_number)->first();
        if(empty($storrent))
        { 

            $storrent = new \App\Models\STorrent();
            $storrent->series_id = $series->id;
            $storrent->season_number = $request->season_number;
            $storrent->name = $torrent_name;
            $storrent->hash = $hash;
            $storrent->quality = $this->getQuality($torrent_name);
            $storrent->resolution = $this->getResolution($storrent->quality);
            $storrent->size_bytes = $torrent_size; 
            $storrent->magnet = $magnet; 

            $torrentPath = 'uploads/series/'.str_slug($series->title_long).'/'.str_slug('season '.$request->season_number);
            if (!file_exists($torrentPath)) {
                mkdir($torrentPath, 0775, true);
                chmod($torrentPath, 0775);       
            }                    
            $torrent_file = $torrentPath."/".str_slug($series->title_long)."-".str_slug($storrent->quality)."-".str_random(3).".torrent";
            try{    
             //   file_put_contents($torrent_file, fopen($torrent_url, 'r'));  
                $torrent_file = "/".$torrent_file;  
            }   
            catch(\Exception $e)    
            {   
                $torrent_file = $magnet; 
            } 

            $storrent->file = $torrent_file;      

            $series->created_at = date('Y-m-d H:i:s');             
            $series->save();
            
            $status = "added";

        }
        else{
            $status = "updated";
        }

        $storrent->seeds = trim($seeds); 
        $storrent->peers = trim($peers); 
        $storrent->save();
      
        return redirect()->back()->withSuccess('Successfully '.$status)->withInput();
    }
    
    protected static function toByteSize($size) 
    {
        if(strpos($size,'KB') > 0)
        {
          $size = trim(str_replace('KB','',$size));
          return $fileSize = round($size * 1000);	
        }
        elseif(strpos($size,'MB') > 0)
        {
            $size = trim(str_replace('MB','',$size));
            return $fileSize = round($size * 1000 * 1000);	
        }
        elseif(strpos($size,'GB') > 0)
        {
            $size = trim(str_replace('GB','',$size));
            return $fileSize = round($size * 1000 * 1000 * 1000);	
        }
        else
        {
            return 0;
        }
    }

    protected static function getQuality($name)
    {
        if (strpos($name, '420p') !== false) {
            $quality = '420p';
        }
        elseif (strpos($name, 'HDCAM') !== false) {
            $quality = 'HDCAM';
        }        
        elseif (strpos($name, 'HDTS') !== false) {
            $quality = 'HDTS';
        }        
        elseif (strpos($name, '720p') !== false) {
            $quality = '720p';
        }
        elseif (strpos($name, '1080p') !== false) {
            $quality = '1080p';
        }         
        elseif (strpos($name, '2160p') !== false) {
            $quality = '2160p';
        }        
        elseif (strpos($name, 'blueray') !== false) {
            $quality = 'blueray';
        }        
        elseif (strpos($name, '3D') !== false) {
            $quality = '3D';
        }        
        else{
            $quality = '720p';
        }
        return $quality;
    }    

    protected static function getResolution($torrent_quality)
    {
        if($torrent_quality == '3D'){
            $torrent_resolution = '1920*1080';
        }
        elseif($torrent_quality == '2160p'){
            $torrent_resolution = '3840*2160';
        }                            
        elseif($torrent_quality == '1080p'){
            $torrent_resolution = '1920*1080';
        }
        elseif ($torrent_quality == '720p') {
            $torrent_resolution = '1280*720';
        }
        else{
            $torrent_resolution = '1280*720';
        }
        return $torrent_resolution;
    }
    
    protected static function curl_get_contents($url)
    {
        $user_agent='Mozilla/5.0 (Windows NT 6.1; rv:8.0) Gecko/20100101 Firefox/8.0';

        $options = array(

            CURLOPT_CUSTOMREQUEST  =>"GET",        //set request type post or get
            CURLOPT_POST           =>false,        //set to GET
            CURLOPT_USERAGENT      => $user_agent, //set user agent
            CURLOPT_COOKIEFILE     =>"cookie.txt", //set cookie file
            CURLOPT_COOKIEJAR      =>"cookie.txt", //set cookie jar
            CURLOPT_RETURNTRANSFER => true,     // return web page
            CURLOPT_HEADER         => false,    // don't return headers
            CURLOPT_FOLLOWLOCATION => true,     // follow redirects
            CURLOPT_ENCODING       => "",       // handle all encodings
            CURLOPT_AUTOREFERER    => true,     // set referer on redirect
            CURLOPT_CONNECTTIMEOUT => 120,      // timeout on connect
            CURLOPT_TIMEOUT        => 120,      // timeout on response
            CURLOPT_MAXREDIRS      => 10,       // stop after 10 redirects
            CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => 0
        );

        $ch      = curl_init( $url );
        curl_setopt_array( $ch, $options );
        $content = curl_exec( $ch );
        $err     = curl_errno( $ch );
        $errmsg  = curl_error( $ch );
        $header  = curl_getinfo( $ch );
        curl_close( $ch );

        $header['errno']   = $err;
        $header['errmsg']  = $errmsg;
        $header['content'] = $content;

        if($header['errno'] != 0) die('cURL Error - bad url, timeout, redirect loop');

        if ($header['http_code'] != 200) die('cURL Error - no page, no permissions, no service');

        return $header['content'];
    }    
}