<?php 
namespace App\Http\Controllers\Admin;

use App\Models\Movie;
use App\Models\Series;
use App\Models\Torrent;
use App\Models\Artist;
use App\Models\Video;
use App\Models\Subtitle;
use Illuminate\Support\Facades\Input;
use Illuminate\Http\Request;
use Validator;
use Config;
use Auth;
use Imdb;

use Illuminate\Routing\Controller as BaseController;
use Symfony\Component\DomCrawler\Crawler;

class TmdbController extends BaseController
{
	public function create()
	{
        return view('admin.scrapper.tmdb');
	}
	
	public function store(Request $request)
	{
        if(empty($request->movie_id)) return redirect()->back()->withErrors('IMDB ID is required');
        $id = $request->movie_id;
        
        $check = Movie::where('imdb_code',$id)->first();
        if(!empty($check)) return redirect()->back()->withErrors($check->title_long.' Movie already exits');
        
        try{
            $data = file_get_contents('https://api.themoviedb.org/3/movie/'.$id.'?api_key=443880ff623cdfa7c3599a4d56c167ff&language=en-US&append_to_response=videos,images,credits,keywords,alternative_titles');
        }
        catch(\Exception $e)
        {
            return redirect()->back()->withErrors($e->getMessage());
        }  
        
        $data = json_decode($data);
        
        $year = str_limit($data->release_date,4,'');
        $genres = [];
        
        foreach($data->genres as $g)
        {
            array_push($genres,$g->name);
        }
        array_push($genres,'Upcoming');
        
        $yt_trailer_code = (!empty($data->videos->results[0])) ? $data->videos->results[0]->key : '';
        $language = $data->original_language;
        
        $cover_image_path = 'https://image.tmdb.org/t/p/w342'.$data->poster_path;
        
        $background_image_path = (!empty($data->backdrop_path)) ? 'https://image.tmdb.org/t/p/w1280'.$data->backdrop_path : '';

        $movie = new Movie();
        $movie->imdb_code = $data->imdb_id ?? $id;
        $movie->title = $data->title;
        $movie->title_long = $data->title . " (".$year.")";
        $movie->year = $year;
        $movie->genres = str_replace('&',',',implode(',',$genres));

        if(!empty($yt_trailer_code)) $movie->yt_trailer_code = $yt_trailer_code;
        $movie->language = $language;
        $movie->background_image = $background_image_path;
        $movie->cover_image = $cover_image_path;
        $movie->active = 1;
        $movie->user_id = 1;
   
        try{
        $movie->save();     
        }
        catch(\Exception $e)
        {
            dd($e->getMessage());
        }
        
        $movie->omdbUpdate();
        $movie->save();     
                
        return redirect()->back()->withSuccess($movie->title_long.' Movie successfully added');
	}
}
	