<?php 
namespace App\Http\Controllers\Admin;

use App\Models\Movie;
use App\Models\Torrent;
use Illuminate\Support\Facades\Input;
use Illuminate\Http\Request;
use Validator;
use Config;

use Illuminate\Routing\Controller as BaseController;

class TorrentController extends BaseController
{
	public function index($id)
	{
		$movie = Movie::findOrfail($id);
		$torrents = Torrent::where('movie_id',$id)->get();
		return view('admin.movie.torrent.index',compact('movie','torrents'));
	}

	public function create($id)
	{
		$movie = Movie::findOrfail($id);
		return view('admin.movie.torrent.create',compact('movie'));
	}

	public function save($id,Request $request)
	{
		$movie = Movie::findOrfail($id);
		$validator = Validator::make($request->all(), [
            'quality' => 'required|max:200',
            'resolution' => 'required|max:200',
            'hash' => 'required|max:200|unique:torrent,hash',
            'peers' => 'required|numeric',
            'seeds' => 'required|numeric',
            'fps' => 'required',
            'size_bytes' => 'required|numeric',            
            'torrent_file' => 'required|max:'.config('settings.max_torrent_size'),            
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }
        else {  
        	$torrent = new Torrent();
        	$torrent->movie_id = $movie->id;
        	$torrent->hash = $request->hash;
        	$torrent->quality = $request->quality;
        	$torrent->resolution = $request->resolution;
        	$torrent->peers = $request->peers;
        	$torrent->seeds = $request->seeds;
        	$torrent->size_bytes = $request->size_bytes*1024*1024;
        	$torrent->fps = $request->fps;

 			$destinationPath = 'uploads/movies/'.$movie->slug;
            if (!file_exists($destinationPath)) {
				mkdir($destinationPath, 0777, true);
				chmod($destinationPath, 0777);       
			}

        	$torrent_file = $request->file('torrent_file');
            $file_ext = $torrent_file->getClientOriginalExtension();				     
            $new_file_name = str_slug($movie->title_long)."-".$request->quality.".".$file_ext;
			$torrent_file->move($destinationPath,$new_file_name);    
			$torrent->file = "/".$destinationPath."/".$new_file_name;

			$torrent->save();
			
			$movie->created_at = date('Y-m-d H:i:s');
			$movie->save();
			
			return redirect()->back()->withSuccess('Torrent successfully added.');
        }
	}


	public function edit($id,$torrent)
	{
		$movie = Movie::findOrfail($id);
		$torrent = Torrent::findOrfail($torrent);
		return view('admin.movie.torrent.edit',compact('movie','torrent'));
	}


	public function update($id,$torrent_id,Request $request)
	{
		$movie = Movie::findOrfail($id);
		$validator = Validator::make($request->all(), [
            'quality' => 'required|max:255',
            'resolution' => 'required|max:255',
            'hash' => 'required|max:255|unique:torrent,hash,'.$torrent_id,
            'peers' => 'required|numeric',
            'seeds' => 'required|numeric',
            'fps' => 'required',
            'size_bytes' => 'required|numeric',            
            'torrent_file' => 'max:'.Config::Get('settings.max_torrent_size'),            
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }
        else {  
        	$torrent = Torrent::findOrfail($torrent_id);
        	$torrent->movie_id = $movie->id;
        	$torrent->hash = $request->hash;
        	$torrent->quality = $request->quality;
        	$torrent->resolution = $request->resolution;
        	$torrent->peers = $request->peers;
        	$torrent->seeds = $request->seeds;
        	$torrent->size_bytes = $request->size_bytes*1024*1024;
        	$torrent->fps = $request->fps;

        	if($request->hasFile('torrent_file'))
        	{
	 			$destinationPath = 'uploads/movies/'.$movie->slug;
	            if (!file_exists($destinationPath)) {
					mkdir($destinationPath, 0777, true);
					chmod($destinationPath, 0777);       
				}

	        	$torrent_file = $request->file('torrent_file');
	            $file_ext = $torrent_file->getClientOriginalExtension();				     
	            $new_file_name = str_slug($movie->title_long)."-".$request->quality.".".$file_ext;
				$torrent_file->move($destinationPath,$new_file_name);    
				$torrent->file = "/".$destinationPath."/".$new_file_name;
			}

			$torrent->save();
			return redirect()->back()->withSuccess('Torrent successfully updated.');
        }
	}

	public function destroy($id,$torrent)
	{
		$torrent = Torrent::findOrfail($torrent);
		if(file_exists(ltrim($torrent->file,'/'))) unlink(ltrim($torrent->file,'/'));
		$torrent->delete();
		return redirect()->back()->withSuccess('Torrent successfully deleted.');
	}
}
	