<?php 
namespace App\Http\Controllers\Admin;

use App\Models\Movie;
use App\Models\Video;
use Illuminate\Support\Facades\Input;
use Illuminate\Http\Request;
use Validator;
use Config;

use Illuminate\Routing\Controller as BaseController;

class VideoController extends BaseController
{
	public function index($id)
	{
		$movie = Movie::findOrfail($id);
		$videos = Video::where('movie_id',$id)->get();
		return view('admin.movie.video.index',compact('movie','videos'));
	}

	public function create($id)
	{
		$movie = Movie::findOrfail($id);
		return view('admin.movie.video.create',compact('movie'));
	}

	public function save($id,Request $request)
	{
		$movie = Movie::findOrfail($id);
		$validator = Validator::make($request->all(), [
            'quality' => 'required|max:255',
            'source' => 'required|max:255',
            'video_link' => 'required'            
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }
        else {  
        	$video = new Video();
        	$video->movie_id = $movie->id;
        	$video->source = $request->source;
        	$video->quality = $request->quality;   

        	if(!starts_with('https',$request->video_link))
        	{
        		$video_link = 'https://openload.co/embed/'.$request->video_link;
        	}
        	else{
        		$video_link = $request->video_link;
        	}

			$video->video_link = $video_link;

			$video->save();
			return redirect()->back()->withSuccess('Video successfully added.');
        }
	}


	public function edit($id,$video)
	{
		$movie = Movie::findOrfail($id);
		$video = Video::findOrfail($video);
		return view('admin.movie.video.edit',compact('movie','video'));
	}


	public function update($id,$video_id,Request $request)
	{
		$movie = Movie::findOrfail($id);
		$validator = Validator::make($request->all(), [
            'quality' => 'required|max:255',
            'source' => 'required|max:255',
            'video_link' => 'required',            
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }
        else {  
        	$video = Video::findOrfail($video_id);
        	$video->movie_id = $movie->id;
        	$video->quality = $request->quality;
        	$video->source = $request->source;
        	$video->video_link = $request->video_link;

        	

			$video->save();
			return redirect()->back()->withSuccess('Video successfully updated.');
        }
	}

	public function destroy($id,$video)
	{
		$video = Video::findOrfail($video);
		$video->delete();
		return redirect()->back()->withSuccess('Video successfully deleted.');
	}
}
	