<?php 
namespace App\Http\Controllers;

use App\Models\Movie;
use App\Models\Series;
use App\Models\Season;
use App\User;
use App\Models\UserRole;
use App\Models\Vote;
use App\Models\SVote;
use Illuminate\Support\Facades\Input;
use Illuminate\Http\Request;
use Validator;
use Auth;
use Mail;
use Config;

class AjaxController extends Controller 
{
    public function ajaxSearch(Request $request)
    {
        $validator = Validator::make(Input::all(), [
            'query' => 'required|string|max:255',           
        ]);
        $response = [];
        if ($validator->fails()) {
            $response['status'] = "error";
            $response['message'] = "No results";   
            return json_encode($response);
        }

        $response = [];
        $keyword = Input::get('query');

        $movies = Movie::where('active',1)->where(function($query) use($request,$keyword){
			    
			    if(starts_with($keyword,'tt')) $query->where('imdb_code',$keyword);
			    else $query->where('title_long','like',$keyword.'%');
			    
			})->orderBy('id','DESC')->take(3)->get(['id','slug','title','title_long','cover_image','year']);

        foreach ($movies as $movie) {
            $response['data'][] = ["url"=> $movie->url ,"img"=> $movie->thumbnail,"title"=>$movie->title_long,"year"=>$movie->year];
        }        

        $series = Series::where('active',1)->where(function($query) use($request,$keyword){
			    
			    if(starts_with($keyword,'tt')) $query->where('imdb_code',$keyword);
			    else $query->where('title_long','like',$keyword.'%');
			    
			})->orderBy('id','DESC')->take(3)->get(['id','slug','title','title_long','cover_image','year']);

        foreach ($series as $s) {
            $response['data'][] = ["url"=> $s->url ,"img"=> $s->thumbnail,"title"=>$s->title_long,"year"=>$s->year];
        }


        if(count($movies) > 0 || count($series) > 0){
            $response['status'] = "ok";
            $response['message'] = "message";       
        }
        else{
            $response['status'] = "error";
            $response['message'] = "No results";    
        }
        return json_encode($response);
    }

    public function login()
    {
        $validator = Validator::make(Input::all(), [
            'username' => 'required|min:3|max:255',
            'password' => 'required|min:3|max:255',
            'g-recaptcha-response' => 'required|recaptcha',            
        ]);
        $response = array();
        if ($validator->fails()) {
            $response['status'] = "error";
            $errors = '';
            foreach ($validator->errors()->all() as $error){
                $errors.= '<li style="text-align:left">'.$error.'</li>';
            }
            $response['status'] = "error";
            $response['message'] = $errors;
            return json_encode($response);
        }
        else {      
            $username = Input::get('username');
            $password = Input::get('password');
            if (Auth::attempt(['name' => $username, 'password' => $password])) {
                 if(Auth::user()->active == 0){
                    $response['status'] = "error";
                    $response['message'] = "Account not active, please check your email to complete the registration process. If you haven't received activation email <a href='".url('resend/'.Auth::user()->name.'/activate')."'>click here</a>"; 
                    Auth::logout();
                    return json_encode($response);
                 }              
            } 
            elseif (Auth::attempt(['email'=> $username, 'password' => $password])) {
                 if(Auth::user()->active == 0){
                    $response['status'] = "error";
                    $response['message'] = "Account not active, please check your email to complete the registration process. If you haven't received activation email <a href='".url('resend/'.Auth::user()->name.'/activate')."'>click here</a>"; 
                    Auth::logout();
                    return json_encode($response);
                 }                  
            } 
            else {
                //Auth::logout();
                $response['status'] = "error";
                $response['message'] = "Incorrect Username or password";
                return json_encode($response);
            }            

        }
    }   


    public function recover()
    {
        // validate the info, create rules for the inputs
        $rules = array('email' => 'required|email|exists:users,email','g-recaptcha-response' => 'required|recaptcha',
            'g-recaptcha-response' => 'required|recaptcha',

        );
        
        // run the validation rules on the inputs from the form
        $validator = Validator::make(Input::all(), $rules);
        $response = array();
        // if the validator fails, redirect back to the form
        if ($validator->fails()) {
            $errors = '<ul>';
            foreach ($validator->errors()->all() as $error){
                $errors.= '<li style="text-align:left">'.$error.'</li>';
            }
            $errors.= '</ul>';
            $response['status'] = "error";
            $response['message'] = $errors;
        } 
        else {
            $user = User::where('email',Input::get('email'))->first();

            $new_password = str_random(8);
            $user->password = bcrypt($new_password);
            $user->save();
            $recover = ['password' => $new_password];
            Mail::send('emails.recover',$recover, function ($m) use ($user) {
                $m->from(Config::Get('settings.contact_from_email'), Config::Get('settings.site_title'));
                $m->to($user->email)->subject('Recover Account');
            });
            $response['status'] = "ok";
            $response['message'] = 'Success! Your account successfully recovered. Please check your email box and follow instructions.';            
        }
        return json_encode($response);

    }  

    public function register()
    {
        $response = array();
        if(Auth::check()){
            $response['status'] = "error";
            $response['message'] = "You're already logged in.";
        }
         // validate the info, create rules for the inputs
        $rules = array('username'=> 'required|min:3|alpha_num|unique:users,name','email' => 'required|email|unique:users,email',
         // make sure the email is an actual email
        'password' => 'required|min:6|confirmed', 'password_confirmation' => 'required',   
        'g-recaptcha-response' => 'required|recaptcha',            
        );

        // run the validation rules on the inputs from the form
        $validator = Validator::make(Input::all(), $rules);
        
        // if the validator fails, redirect back to the form
        if ($validator->fails()) {
            $errors =  '<ul>';
            foreach ($validator->errors()->all() as $error){
                $errors.= '<li style="text-align:left">'.$error.'</li>';
            }
            $errors.= '</ul>';
            $response['status'] = "error";
            $response['message'] = $errors;

        } 
        else {
            $user = new User();
            $user->name = Input::get('username');
            $user->email = Input::get('email');
            $user->password = bcrypt(Input::get('password'));
            $user->active = (config('settings.user_auto_approve') == 1) ? 1 : 0;
            $activation_code = sha1(rand());
            $user->activation_code = $activation_code;
            $user->save();

            $user_role = new UserRole;
            $user_role->role_id = 2;
            $user_role->user_id = $user->id;
            $user_role->save();

            Mail::send('emails.activate',['user'=>$user], function ($m) use ($user) {
                $m->from(Config::Get('settings.contact_from_email'), Config::Get('settings.site_title'));                
                $m->to($user->email)->subject('Activation mail');
            }); 
            $response['status'] = "ok";
            $response['message'] = 'Success! Your account successfully created. Please check your email box and follow instructions to confirm registration.';
        }
        return json_encode($response);
    }

    public function vote($id)
    {        
        if(Auth::check()){

            $movie = Movie::find($id);
            if(!empty($movie)){
                $check = Vote::where('movie_id',$id)->where('user_id',Auth::user()->id)->first();
                if(empty($check)){
                    $vote = new Vote();
                    $vote->movie_id = $movie->id;
                    $vote->user_id = Auth::user()->id;
                    $vote->save();
                    $response['status'] = "ok";
                    $response['message'] = 'You successfully voted for this movie.';
                }
                else {
                    $response['status'] = "error";
                    $response['message'] = 'You have already voted for this movie.';
                }
            }
            else{
                $response['status'] = "error";
                $response['message'] = 'Movie not found.';
            }
        }
        else {
            $response['status'] = "error";
            $response['message'] = 'You must login to perform this action.';
        }
        return json_encode($response);
    }    

    public function svote($id)
    {        
        if(Auth::check()){

            $season = Season::find($id);
            if(!empty($season)){
                $check = SVote::where('season_id',$id)->where('user_id',Auth::user()->id)->first();
                if(empty($check)){
                    $vote = new SVote();
                    $vote->season_id = $season->id;
                    $vote->user_id = Auth::user()->id;
                    $vote->save();
                    $response['status'] = "ok";
                    $response['message'] = 'You successfully voted for this season.';
                }
                else {
                    $response['status'] = "error";
                    $response['message'] = 'You have already voted for this season.';
                }
            }
            else{
                $response['status'] = "error";
                $response['message'] = 'Movie not found.';
            }
        }
        else {
            $response['status'] = "error";
            $response['message'] = 'You must login to perform this action.';
        }
        return json_encode($response);
    }
}