<?php 
namespace App\Http\Controllers;

use App\Models\Article;
use Illuminate\Http\Request;

class BlogController extends Controller 
{

	public function index(Request $request) 
	{
		$articles = Article::where('status', 'PUBLISHED')
                    ->where('date', '<=', date('Y-m-d'));

        if (!empty($request->tag)) {
        	$articles = $articles->whereHas('tags',function($query) use($request){
        		$query->where('name',$request->tag);
        	});
        }

        $articles = $articles->orderBy('date', 'DESC')->paginate(10);

		return view('front.blog.index',compact('articles'));
	}

	public function article($slug)
	{
		$article = Article::where('slug',$slug)->where('status','PUBLISHED')->firstOrfail();
		return view('front.blog.article',compact('article'));
	}
}