<?php 
namespace App\Http\Controllers;

use App\Models\Series;
use App\Models\Season;
use App\Models\Episode;
use App\Models\ETorrent;
use App\Models\SDownload;
use Illuminate\Support\Facades\Input;
use Auth;
use Validator;

class EpisodeController extends Controller 
{
	public function show($slug)
	{
		$episode = Episode::with('series.seasons.episodes')->with('series.director_meta')->with('season')->where('slug',$slug)->firstOrfail();
		if(empty($episode->series) || empty($episode->season)) abort(404);
		$series = $episode->series;
		$season = $episode->season;
		$episode->torrents = ETorrent::where('series_id',$episode->series_id)->where('season_number',$episode->season_number)->where('episode_number',$episode->episode_number)->orderBy('size_bytes','DESC')->get();

		foreach ($series->seasons as $s) {
			$s->torrents = \App\Models\STorrent::where('series_id',$series->id)->where('season_number',$s->season_number)->orderBy('size_bytes','desc')->get();
			
			if($season->season_number == $s->season_number) $season->torrents = $s->torrents;
		}
	
		return view('front.series.episode',compact('series','season','episode'))->with('page_title',$episode->meta_title);
	}

	public function download($hash)
	{
		$torrent = ETorrent::where('hash',$hash)->firstOrfail();
		$series = Series::where('active',1)->where('id',$torrent->series_id)->first();

		$series->download_count = $series->download_count + 1;
		$series->save();
		$file_url = (env('IS_DUMMY') == true) ? env('SOURCE_DOMAIN').$torrent->file : url($torrent->file);

        $filename = $series->title_long.'-season-'.$torrent->season_number.'-episode-'.$torrent->episode_number.'.torrent';
		header('Content-Type: application/octet-stream');
		header("Content-Transfer-Encoding: Binary"); 
		header("Content-disposition: attachment; filename=\"" . $filename . "\""); 
		return readfile($file_url);		
	}
}