<?php 
namespace App\Http\Controllers;

use App\Models\Movie;
use App\Models\Series;
use Illuminate\Http\Request;

class HomeController extends Controller 
{
    public function index()
    {
        $popular_movies = \Cache::remember('popular_movies_home',900,function(){
            return Movie::where('active',1)->orderBy('download_count','desc')->limit(4)->get();
        });
        $title = 'HOME';
        return view('front.home.lending',compact('popular_movies'))->with('page_title',$title);
    }

	public function home(Request $request) 
	{
		$movies =  \Cache::remember('latest_movies_home',900,function(){
            return Movie::where('active',1)->orderBy('id','DESC')->limit(8)->get();
		});
		$series = \Cache::remember('latest_series_home',900,function(){
            return Series::where('active',1)->orderBy('id','DESC')->limit(8)->get();
		});
		$popular_movies = \Cache::remember('popular_movies_home',900,function(){
            return Movie::where('active',1)->orderBy('download_count','desc')->limit(4)->get();
        });
		$popular_series = \Cache::remember('popular_series_home',900,function(){
            return Series::where('active',1)->orderBy('download_count','desc')->limit(4)->get();
		});
	
		$featured_genres = explode(',',config('settings.featured_genres'));
		
		$genre_movies = [];
		$genre_series = [];

		if(!empty($featured_genres))
		{
    		foreach($featured_genres as $genre)
    	

    		{
        		$genre_movies[$genre] = \Cache::remember('genre_movies_'.md5($genre),60 * 60 * 24, function() use($genre){
        		
            		return Movie::Where('genres','like','%'.$genre.'%')->where('active',1)->orderBy('created_at','DESC')->limit(24)->get();
        		
        		});


        		$genre_series[$genre] = \Cache::remember('genre_series_'.md5($genre),60 * 60 * 24, function() use($genre){
        		
            		return Series::Where('genres','like','%'.$genre.'%')->where('active',1)->orderBy('created_at','DESC')->limit(24)->get();
        		
        		});        		
    		}
		}		

		
		$title = 'HOME';
		return view('front.home.index',compact('movies','series','popular_movies','popular_series','genre_movies','genre_series'))->with('page_title',$title);
	}
}