<?php 
namespace App\Http\Controllers;

use App\Models\Movie;
use App\Models\Torrent;
use App\Models\Vote;
use App\Models\Download;
use App\Models\Video;
use App\Models\Subtitle;

use Illuminate\Support\Facades\Input;
use Illuminate\Http\Request;
use Auth;
use Validator;

class MovieController extends Controller 
{
	public function index(Request $request)
	{
		$validator = Validator::make($request->all(), [
            'keyword' => 'sometimes|string|max:100',
            'quality' => 'sometimes|in:720p,1080p,2160p,3D',
            'genre' => 'sometimes|exists:genre,name',
            'rating' => 'sometimes|numeric|between:0,10',
            'year' => 'sometimes|regex:/[0-9-]/',
            'language' => 'sometimes|alpha|min:2|max:2',
            'order_by' => 'sometimes|in:latest,oldest,year,rating,downloads,alphabetical',
        ]);
        if ($validator->fails()) {
            return redirect(route('movie.index'))->withErrors($validator)->withInput();
        }

		$keyword = $request->keyword;
		$quality = $request->quality;
		$genre = $request->genre;
		$rating = $request->rating;
		$order_by = $request->order_by;
		$movies = new Movie;
		$movies = $movies->where('active',1);
	/*	if(!empty($quality)){
			$movies = $movies->with('torrents')->whereHas('torrents',function($q) use($quality){
							$q->where('quality',$quality);	
					});
		}
		if(!empty($genre)){
			$movies = $movies->where('genres','like','%'.$genre.'%');
		}
		if(!empty($rating)){
			$movies = $movies->where('rating','>=',$rating);
		} */
		if(!empty($keyword)){
			//$movies = $movies->where('title_long','like','%'.$keyword.'%')->orWhere('imdb_code',$keyword)->orWhere('cast','like','%'.$keyword.'%')->orWhere('director','like','%'.$keyword.'%');
			
			
			$movies = $movies->where(function($query) use($request,$keyword){
			    
			    if(starts_with($keyword,'tt')) $query->where('imdb_code',$keyword);
			    else $query->where('title_long','like',$keyword.'%');
			    
			});
		}
	/*	if(!empty($request->language)){
			$movies = $movies->where('language',$request->language);
		}		
		if (!empty($request->year)) {
			if (strpos($request->year,'-') !== false) {
				$years = explode('-', $request->year);
				$start_year = $years[0];
				$end_year = $years[1];
				$movies = $movies->where('year','>=',$start_year)->where('year','<=',$end_year);
			}
			else{
				$movies = $movies->where('year',$request->year);
			}
		} 

		if($order_by == 'latest'){
			$movies = $movies->orderBy('created_at','desc');
		}
		elseif($order_by == 'oldest'){
			$movies = $movies->orderBy('created_at');
		}
		elseif ($order_by == 'year') {
			$movies = $movies->orderBy('year','desc');
		}
		elseif ($order_by == 'rating') {
			$movies = $movies->orderBy('rating','desc');
		}
		elseif ($order_by == 'alphabetical') {
			$movies = $movies->orderBy('title');
		}
		elseif($order_by == 'downloads'){
			$movies = $movies->orderBy('download_count','desc');
		}
		else{
			$movies = $movies->orderBy('id','desc');
		}
        */
        $movies = $movies->orderBy('id','desc');
		
		$movies = $movies->paginate(20);
		$movies_count = $movies->total();
		
		$search_terms = explode(' ',$keyword);
		$props = ['title_long', 'slug', 'imdb_code'];
		
	    $title = 'Search BabyTorrent '.$keyword.' and Browse '.$keyword.' YIFY Movies Torrent Downloads - YTS';
		return view('front.movie.index',compact('movies','movies_count'))->with('page_title',$title);
	}
	
	public function latest()
	{
		$torrents = \Cache::remember('latest_torrents',2000,function(){
		        return Torrent::with('movie')->whereHas('movie',function($query){
	    	    $query->where('active',1);
    		})->orderBy('id','DESC')->groupBy('movie_id')->get(30);
		});
		

	    $title = 'BabyTorrent : Latest YIFY Movies Torrent Downloads - YTS';
		return view('front.movie.latest',compact('torrents'))->with('page_title',$title);		
	}	
	
	public function trending()
	{
		$movies = \Cache::remember('trending_movies',2000,function(){
		        return Movie::where('genres','like','%Trending%')->where('active',1)->orderBy('id','DESC')->paginate(20);
		});
	    $title = 'BabyTorrent :Trending YIFY Movies Torrent Downloads - YTS';
		return view('front.movie.trending',compact('movies'))->with('page_title',$title);		
	}

	public function upcoming()
	{
		$movies = \Cache::remember('upcoming_movies',2000,function(){
		        return  Movie::where('genres','like','%Upcoming%')->where('active',1)->orderBy('id','DESC')->paginate(20);
		});
	    $title = 'BabyTorrent : Upcoming YIFY Movies Torrent Downloads - YTS';
		return view('front.movie.upcoming',compact('movies'))->with('page_title',$title);		
	}

	public function show($slug)
	{
		$movie = \Cache::remember('movie_'.$slug,2000,function() use($slug){
		        return Movie::with('torrents')->with('director_meta')->where('active',1)->where('slug',$slug)->firstOrfail();
		});
		$minutes = config('settings.movie_update_interval_minutes');
		if ((strtotime('-'.$minutes.' minutes') > strtotime($movie->updated_at)) && !empty($movie->imdb_code)) 
		{
				$movie->updated_at = date('Y-m-d H:i:s');
				$movie->ytsUpdate();
				$movie->omdbUpdate();
                $movie->save();		
                
                /*
                foreach($movie->torrents as $torrent)
                {
                    Torrent::where('hash',$torrent->hash)->where('id','!=',$torrent->id)->delete();
                }*/
			
		}

		
/*
		$hours = config('settings.subtitle_update_interval_minutes') / 60;
		if (strtotime('-'.$hours.' hours') > strtotime($movie->subtitle_updated_at) && !empty($movie->imdb_code)) 
		{
			$scrapper = \App\Models\Scrapper::where('name','yify_update_subtitles')->firstOrfail();

	        $imdb_codes = explode(',', $scrapper->yts_ids);

	        if(!in_array($movie->imdb_code, $imdb_codes))
	        {
		        array_push($imdb_codes, $movie->imdb_code);
		        $scrapper->yts_ids = implode(',', $imdb_codes);
		        $scrapper->save();
		    }
		}*/

		$genres = explode(',', $movie->genres);
		$genres = array_filter($genres);
		

		$similar_movies = \Cache::rememberForever('similar_movies_'.md5(implode(',',$genres)), function () use($movie,$genres){
		
		    return Movie::where('active',1)->where('id','!=',$movie->id)->Where(function ($query) use($genres) {
                 for ($i = 1; $i < count($genres); $i++){
                    $query->orwhere('genres', 'like',  '%' . $genres[$i] .'%');
                 }      
            })->inRandomOrder()->limit(4)->get();
		});

		return view('front.movie.show',compact('movie','similar_movies'))->with('page_title',$movie->meta_title);
	}

	public function download($hash, Request $request)
	{	
	   /* $check_torrents = Torrent::where('hash',$hash)->get();
	    if($check_torrents->count() > 1)
	    {
	        foreach($check_torrents as $check_torrent){
    	        $check_movie = Movie::where('id',$check_torrent->movie_id)->first(['id']);
    	        if(empty($check_movie)) Torrent::where('id',$check_torrent->id)->delete();
	        }
	    }*/
	    
		$torrent = \Cache::rememberForever('torrent_'.$hash,function() use($hash){
		        return Torrent::where('hash',$hash)->firstOrfail();
		});
		
		$movie = Movie::where('id',$torrent->movie_id)->where('active',1)->firstOrfail();
		$movie->download_count = $movie->download_count + 1;
		$movie->save();
		$file_url = (env('IS_DUMMY') == true) ? env('SOURCE_DOMAIN').$torrent->file : url($torrent->file);

/*
		if(Auth::check()){
			$check = Download::where('user_id',Auth::user()->id)->where('movie_id',$movie->id)->first();
			if(empty($check)){
				$download = new Download();
				$download->movie_id = $movie->id;
				$download->user_id = Auth::user()->id;
				$download->save();
			}
		}
		*/
		
		header('Content-Type: application/octet-stream');
		header("Content-Transfer-Encoding: Binary"); 
		header("Content-disposition: attachment; filename=\"" . basename($file_url) . "\""); 
		return readfile($file_url);		
	}

	public function subtitles($id,Request $request)
	{
		if($request->ajax())
		{
			return datatables()->of(Subtitle::query()->where('movie_id',$id)->where('active',1)->select(['id','language','name','file','uploader']))
			->editColumn('name', function($item){
				return '<a href="'.$item->file.'" title="'.$item->name.'"> '.str_limit($item->name,80).' </a>';
			})
			->toJson();
		}

	}
}