<?php 
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Page;
use Validator;

use App\Models\Movie;
use App\Models\Series;
use App\Models\Article;

class PageController extends Controller 
{
    public function verifyShow()
    {
         return view('front.page.verify')->with('page_title',__('Verify Human'));
    }

    public function verify(Request $request)
    {
      /*  $validator = Validator::make($request->all(), [
            'g-recaptcha-response' => 'required|recaptcha',
        ]);
        if ($validator->fails()) {
            return redirect(route('verify'))
                        ->withErrors($validator);
        }  */
        
        $cookie_name = 'SESSIONID';
        $minutes = 60 * 24 * 30;
        $response = new \Response('Set Cookie');

        $redirectTo = '/';
        if(!empty($request->url) && starts_with($request->url,url('/'))) {
            $redirectTo = str_replace(url('/'), '', $request->url);
        }

        return redirect($redirectTo)->withCookie(cookie($cookie_name, encrypt('YTSZONE'), $minutes)); 
    }

	public function index($slug) 
	{
		$page = Page::where('slug',$slug)->firstOrfail();
		return view('front.page.index',compact('page'));
	}

    public function contact()
    {          
        return view('front.page.contact')->with('page_title','Contact Us');
    }

    public function contactPost(Request $request)
    {
       $validator = Validator::make($request->all(), [
            'name' => 'required|min:2|max:100',
            'email' => 'required|email',
            'subject' => 'required|subject',
            'message' => 'required|min:10|max:200',
            'g-recaptcha-response' => 'required|recaptcha',
        ]);
       $success = '';
       if ($validator->fails()) {
            return redirect('contact')
                        ->withErrors($validator)
                        ->withInput();
        }
        else {      


            try {
                Mail::send('emails.contact', ['request' => $request], function ($m) {
                    $m->to(config('settings.contact_form_email'))->subject(config('settings.site_title') . ' Contact - '.$request->subject);
                });
            } catch (\Exception $e) {
                \Log::info($e->getMessage());
                return redirect('contact')->withErrors(__('Your message was not sent due to invalid mail configuration'));
            }


            return redirect('contact')->with('success','Your message received. Thank you!');            
        }
        
    }	

/*
    public function sitemap()
    {
        $movies = Movie::where('active',1)->orderBy('created_at','DESC')->get();
        $series = Series::where('active',1)->orderBy('created_at','DESC')->get();
        
        $articles = Article::where('status', 'PUBLISHED')
                    ->where('date', '<=', date('Y-m-d'))
                    ->orderBy('date', 'DESC')->get();

        $pages = Page::all();

        return response()->view('front.page.sitemap',compact('movies','series','articles','pages'))->header('Content-Type', 'text/xml');                    
    }*/
}