<?php 
namespace App\Http\Controllers;

use App\Models\Series;
use App\Models\Season;
use App\Models\STorrent;
use App\Models\SVote;
use App\Models\SDownload;
use Illuminate\Support\Facades\Input;
use Auth;
use Validator;

class SeasonController extends Controller 
{
	public function show($slug)
	{
		$season = Season::with('series.seasons.episodes')->with('series.director_meta')->where('active',1)->where('slug',$slug)->firstOrfail();		
		$series = $season->series;
		$season->torrents = \App\Models\STorrent::where('series_id',$series->id)->where('season_number',$season->season_number)->orderBy('size_bytes','desc')->get();

		if($season->torrents->count() == 0) abort(404);

		foreach ($series->seasons as $s) {
			$s->torrents = \App\Models\STorrent::where('series_id',$series->id)->where('season_number',$s->season_number)->orderBy('size_bytes','desc')->get();
		}

		return view('front.series.season',compact('series','season'))->with('page_title',$season->meta_title);
	}

	public function download($hash)
	{
		
        $torrent = \Cache::rememberForever('storrent_'.$hash,function() use($hash){
		        return STorrent::where('hash',$hash)->firstOrfail();
		});		
		
		$series = Series::where('active',1)->where('id',$torrent->series_id)->first();

		$series->download_count = $series->download_count + 1;
		$series->save();
		$file_url = (env('IS_DUMMY') == true) ? env('SOURCE_DOMAIN').$torrent->file : url($torrent->file);
        
        $filename = $series->title_long.'-season-'.$torrent->season_number.'.torrent';
		header('Content-Type: application/octet-stream');
		header("Content-Transfer-Encoding: Binary"); 
		header("Content-disposition: attachment; filename=\"" . $filename . "\""); 
		echo readfile($file_url);		
	}
}