<?php 
namespace App\Http\Controllers;

use App\Models\Series;
use Illuminate\Support\Facades\Input;
use Auth;
use Validator;

class SeriesController extends Controller 
{
	public function index()
	{
		$validator = Validator::make(Input::all(), [
            'keyword' => 'sometimes|max:255',
            'quality' => 'sometimes|in:720p,1080p,3D',
            'genre' => 'sometimes|exists:genre,name',
            'rating' => 'sometimes|numeric|between:0,10',
            'order_by' => 'sometimes|in:latest,oldest,year,rating,downloads,alphabetical',
        ]);
        if ($validator->fails()) {
            return redirect('series');
        }

		$keyword = Input::get('keyword');
		$quality = Input::get('quality');
		$genre = Input::get('genre');
		$rating = Input::get('rating');
		$order_by = Input::get('order_by');
		$series = new Series;
		$series = $series->where('active',1)->with('seasons.episodes');
	/*	if(!empty($quality)){
			$series = $series->with('torrents')->whereHas('torrents',function($q) use($quality){
							$q->where('quality',$quality);	
					});
		}*/
		/*
		if(!empty($genre)){
			$series = $series->where('genres','like','%'.$genre.'%');
		}
		if(!empty($rating)){
			$series = $series->where('rating','>=',$rating);
		}*/
		if(!empty($keyword)){
			$series = $series->where(function($query) use($keyword){
			        if(starts_with($keyword,'tt')) $query->where('imdb_code',$keyword);
			        else $query->where('title_long','like',$keyword.'%');
			});;
		}

/*
		if($order_by == 'latest'){
			$series = $series->orderBy('created_at','desc');
		}
		elseif($order_by == 'oldest'){

			$series = $series->orderBy('created_at');
		}
		elseif ($order_by == 'year') {
			$series = $series->orderBy('year','desc');
		}
		elseif ($order_by == 'rating') {
			$series = $series->orderBy('rating','desc');
		}
		elseif ($order_by == 'alphabetical') {
			$series = $series->orderBy('title');
		}
		elseif($order_by == 'downloads'){
			$series = $series->orderBy('download_count','desc');
		}
		else{
			$series = $series->orderBy('id','desc');
		}
		*/
		
		$series = $series->orderBy('id','desc');

		$series = $series->paginate(20);
		$series_count = $series->total();

		$title = 'Search '.$keyword.' and Browse '.$keyword.' YIFY Series Torrent Downloads - YTS - BABYTORRENT';
		return view('front.series.index',compact('series','series_count'))->with('page_title',$title);
	}

	public function show($slug)
	{
		$series = \Cache::remember('series_'.$slug,2000,function() use($slug){
		    return Series::with('seasons.episodes')->with('director_meta')->where('active',1)->where('slug',$slug)->firstOrfail();
		});
		if(strpos($series->genres,'&') !== false){
		    $series->genres = str_replace('&',',',$series->genres);
		    $series->save();
		}

		foreach ($series->seasons as $s) {
			$s->torrents = \Cache::remember('series_torrents_'.$series->id.'_'.$s->season_number,2000,function() use($series,$s){
		        return \App\Models\STorrent::where('series_id',$series->id)->where('season_number',$s->season_number)->get();
			});
		}

		$hours = config('settings.series_update_interval_minutes') / 60;
		if (strtotime('-'.$hours.' hours') > strtotime($series->updated_at) && !empty($series->tmdb_id)) 
		{
			$scrapper = \App\Models\Scrapper::where('name','tmdb_tv_update')->firstOrfail();

	        $imdb_codes = explode(',', $scrapper->yts_ids);

	        if(!in_array($series->tmdb_id, $imdb_codes))
	        {
		        array_push($imdb_codes, $series->tmdb_id);
		        $scrapper->yts_ids = implode(',', $imdb_codes);
		        $scrapper->save();
		    }
		}

		$genres = explode(',', $series->genres);
		$genres = array_filter($genres);
		
		if(!empty($genres)){
    		$similar_series = \Cache::remember('similar_series_'.str_slug($genres[0]),9000,function() use($genres,$series){
    		    return Series::where('active',1)->where('id','!=',$series->id)->where('genres', 'like',  '%' . $genres[0] .'%')->take(4)->get();
    		});
		}
		else{
            $similar_series = \Cache::remember('similar_series_Trending',9000,function(){
    		    return Series::where('active',1)->where('id','!=',$series->id)->where('genres', 'like', '%Trending%')->take(4)->get();
    		});		    
		}
		return view('front.series.show',compact('series','similar_series'))->with('page_title',$series->meta_title);
	}
}