<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class SitemapController extends Controller
{
    public function index()
    {
		$maps = \App\Models\Movie::selectRaw('year(created_at) y, month(created_at) m, count(*) data')
                ->groupBy('y', 'm')
                ->orderBy('y', 'desc')
                ->orderBy('m','desc')
                ->get();        

        $maps2 = \App\Models\Series::selectRaw('year(created_at) y, month(created_at) m, count(*) data')
                ->groupBy('y', 'm')
                ->orderBy('y', 'desc')
                ->orderBy('m','desc')
                ->get();


        foreach ($maps as $m) {
            $latest_of_month = \App\Models\Movie::whereYear('created_at',$m->y)->whereMonth('created_at',$m->m)->orderBy('created_at','desc')->first(['created_at']);
            $m->created_at = $latest_of_month->created_at;
        }        

        foreach ($maps2 as $ms) {
            $latest_of_month = \App\Models\Series::whereYear('created_at',$ms->y)->whereMonth('created_at',$ms->m)->orderBy('created_at','desc')->first(['created_at']);
            $ms->created_at = $latest_of_month->created_at;
        }

    	return response()->view('front.sitemap.index',compact('maps','maps2'))->header('Content-Type', 'text/xml');  
    }

    public function misc()
    {
    	return response()->view('front.sitemap.misc')->header('Content-Type', 'text/xml');    	
    }   

    public function movies($year,$month)
    {
    	if($year != date('Y-m-d')){
    	    $movies = \Cache::remember('sitemap_movies_'.$year.'_'.$month,5000,function() use($year,$month){
    	        return $movies = \App\Models\Movie::whereYear('created_at',$year)->whereMonth('created_at',$month)->orderBy('id','desc')->get();
    	    });
    	}
    	else $movies = \App\Models\Movie::whereYear('created_at',$year)->whereMonth('created_at',$month)->orderBy('id','desc')->get();

    	return response()->view('front.sitemap.movies',compact('movies'))->header('Content-Type', 'text/xml');    	
    }    

    public function series($year,$month)
    {
        if($year != date('Y-m-d')){
    	    $series = \Cache::remember('sitemap_series_'.$year.'_'.$month,5000,function() use($year,$month){
    	        return $series = \App\Models\Series::with('seasons')->with('season_torrents')->whereYear('created_at',$year)->whereMonth('created_at',$month)->orderBy('id','desc')->get();
    	    });
    	}
    	else $series = \App\Models\Series::with('seasons')->with('season_torrents')->whereYear('created_at',$year)->whereMonth('created_at',$month)->orderBy('id','desc')->get();

        return response()->view('front.sitemap.series',compact('series'))->header('Content-Type', 'text/xml');      
    }
}
