<?php

namespace App\Http\Middleware;

use Closure;

class EcoAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if(strpos($request->url(), '/index.php')){
            return redirect(env('APP_URL'));
        }

        $uri = $request->getRequestUri();
        $redirect = \App\Models\Redirect::where('old_page',$uri)->orWhere('old_page','/'.$uri)->first(['old_page','new_page']);
        if (!empty($redirect)) {
            return redirect($redirect->new_page,301);
        }

        if(\Auth::check()){
            if(\Auth::user()->hasRole('Administrator')){
                return $next($request);
            }
        }
        
        if(config('settings.maintenance_mode') == 1 && !$request->isMethod('post')){
            echo view('front.page.maintenance')->with('page_title', __('Site Under Maintenance'));
            exit;
        }

        if (!\Auth::check()) {
            if ($request->ajax()) {
                return response()->json(['message' => __('You must login to perform this action')], 401);
            } else {
                return redirect()->guest(route('login'));
            }
        } else {
            if (\Auth::user()->active != 1) {
                return redirect('/')->withErrors(__('Please check your email box and follow instructions to verify email address to access this page'));
            }
        }        

        return $next($request);
    }
}
