<?php

namespace App\Http\Middleware;

use Closure;

class EcoWeb
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if(strpos($request->url(), '/index.php')){
            return redirect(env('APP_URL'));
        }   

        if(!$this->bot_detected() && config('settings.site_captcha_verify') == 1)
        {
            $cookie_name = 'SESSIONID';
            
            if(!$request->cookie($cookie_name) && \Route::currentRouteName() != 'verify')
            {
                return redirect(route('verify',['url' => url($request->getRequestUri())]));      
            }

            if ($request->cookie($cookie_name) && decrypt($request->cookie($cookie_name)) != 'YTSZONE' && \Route::currentRouteName() != 'verify') {
                return redirect(route('verify'));
            }
        }
        
        $uri = $request->getRequestUri();
        
        $redirect = \App\Models\Redirect::where('old_page',$uri)->orWhere('old_page',ltrim($uri,'/'))->first();
        if (!empty($redirect)) {
            
            $slug = explode('/',$uri);
            $movie_slug = end($slug);
            
            $movie = \App\Models\Movie::where('slug',$movie_slug)->first();            
            
            if(!empty($movie)){ 
                \App\Models\Redirect::where('old_page','like','%'.$movie->slug.'%')->delete();
            }
            else{ 
                return redirect($redirect->new_page,301);
            }
            
        }
        

        if(\Auth::check()){
            if(\Auth::user()->hasRole('Administrator')){
                return $next($request);
            }
        }
        
        if(config('settings.maintenance_mode') == 1 && !$request->isMethod('post')){
            echo view('front.page.maintenance')->with('page_title', __('Site Under Maintenance'));
            exit;
        }

        return $next($request);
    }

    public static function bot_detected()
    {
        return (
            isset($_SERVER['HTTP_USER_AGENT'])
            && preg_match('/ahrefs|applebot|archive.org|baidu|bing|feedbin|googlebot|grapeshot|linkedin|mail.ru|naver|pingdom|yahoo|pinterest|seznam|yandex|sogou|uptimerobot/i', $_SERVER['HTTP_USER_AGENT'])
        );
    }    
}
