<?php 
namespace App\Http\Requests;

use App\Http\Requests\Request;

class EpisodeCrudRequest extends \Backpack\CRUD\app\Http\Requests\CrudRequest {

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        // only allow updates if the user is logged in
        return \Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {   
        $id = request()->get('id');

        if(!empty($id))
        {
            return [
                'name' => 'required|min:5|max:200',
                'slug' => 'required|min:5|max:250|unique:episode,slug,'.$id,
                'season_number' => 'required|numeric',
                'episode_number' => 'required|numeric',
                'air_date' => 'required|date',
                'cover_image' => 'nullable',
                'overview' => 'nullable|max:5000'
            ];  
        }
        else{
            return [
                'name' => 'required|min:5|max:200',
                'slug' => 'required|min:5|max:250|unique:episode,slug',
                'season_number' => 'required|numeric',
                'episode_number' => 'required|numeric',
                'air_date' => 'required|date',
                'cover_image' => 'nullable',
                'overview' => 'nullable|max:5000'
            ]; 
        }


    }

}