<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\CrudTrait;

class Artist extends Model {

	use CrudTrait;
    /*
	|--------------------------------------------------------------------------
	| GLOBAL VARIABLES
	|--------------------------------------------------------------------------
	*/

	protected $table = 'artists';
	protected $primaryKey = 'id';
	// protected $guarded = [];
	// protected $hidden = ['id'];
	public $timestamps = true;

	/*
	|--------------------------------------------------------------------------
	| FUNCTIONS
	|--------------------------------------------------------------------------
	*/
    public function openGoogle($crud = false)
    {
        return '<a class="btn btn-xs btn-default" target="_blank" href="http://google.com/search?q='.urlencode($this->name).'" data-toggle="tooltip" title="Search '.$this->name.' on Google"><i class="fa fa-search"></i> Google it</a>';
    }		
	/*
	|--------------------------------------------------------------------------
	| RELATIONS
	|--------------------------------------------------------------------------
	*/


	/*
	|--------------------------------------------------------------------------
	| SCOPES
	|--------------------------------------------------------------------------
	*/

	/*
	|--------------------------------------------------------------------------
	| ACCESORS
	|--------------------------------------------------------------------------
	*/


	public function getPhotoFAttribute()
	{
        if(empty($this->photo)) return $this->attributes['photo_f'] = url('img/default_avatar.jpg');
        
        if(starts_with($this->photo,'http')) return $this->attributes['photo_f'] = $this->photo;
        
        if(env('IS_DUMMY') == true) return $this->attributes['photo_f'] = env('SOURCE_DOMAIN').$this->photo;
        else $this->attributes['photo_f'] = url($this->photo);
        
	}

	/*
	|--------------------------------------------------------------------------
	| MUTATORS
	|--------------------------------------------------------------------------
	*/
}