<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ETorrent extends Model {


    /*
	|--------------------------------------------------------------------------
	| GLOBAL VARIABLES
	|--------------------------------------------------------------------------
	*/

	protected $table = 'etorrent';
	protected $primaryKey = 'id';
	protected $guarded = ['id'];
	// protected $hidden = ['id'];
	public $timestamps = true;

	/*
	|--------------------------------------------------------------------------
	| FUNCTIONS
	|--------------------------------------------------------------------------
	*/

	/*
	|--------------------------------------------------------------------------
	| RELATIONS
	|--------------------------------------------------------------------------
	*/


	/*
	|--------------------------------------------------------------------------
	| SCOPES
	|--------------------------------------------------------------------------
	*/

	/*
	|--------------------------------------------------------------------------
	| ACCESORS
	|--------------------------------------------------------------------------
	*/
	public function getBannerAttribute()
	{
		$banner = null;
		if (stripos($this->quality, '720') !== false) {
			$banner = url('img/banner720p.png');
		}
		elseif (stripos($this->quality, '1080') !== false) {
			$banner = url('img/banner1080p.png');
		}		
		elseif (stripos($this->quality, '3D') !== false) {
			$banner = url('img/banner3D.png');
		}		
		elseif (stripos($this->quality, '2160') !== false) {
			$banner = url('img/banner2160p.png');
		}
		return $this->attributes['banner'] = $banner;
	}

	public function getSizeFAttribute()
	{
	    $bytes = $this->size_bytes;
	    $precision = 0;
	    
        if ($bytes > pow(1024,3)) $size_f = round($bytes / pow(1024,3), $precision)."GB";
        else if ($bytes > pow(1024,2)) $size_f = round($bytes / pow(1024,2), $precision)."MB";
        else if ($bytes > 1024) $size_f = round($bytes / 1024, $precision)."KB";
        else $size_f = ($bytes)."B";
    
		return $this->attributes['size_f'] = $size_f;
	}	

	public function getNameFAttribute()
	{
		return $this->attributes['name_f'] = str_replace('EZTV','',$this->name);
	}		
	
	public function getDownloadUrlAttribute()
	{
	    if(starts_with($this->file,'magnet')) return $this->file;
		return $this->attributes['download_url'] = $this->magnet_url;
		//return $this->attributes['download_url'] = route('episode.torrent.download',[$this->hash]);
	}	

	public function getMagnetURLAttribute()
	{
		return $this->attributes['magnet_url'] = 'magnet:?xt=urn:btih:'.$this->hash.'&dn='.urlencode($this->name.'-S'.$this->season_number.'E'.$this->episode_number).'&tr=udp://tracker.coppersurfer.tk:80&tr=udp://glotorrents.pw:6969/announce&tr=udp://tracker.leechers-paradise.org:6969&tr=udp://tracker.opentrackr.org:1337/announce&tr=udp://exodus.desync.com:6969'; 
	}	

	/*
	|--------------------------------------------------------------------------
	| MUTATORS
	|--------------------------------------------------------------------------
	*/
}