<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\CrudTrait;
use Cviebrock\EloquentSluggable\Sluggable;
use Cviebrock\EloquentSluggable\SluggableScopeHelpers;
use Illuminate\Support\Str;

class Episode extends Model {

	use CrudTrait;
	use Sluggable, SluggableScopeHelpers;
    /*
	|--------------------------------------------------------------------------
	| GLOBAL VARIABLES
	|--------------------------------------------------------------------------
	*/

	protected $table = 'episode';
	protected $primaryKey = 'id';
	protected $guarded = ['id'];
	// protected $guarded = [];
	// protected $hidden = ['id'];
	//protected $fillable = ['name'];
	public $timestamps = true;


    public static function boot()
    {
        parent::boot();
        static::deleting(function($item) {

          \App\Models\ETorrent::where('series_id',$item->series_id)->where('episode_number',$item->episode_number)->delete();           
          \App\Models\OldLinkEpisode::where('episode_id',$item->id)->delete();            

        });
       
    } 


	/**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'slug_or_title',
            ],
        ];
    }

	/*
	|--------------------------------------------------------------------------
	| FUNCTIONS
	|--------------------------------------------------------------------------
	*/

    public function openGoogle($crud = false)
    {
        return '<a class="btn btn-xs btn-default" target="_blank" href="http://google.com/search?q='.urlencode($this->title_long).'" data-toggle="tooltip" title="Search '.$this->title_long.' on Google"><i class="fa fa-search"></i> Google it</a>';
    }	

	/*
	|--------------------------------------------------------------------------
	| RELATIONS
	|--------------------------------------------------------------------------
	*/	

  /*  public function torrents()
    {
    	return $this->hasMany('App\Models\ETorrent','series_id','series_id')->orderBy('size_bytes','desc');
    } */    

    public function season()
    {
        return $this->hasOne('App\Models\Season','id','season_id');
    }  
    
    public function series()
    {
        return $this->hasOne('App\Models\Series','id','series_id');
    }  



	/*
	|--------------------------------------------------------------------------
	| SCOPES
	|--------------------------------------------------------------------------
	*/

	/*
	|--------------------------------------------------------------------------
	| ACCESORS
	|--------------------------------------------------------------------------
	*/

	 // The slug is created automatically from the "title" field if no slug exists.
    public function getSlugOrTitleAttribute()
    {
        if ($this->slug != '') {
            return $this->slug;
        }

        return $this->series->title_long. ' season ' . $this->season_number .' episode' . $this->episode_number;
    }

    public function getTitleLongAttribute()
    {
        return $this->attributes['title_long'] = $this->series->title_long. ' Season ' . $this->season_number .' Episode ' . $this->episode_number;
    }

    public function getThumbnailAttribute()
    {
        return $this->attributes['thumbnail'] = (!empty($this->cover_image)) ? url($this->cover_image) : 'https://dummyimage.com/230x345/808080/ffffff/?text='.$this->name;
    } 

    public function getYearAttribute()
    {
        return $this->attributes['year'] = substr($this->air_date, 0,4);
    }

    public function getMetaTitleAttribute()
    {
        return $this->attributes['meta_title'] = '' . $this->title_long.' -  YIFY Torrent Magnet | YIFY Subtitles - YTS';
    }    

    public function getMetaDescriptionAttribute()
    {
        return $this->attributes['meta_description'] = $this->title.' yify torrent magnet, - '. $this->title_long .' yify subtitles By YTS -  Story : '. Str::words($this->description_full,20);
    }

    public function getMetaKeywordsAttribute()
    {
        return $this->attributes['meta_keywords'] = ''. $this->title_long .' yify, '. $this->title_long .' yify movies, '. $this->title_long .' yify torrent, '. $this->title_long .' torrent, '. $this->title_long .' yify subtitles, '. $this->title_long .' yify torrent magnet, yify subtitles '. $this->title_long .', '. $this->title_long .' yify movies official, '. $this->title_long .' yify torrent movies, '. $this->title_long .' full movie torrent, '. $this->title_long .' download movies' ;
    }   

     public function getCratedAtFAttribute()
    {
        return $this->attributes['created_at_f'] = $this->created_at->format('F d, Y \a\t h:i A');
    }     

    public function getUrlAttribute()
    {
        return $this->attributes['url'] = route('episode.show',[$this->slug]);
    }

    public function getVideoLinkAttribute()
    {
        return $this->attributes['video_link'] = config('settings.watch_series_api').$this->series->tmdb_id.'&s='.$this->season_number.'&e='.$this->episode_number;
    } 

	/*
	|--------------------------------------------------------------------------
	| MUTATORS
	|--------------------------------------------------------------------------
	*/
}