<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\CrudTrait;
use Cviebrock\EloquentSluggable\Sluggable;
use Cviebrock\EloquentSluggable\SluggableScopeHelpers;
use Illuminate\Support\Str;

use App\Models\Movie;
use App\Models\Torrent;
use App\Models\Subtitle;

use Symfony\Component\DomCrawler\Crawler;

class Movie extends Model {

    use CrudTrait;
    use Sluggable, SluggableScopeHelpers;
    /*
    |--------------------------------------------------------------------------
    | GLOBAL VARIABLES
    |--------------------------------------------------------------------------
    */

    protected $table = 'movie';
    protected $primaryKey = 'id';
    protected $guarded = ['id'];
    // protected $guarded = [];
    // protected $hidden = ['id'];
    //protected $fillable = ['name'];
    public $timestamps = true;

    /**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'slug_or_title_long',
            ],
        ];
    }


    public static function boot()
    {
        parent::boot();
        static::deleting(function($item) {

            $genres = explode(',',$item->genres);
            
            foreach($genres as $genre)
            {
                \Cache::forget('genre_movies_'.md5($genre));
            }

          \App\Models\Torrent::where('movie_id',$item->id)->delete();
          \App\Models\Video::where('movie_id',$item->id)->delete();
          \App\Models\Subtitle::where('movie_id',$item->id)->delete();
          \App\Models\Vote::where('movie_id',$item->id)->delete();
          \App\Models\Download::where('movie_id',$item->id)->delete();            
          \App\Models\OldLink::where('movie_id',$item->id)->delete();            

        });
        static::creating(function($item) {

            $genres = explode(',',$item->genres);
            
            foreach($genres as $genre)
            {
                \Cache::forget('genre_movies_'.md5($genre));
            }

        });        
    } 


    /*
    |--------------------------------------------------------------------------
    | FUNCTIONS
    |--------------------------------------------------------------------------
    */

    public function openGoogle($crud = false)
    {
        return '<a class="btn btn-xs btn-default" target="_blank" href="http://google.com/search?q='.urlencode($this->title_long).'" data-toggle="tooltip" title="Search '.$this->title_long.' on Google"><i class="fa fa-search"></i> Google it</a>';
    }   
    
    public function getTmdbImages($crud = false)
    {
        return '<a class="btn btn-xs btn-default" href="'.route('admin.movie.tmdb_images',[$this->id]).'"><i class="fa fa-image"></i> Tmdb Images</a>';
    }      
    
    public function getTgx($crud = false)
    {
        return '<a class="btn btn-xs btn-default" href="'.route('admin.movie.tgx_torrents',[$this->id]).'"><i class="fa fa-renren"></i> TGX & 1337x</a>';
    }  
    
    public function ytsUpdate()
    {
        if(empty($this->yts_id) && empty($this->imdb_code)) return;
        $id = $this->yts_id ?? $this->imdb_code;

        if(is_numeric($id))
        {   
            try{
                $data = file_get_contents(config('settings.yts_api').'movie_details.json?movie_id='.$id.'&with_images=true&with_cast=true');
            }            
            catch(\Exception $e){
                return;
            }
        }
        elseif(starts_with($id,'tt')){
            try{
                $data = file_get_contents(config('settings.yts_api').'list_movies.json?query_term='.$id);
            }
            catch(\Exception $e){
                return;
            }
            
            $data = json_decode($data);
            if($data->status == "ok"){
                if($data->data->movie_count == 1){
                    if(empty($data->data->movies)) return 'api error';
                    $id = $data->data->movies[0]->id;
                    $data = file_get_contents(config('settings.yts_api').'movie_details.json?movie_id='.$id.'&with_images=true&with_cast=true');
                }
                else{
                    return 'api error';
                }
            }
            else{
                return 'api error';
            }
        }   
        else{
            return 'api error';
        }

        $data = json_decode($data);

        if($data->status == "ok")
        {
            $imdb_code = $data->data->movie->imdb_code;
            $title = $data->data->movie->title_english;
            $title_long = $data->data->movie->title_long;

            $year = $data->data->movie->year;
            $rating = $data->data->movie->rating;
            $runtime = $data->data->movie->runtime;
            $genres = (!empty($data->data->movie->genres)) ? str_replace('&',',',implode(',',$data->data->movie->genres)) : '';
            $description_full = $data->data->movie->description_full;
            $yt_trailer_code = (!empty($data->data->movie->yt_trailer_code)) ? $data->data->movie->yt_trailer_code : '';
            $language = $data->data->movie->language;
            $mpa_rating = $data->data->movie->mpa_rating;

            $this->year = $year;
            if(isset($data->data->movie->rating) && $data->data->movie->rating  > 0) $this->rating = $rating;
            $this->runtime = $runtime;
            if(empty($this->genres)) $this->genres = $genres;
            if(empty($this->description_full)) $this->description_full = $description_full;
            if(!empty($yt_trailer_code)) $this->yt_trailer_code = $yt_trailer_code;
            $this->language = $language;
            $this->mpa_rating = $mpa_rating;
            if(!empty($data->data->movie->download_count) && $data->data->movie->download_count > 0) $this->download_count = $data->data->movie->download_count;
            if($data->data->movie->like_count > 0) $this->like_count = $data->data->movie->like_count;
            if(empty($this->date_uploaded) && !empty($data->data->movie->date_uploaded)) $this->date_uploaded = $data->data->movie->date_uploaded;
            
            
            if(starts_with($this->cover_image,'/uploads') && !file_exists(ltrim($this->cover_image,'/')))
            {
                try{
                    $tmdb = file_get_contents('https://api.themoviedb.org/3/movie/'.$imdb_code.'?api_key=443880ff623cdfa7c3599a4d56c167ff');
                }
                catch(\Exception $e)
                {
                    $tmdb = json_encode([]);
                }  

                $tmdb = json_decode($tmdb);
                 
                if(!empty($tmdb->poster_path)) 
                {
                    $this->cover_image = 'https://image.tmdb.org/t/p/w342'.$tmdb->poster_path;
                }
                else{                
                
                    $destinationPath = 'images/movies/'.str_slug($title_long.' '.$imdb_code);
                    if (!file_exists($destinationPath)) {
                        mkdir($destinationPath, 0775, true);
                        chmod($destinationPath, 0775);       
                    }
                    
                    $small_cover_image = $destinationPath."/"."cover-small.jpg";
                    $medium_cover_image = $destinationPath."/"."cover-medium.jpg";
                    $large_cover_image = $destinationPath."/"."cover-large.jpg";

                    if(!empty($data->data->movie->medium_cover_image)){ 
                        try{
                            file_put_contents($medium_cover_image, fopen($data->data->movie->medium_cover_image, 'r'));
                        }
                        catch(\Exception $e)
                        {
                            $medium_cover_image = $destinationPath."/"."cover-medium.jpg";
                        }
                    }

                    $this->cover_image = "/".$medium_cover_image;
                }
                
                if(!empty($tmdb->backdrop_path))
                {
                    $background_image_path = 'https://image.tmdb.org/t/p/w1280'.$tmdb->backdrop_path;
                    $this->background_image = $background_image_path;
                }                
            }
            

            

            if(!empty($data->data->movie->torrents))
            {
                $torrentPath = 'uploads/movies/'.str_slug($this->title_long.' '.$imdb_code);
                if (!file_exists($torrentPath)) 
                {
                    mkdir($torrentPath, 0755, true);
                    chmod($torrentPath, 0755);       
                }                     
                foreach($data->data->movie->torrents as $t)
                {
                    $torrent_hash = trim($t->hash);
                    $torrent = Torrent::where('movie_id',$this->id)->where('hash',$torrent_hash)->first();

                    $torrent_quality = trim($t->quality);
                    $torrent_type = trim($t->type);
                    $torrent_seeds = trim($t->seeds);
                    $torrent_peers = trim($t->peers);
                    $torrent_size_bytes = trim($t->size_bytes);

                    if($torrent_quality == '3D'){
                        $torrent_resolution = '1920*1080';
                    }
                    elseif($torrent_quality == '2160p'){
                        $torrent_resolution = '3840*2160';
                    }                            
                    elseif($torrent_quality == '1080p'){
                        $torrent_resolution = '1920*1080';
                    }
                    elseif ($torrent_quality == '720p') {
                        $torrent_resolution = '1280*720';
                    }
                    else{
                        $torrent_resolution = '1280*720';
                    }


                    if(empty($torrent))
                    {
                        $torrent_file = $torrentPath."/".str_slug($title_long)."-".str_slug($torrent_quality).".torrent";
                        try{    
                          //  file_put_contents($torrent_file, fopen($t->url, 'r'));  
                            $torrent_file = "/".$torrent_file;  
                        }   
                        catch(\Exception $e)    
                        {   
                            $torrent_file = 'magnet:?xt=urn:btih:'.$torrent_hash.'&dn='.urlencode($this->title_long).'&tr=udp%3A%2F%2Ftracker.opentrackr.org%3A1337%2Fannounce&tr=udp%3A%2F%2Ftracker.leechers-paradise.org%3A6969%2Fannounce&tr=udp%3A%2F%2F9.rarbg.to%3A2710%2Fannounce&tr=udp%3A%2F%2Fp4p.arenabg.ch%3A1337%2Fannounce&tr=udp%3A%2F%2Ftracker.cyberia.is%3A6969%2Fannounce&tr=http%3A%2F%2Fp4p.arenabg.com%3A1337%2Fannounce&tr=udp%3A%2F%2Ftracker.internetwarriors.net%3A1337%2Fannounce'; 
                        }

                        $torrent = new Torrent();
                        $torrent->movie_id = $this->id;
                        $torrent->hash = $torrent_hash;
                        $torrent->quality = $torrent_quality;
                        $torrent->type = $torrent_type;
                        $torrent->seeds = $torrent_seeds;
                        $torrent->peers = $torrent_peers;
                        $torrent->size_bytes = $torrent_size_bytes;
                        $torrent->file = $torrent_file;
                        $torrent->resolution = $torrent_resolution;
                        $torrent->created_at = (!empty($t->date_uploaded)) ? $t->date_uploaded : date('Y-m-d H:i:s');
                        $torrent->save();
                        
                        $this->created_at = date('Y-m-d H:i:s');
                    }
                    else{
                        $torrent->quality = $torrent_quality;
                        $torrent->type = $torrent_type;
                        $torrent->seeds = $torrent_seeds;
                        $torrent->peers = $torrent_peers;
                        $torrent->size_bytes = $torrent_size_bytes;
                        $torrent->resolution = $torrent_resolution;
                        $torrent->created_at = (!empty($t->date_uploaded)) ? $t->date_uploaded : date('Y-m-d H:i:s');
                        $torrent->save();                        
                    }
                }
                return 'updated';
            }
            return 'api error'; 

        }
        else{
            return 'api error';
        }        
    }
    
    public function omdbUpdate()
    {
        if($this->rating == 0) $this->rating = rand(7,8) + rand(0, 10) / 10;
        
        if($this->download_count == 0 && $this->torrents->count() == 0) $this->download_count = rand(100000,500000);
        elseif($this->torrents->count() == 0) $this->download_count = $this->download_count + 5;
        else{ }
        
        if($this->like_count == 0 && $this->torrents->count() == 0) $this->like_count = rand(1000,5000);
        elseif($this->torrents->count() == 0) $this->like_count = $this->like_count + 5;
        else { }    
        
        if(empty($this->imdb_code)) return 'no imdb code';
        $omdb_api = 'http://www.omdbapi.com/?i='.$this->imdb_code.'&apikey=39923cad';
        
        try{
            $data = file_get_contents($omdb_api);
                 
            $omdb_data = json_decode($data);
        }
        catch(\Exception $e)
        {
            return 'api error';
        }
 
        if(isset($omdb_data->Response) && $omdb_data->Response == 'True')
        {
            $runtime = str_replace(' min','',$omdb_data->Runtime);
            $rated = (isset($omdb_data->Rated)) ? $omdb_data->Rated : 'N/A';
            $director = (isset($omdb_data->Director)) ? $omdb_data->Director : 'N/A';
            $writer = (isset($omdb_data->Writer)) ? $omdb_data->Writer : 'N/A';
            $description_full = (isset($omdb_data->Plot)) ? $omdb_data->Plot : 'N/A';
            $country = (isset($omdb_data->Country)) ? $omdb_data->Country : 'N/A';
            $awards = (isset($omdb_data->Awards)) ? $omdb_data->Awards : 'N/A';
            $critics = (isset($omdb_data->Metascore)) ? $omdb_data->Metascore : 'N/A';
            $imdbRating = (isset($omdb_data->imdbRating)) ? $omdb_data->imdbRating : 'N/A';
            $imdbVotes = (isset($omdb_data->imdbVotes)) ? $omdb_data->imdbVotes : 'N/A';
            $BoxOffice = (isset($omdb_data->BoxOffice)) ? $omdb_data->BoxOffice : 'N/A';
            $Production = (isset($omdb_data->Production)) ? $omdb_data->Production : 'N/A';
            $cast = (isset($omdb_data->Actors)) ? $omdb_data->Actors : 'N/A';
            $tomato_rating = 0;
            
            if(!empty($omdb_data->Ratings))
            {
                foreach($omdb_data->Ratings  as $rating)
                {
                    if($rating->Source == 'Rotten Tomatoes')
                    {
                        $tomato_rating = str_replace('%','',$rating->Value);
                    }
                }
            }
            
            if($this->runtime == 0 && $runtime != 'N/A') $this->runtime = $runtime;
            if(empty($this->mpa_rating) && $rated != 'N/A') $this->mpa_rating = $rated;
            if(empty($this->cast) && $cast != 'N/A') $this->cast = $cast;
            if(empty($this->director) && $director != 'N/A') $this->director = $director;
            if(empty($this->writer) && $writer != 'N/A') $this->writer = $writer;
            if(empty($this->$description_full) && $description_full != 'N/A') $this->description_full = $description_full;
            if($country != 'N/A') $this->country = $country;
            if($awards != 'N/A') $this->awards = $awards;
            if($critics != 'N/A') $this->tomato_critics = $critics;
            if($imdbVotes != 'N/A') $this->vote_count = str_replace(',','',$imdbVotes);
            if($this->torrents->count() > 0 && $imdbRating != 'N/A') $this->rating = $imdbRating;
            if($BoxOffice != 'N/A') $this->box_office = $BoxOffice;
            if($Production != 'N/A') $this->production = $Production;
            $this->tomato_audience = $tomato_rating;

            return 'updated';
        }        
        
        return 'api error';
    }

    public function yifySubtitlesUpdate()
    {
        try{
            $html = $this->curl_get_contents(config('settings.yify_subtitles_domain').'/movie-imdb/'.$this->imdb_code);
        }
        catch(\Exception $e){
            return 'api error';
        }

        $crawler = new Crawler($html);
        
        if($crawler->filter('tbody > tr')->count() == 0) return 'no subtitles';

        $subtitles = $crawler->filter('tbody > tr')->each(function($node){
            $yify_id = $node->attr('data-id');
            $language = ($node->filter('td')->eq(1)->count() > 0) ? $node->filter('td')->eq(1)->text() : '';
            $name = ($node->filter('td')->eq(2)->count() > 0) ? trim($node->filter('td')->eq(2)->text()) : '';
            $file = '';
            if($node->filter('td')->eq(2)->filter('a')->count() > 0)
            {
                $file = $node->filter('td')->eq(2)->filter('a')->attr('href');
                $file = str_replace('/subtitles', '/subtitle', $file);
                $file = config('settings.yify_subtitles_domain').$file.'.zip';
            }
            $uploader = ($node->filter('td')->eq(4)->count() > 0) ?trim($node->filter('td')->eq(4)->text()) : '';
            return ['yify_id' => $yify_id,'language' => $language, 'name' => $name, 'file' => $file, 'uploader' => $uploader];
        });
        
        $destinationPath = 'uploads/movies/'.str_slug($this->title_long.' '.$this->imdb_code).'/subtitles';
        if (!file_exists($destinationPath)) {
            mkdir($destinationPath, 0775, true);
            chmod($destinationPath, 0775);       
        }
        $sub_count = 0;
        foreach ($subtitles as $key => $sub) {

            $subtitle = Subtitle::where('yify_id',$sub['yify_id'])->first();
            if(!empty($subtitle)) continue;
        
            try{
                $filename = str_slug($this->title_long.' '.$sub['language'].' '.$sub['yify_id']).'.zip';
                $filepath = $destinationPath.'/'.$filename;
                file_put_contents($filepath, $this->curl_get_contents($sub['file']));
            }
            catch(\Exception $e){
                continue;
            }

            $subtitle = new Subtitle();
            $subtitle->movie_id = $this->id;
            $subtitle->yify_id = $sub['yify_id'];
            $subtitle->language = $sub['language'];
            $subtitle->name = $sub['name'];
            $subtitle->uploader = $sub['uploader'];
            $subtitle->file = '/'.$filepath;
            $subtitle->save();

            $sub_count++;

        }

        return $sub_count . ' subtitles added';
    }

    /*
    |--------------------------------------------------------------------------
    | RELATIONS
    |--------------------------------------------------------------------------
    */

    public function genres()
    {
        return $this->belongsToMany('App\Models\Genre', 'genre');
    }  

    public function torrents()
    {
        return $this->hasMany('App\Models\Torrent','movie_id','id')->orderBy('size_bytes','desc');
    }  

    public function latest_torrent()
    {
        return $this->hasOne('App\Models\Torrent','movie_id','id')->orderBy('size_bytes','desc');
    }  

    public function user()
    {
        return $this->hasOne('App\User','id','user_id');
    }

    public function director_meta()
    {
        return $this->hasOne('App\Models\Artist','name','director');
    }

    public function votes()
    {
        return $this->hasMany('App\Models\Vote');
    }

    public function videos()
    {
        return $this->hasMany('App\Models\Video')->orderBy('source');
    }    

    public function subtitles()
    {
        return $this->hasMany('App\Models\Subtitle')->orderBy('language');
    } 

    /*
    |--------------------------------------------------------------------------
    | SCOPES
    |--------------------------------------------------------------------------
    */

    /*
    |--------------------------------------------------------------------------
    | ACCESORS
    |--------------------------------------------------------------------------
    */

     // The slug is created automatically from the "title" field if no slug exists.
    public function getSlugOrTitleLongAttribute()
    {
        if ($this->slug != '') {
            return $this->slug;
        }

        return str_slug($this->title_long);
    }

    public function getVideoLinkAttribute()
    {
        return $this->attributes['video_link'] = config('settings.watch_movie_api').$this->imdb_code;
    }      

    public function getUrlAttribute()
    {
        return $this->attributes['url'] = route('movie.show',[$this->slug]);
    }     

    public function getDownloadCountFAttribute()
    {
        return $this->attributes['download_count_f'] = number_format($this->download_count);
    }     
    public function getCratedAtFAttribute()
    {
        return $this->attributes['created_at_f'] = $this->created_at->format('F d, Y \a\t h:i A');
    }     

    public function getRuntimeFAttribute()
    {
        $runtime = gmdate("G:i",$this->runtime*60). ' min'; 
        $runtime = str_replace(':','hr ',$runtime);
        return $this->attributes['runtime_f'] = $runtime;
    }    

    public function getThumbnailGenresAttribute()
    {
        $genres = explode(',',$this->genres);
        $genres = array_slice($genres, 0, 2);

        $genres = "<h4>".implode('</h4><h4>', $genres)."</h4>";
        return $this->attributes['thumbnail_genres'] = $genres;
    }

    public function getThumbnailAttribute()
    {
        if(empty($this->cover_image)) return $this->attributes['thumbnail'] = 'https://dummyimage.com/230x345/808080/ffffff/?text='.$this->title;
        
        if(starts_with($this->cover_image,'http')) return $this->attributes['thumbnail'] = $this->cover_image;
        
        if(env('IS_DUMMY') == true) return $this->attributes['thumbnail'] = env('SOURCE_DOMAIN').$this->cover_image;
        else return $this->attributes['thumbnail'] = url($this->cover_image);
        
    }    

    public function getBackgroundAttribute()
    {
        if(empty($this->cover_image)) return $this->attributes['background'] = null;
        
        if(starts_with($this->background_image,'http')) return $this->attributes['background'] = $this->background_image;
        
        if(env('IS_DUMMY') == true) return $this->attributes['background'] = env('SOURCE_DOMAIN').$this->background_image;
        else return $this->attributes['background'] = url($this->background_image);        
    }    

    public function getMetaTitleAttribute()
    {
        return $this->attributes['meta_title'] = '' . $this->title_long.' -  YIFY Torrent Magnet - YTS - Babytorrent';
    }    

    public function getMetaDescriptionAttribute()
    {
        return $this->attributes['meta_description'] = $this->title.' yify torrent magnet, - '. $this->title_long .' yify On Babytorrent By YTS -  Story : '. Str::words($this->description_full,20);
    }

    public function getMetaKeywordsAttribute()
    {
        return $this->attributes['meta_keywords'] = ''. $this->title_long .' yify, '. $this->title_long .' yify movies, '. $this->title_long .' yify torrent, '. $this->title_long .' torrent, '. $this->title_long .' yify subtitles, '. $this->title_long .' yify torrent magnet, yify subtitles '. $this->title_long .', '. $this->title_long .' yify movies official, '. $this->title_long .' yify torrent movies, '. $this->title_long .' full movie torrent, '. $this->title_long .' download movies' ;
    }

    /*
    |--------------------------------------------------------------------------
    | MUTATORS
    |--------------------------------------------------------------------------
    */



    protected static function curl_get_contents($url)
    {
        $user_agent='Mozilla/5.0 (Windows NT 6.1; rv:8.0) Gecko/20100101 Firefox/8.0';

        $options = array(

            CURLOPT_CUSTOMREQUEST  =>"GET",        //set request type post or get
            CURLOPT_POST           =>false,        //set to GET
            CURLOPT_USERAGENT      => $user_agent, //set user agent
            CURLOPT_COOKIEFILE     =>"cookie.txt", //set cookie file
            CURLOPT_COOKIEJAR      =>"cookie.txt", //set cookie jar
            CURLOPT_RETURNTRANSFER => true,     // return web page
            CURLOPT_HEADER         => false,    // don't return headers
            CURLOPT_FOLLOWLOCATION => true,     // follow redirects
            CURLOPT_ENCODING       => "",       // handle all encodings
            CURLOPT_AUTOREFERER    => true,     // set referer on redirect
            CURLOPT_CONNECTTIMEOUT => 120,      // timeout on connect
            CURLOPT_TIMEOUT        => 120,      // timeout on response
            CURLOPT_MAXREDIRS      => 10,       // stop after 10 redirects
            CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => 0
        );

        $ch      = curl_init( $url );
        curl_setopt_array( $ch, $options );
        $content = curl_exec( $ch );
        $err     = curl_errno( $ch );
        $errmsg  = curl_error( $ch );
        $header  = curl_getinfo( $ch );
        curl_close( $ch );

        $header['errno']   = $err;
        $header['errmsg']  = $errmsg;
        $header['content'] = $content;

        if($header['errno'] != 0) die('cURL Error - bad url, timeout, redirect loop');

        if ($header['http_code'] != 200) die('cURL Error - no page, no permissions, no service');

        return $header['content'];
    }
}