<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\CrudTrait;
use Cviebrock\EloquentSluggable\Sluggable;
use Cviebrock\EloquentSluggable\SluggableScopeHelpers;
use Illuminate\Support\Str;

class Season extends Model {

	use CrudTrait;
	use Sluggable, SluggableScopeHelpers;
    /*
	|--------------------------------------------------------------------------
	| GLOBAL VARIABLES
	|--------------------------------------------------------------------------
	*/

    public static function boot()
    {
        parent::boot();
        static::deleting(function($item) {

          \App\Models\STorrent::where('series_id',$item->series_id)->where('season_number',$item->season_number)->delete(); 
          \App\Models\ETorrent::where('series_id',$item->series_id)->where('season_number',$item->season_number)->delete();          
          \App\Models\OldLinkSeason::where('season_id',$item->id)->delete();            

        });
       
    } 


	protected $table = 'season';
	protected $primaryKey = 'id';
	protected $guarded = ['id'];
	// protected $guarded = [];
	// protected $hidden = ['id'];
	//protected $fillable = ['name'];
	public $timestamps = true;

	/**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'slug_or_title',
            ],
        ];
    }

	/*
	|--------------------------------------------------------------------------
	| FUNCTIONS
	|--------------------------------------------------------------------------
	*/


	/*
	|--------------------------------------------------------------------------
	| RELATIONS
	|--------------------------------------------------------------------------
	*/	
    public function episodes()
    {
        return $this->hasMany('App\Models\Episode', 'season_id','id');
    }

    public function series()
    {
        return $this->hasOne('App\Models\Series','id','series_id');
    } 

    public function user()
    {
    	return $this->hasOne('App\User','id','user_id');
    }

    public function votes()
    {
    	return $this->hasMany('App\Models\SVote');
    }

    public function videos()
    {
        return $this->hasMany('App\Models\SVideo')->orderBy('source');
    }   

  
	/*
	|--------------------------------------------------------------------------
	| SCOPES
	|--------------------------------------------------------------------------
	*/

	/*
	|--------------------------------------------------------------------------
	| ACCESORS
	|--------------------------------------------------------------------------
	*/

	 // The slug is created automatically from the "title" field if no slug exists.
    public function getSlugOrTitleAttribute()
    {
        if ($this->slug != '') {
            return $this->slug;
        }

        return $this->title;
    }

    public function getTitleLongAttribute()
    {
        return $this->attributes['title_long'] = $this->series->title_long. ' Season ' . $this->season_number;
    }

    public function getThumbnailAttribute()
    {
        return $this->attributes['thumbnail'] = (!empty($this->cover_image)) ? url($this->cover_image) : $this->series->thumbnail;
    } 
    public function getYearAttribute()
    {
        return $this->attributes['year'] = substr($this->air_date, 0,4);
    }
    public function getMetaTitleAttribute()
    {
        return $this->attributes['meta_title'] = '' . $this->title_long.' - (TV Series) Complete Yify TV Torrent - Download YTS';
    }    

    public function getMetaDescriptionAttribute()
    {
        return $this->attributes['meta_description'] = $this->title.' (TV Series) Complete Yify TV Torrent, - '. $this->title_long .' Download YTS Torrent -  Story : '. Str::words($this->description_full,20);
    }

    public function getMetaKeywordsAttribute()
    {
        return $this->attributes['meta_keywords'] = ''. $this->title_long .' yify, '. $this->title_long .' yify movies, '. $this->title_long .' yify torrent, '. $this->title_long .' torrent, '. $this->title_long .' yify subtitles, '. $this->title_long .' yify torrent magnet, yify subtitles '. $this->title_long .', '. $this->title_long .' yify movies official, '. $this->title_long .' yify torrent movies, '. $this->title_long .' full movie torrent, '. $this->title_long .' download movies' ;
    }   

     public function getCratedAtFAttribute()
    {
        return $this->attributes['created_at_f'] = $this->created_at->format('F d, Y \a\t h:i A');
    }     

    public function getUrlAttribute()
    {
        return $this->attributes['url'] = route('season.show',[$this->slug]);
    } 
	/*
	|--------------------------------------------------------------------------
	| MUTATORS
	|--------------------------------------------------------------------------
	*/
}