<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\CrudTrait;
use Cviebrock\EloquentSluggable\Sluggable;
use Cviebrock\EloquentSluggable\SluggableScopeHelpers;
use Illuminate\Support\Str;

class Series extends Model {

	use CrudTrait;
	use Sluggable, SluggableScopeHelpers;
    /*
	|--------------------------------------------------------------------------
	| GLOBAL VARIABLES
	|--------------------------------------------------------------------------
	*/

	protected $table = 'series';
	protected $primaryKey = 'id';
	protected $guarded = ['id'];
	// protected $guarded = [];
	// protected $hidden = ['id'];
	//protected $fillable = ['name'];
	public $timestamps = true;

	/**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'slug_or_title',
            ],
        ];
    }

	/*
	|--------------------------------------------------------------------------
	| FUNCTIONS
	|--------------------------------------------------------------------------
	*/
    public static function boot()
    {
        parent::boot();
        static::deleting(function($item) {

            $genres = explode(',',$item->genres);
            
            foreach($genres as $genre)
            {
                \Cache::forget('genre_series_'.md5($genre));
            }

          \App\Models\ETorrent::where('series_id',$item->id)->delete();
          \App\Models\STorrent::where('series_id',$item->id)->delete();
       //   \App\Models\SDownload::where('series_id',$item->id)->delete();            
          \App\Models\OldLinkSeries::where('series_id',$item->id)->delete();            

        });
        static::creating(function($item) {

            $genres = explode(',',$item->genres);
            
            foreach($genres as $genre)
            {
                \Cache::forget('genre_series_'.md5($genre));
            }

        });        
    } 

    public function openSeries($crud = false)
    {
        return '<a class="btn btn-xs btn-default" target="_blank" href="'.route('series.show',[$this->slug]).'"><i class="fa fa-search"></i> View</a>';
    }	
	    
    public function getTorrents($crud = false)
    {
        return '<a class="btn btn-xs btn-default" href="'.route('admin.series.get_torrents',[$this->id]).'"><i class="fa fa-renren"></i> Get Torrents</a>';
    }    
    public function getTgx($crud = false)
    {
        return '<a class="btn btn-xs btn-default" href="'.route('admin.series.tgx_torrents',[$this->id]).'"><i class="fa fa-renren"></i> TGX</a>';
    }   
        
    public function getT1337($crud = false)
    {
        return '<a class="btn btn-xs btn-default" href="'.route('admin.series.t1337_torrents',[$this->id]).'"><i class="fa fa-renren"></i> 1337x</a>';
    }   
    

	/*
	|--------------------------------------------------------------------------
	| RELATIONS
	|--------------------------------------------------------------------------
	*/

/*	public function articles()
    {
        return $this->hasMany('App\Models\Article', 'article_tag');
    }*/

    public function seasons()
    {
        return $this->hasMany('App\Models\Season', 'series_id','id')->orderBy('season_number','desc');
    }      
   

    public function episode_torrents()
    {
        return $this->hasMany('App\Models\ETorrent', 'series_id','id');
    }     

    public function season_torrents()
    {
        return $this->hasMany('App\Models\STorrent', 'series_id','id');
    }  

    public function user()
    {
    	return $this->hasOne('App\User','id','user_id');
    }
    
    public function director_meta()
    {
        return $this->hasOne('App\Models\Artist','name','director');
    }


    public function latest_torrent()
    {
        return $this->hasOne('App\Models\ETorrent','series_id','id')->orderBy('size_bytes','desc');
    }      
	/*
	|--------------------------------------------------------------------------
	| SCOPES
	|--------------------------------------------------------------------------
	*/

	/*
	|--------------------------------------------------------------------------
	| ACCESORS
	|--------------------------------------------------------------------------
	*/

	 // The slug is created automatically from the "title" field if no slug exists.
    public function getSlugOrTitleAttribute()
    {
        if ($this->slug != '') {
            return $this->slug;
        }

        return $this->title;
    }

    public function getThumbnailGenresAttribute()
    {
        $genres = explode(',',$this->genres);
        $genres = array_slice($genres, 0, 2);

        $genres = "<h4>".implode('</h4><h4>', $genres)."</h4>";
        return $this->attributes['thumbnail_genres'] = $genres;
    }

    public function getThumbnailAttribute()
    {
        return $this->attributes['thumbnail'] = (!empty($this->cover_image)) ? url($this->cover_image) : 'https://dummyimage.com/230x345/808080/ffffff/?text='.$this->title;
    }   

    public function getRuntimeFAttribute()
    {
        $runtime = gmdate("G:i",$this->runtime*60). ' min'; 
        $runtime = str_replace(':','hr ',$runtime);
        return $this->attributes['runtime_f'] = $runtime;
    } 

    public function getDownloadCountFAttribute()
    {
        return $this->attributes['download_count_f'] = number_format($this->download_count);
    }     
    public function getCratedAtFAttribute()
    {
        return $this->attributes['created_at_f'] = $this->created_at->format('F d, Y \a\t h:i A');
    }     

    public function getBackgroundAttribute()
    {
        if(empty($this->cover_image)) return $this->attributes['background'] = null;
        
        if(starts_with($this->background_image,'http')) return $this->attributes['background'] = $this->background_image;
        
        if(env('IS_DUMMY') == true) return $this->attributes['background'] = env('SOURCE_DOMAIN').$this->background_image;
        else return $this->attributes['background'] = url($this->background_image);        
    }  

    public function getMetaTitleAttribute()
    {
        return $this->attributes['meta_title'] = '' . $this->title_long.' (TV Series) -  Yify TV Torrent - Download YTS';
    }    

    public function getMetaDescriptionAttribute()
    {
        return $this->attributes['meta_description'] = $this->title.' (TV Series) Yify TV Torrent, - '. $this->title_long .' Download YTS Torrent -  Story : '. Str::words($this->description_full,20);
    }

    public function getMetaKeywordsAttribute()
    {
        return $this->attributes['meta_keywords'] = ''. $this->title_long .' yify, '. $this->title_long .' yify movies, '. $this->title_long .' yify torrent, '. $this->title_long .' torrent, '. $this->title_long .' yify subtitles, '. $this->title_long .' yify torrent magnet, yify subtitles '. $this->title_long .', '. $this->title_long .' yify movies official, '. $this->title_long .' yify torrent movies, '. $this->title_long .' full movie torrent, '. $this->title_long .' download movies' ;
    }    

    public function getUrlAttribute()
    {
        return $this->attributes['url'] = route('series.show',[$this->slug]);
    }            
	/*
	|--------------------------------------------------------------------------
	| MUTATORS
	|--------------------------------------------------------------------------
	*/

    public function omdbUpdate()
    {
        if($this->rating == 0) $this->rating = rand(7,8) + rand(0, 10) / 10;
        
        if($this->download_count == 0) $this->download_count = rand(100000,500000);
        else $this->download_count = $this->download_count + 5;
        
        if($this->like_count == 0) $this->like_count = rand(1000,5000);
        else $this->like_count = $this->like_count + 5;
        
        if(empty($this->imdb_code)) return 'no imdb code';
        $omdb_api = 'http://www.omdbapi.com/?i='.$this->imdb_code.'&apikey=39923cad';
        
        try{
            $data = file_get_contents($omdb_api);
                 
            $omdb_data = json_decode($data);
        }
        catch(\Exception $e)
        {
            return 'api error';
        }
 
        if(isset($omdb_data->Response) && $omdb_data->Response == 'True')
        {
            $runtime = str_replace(' min','',$omdb_data->Runtime);
            $rated = (isset($omdb_data->Rated)) ? $omdb_data->Rated : 'N/A';
            $director = (isset($omdb_data->Director)) ? $omdb_data->Director : 'N/A';
            $writer = (isset($omdb_data->Writer)) ? $omdb_data->Writer : 'N/A';
            $description_full = (isset($omdb_data->Plot)) ? $omdb_data->Plot : 'N/A';
            $country = (isset($omdb_data->Country)) ? $omdb_data->Country : 'N/A';
            $awards = (isset($omdb_data->Awards)) ? $omdb_data->Awards : 'N/A';
            $critics = (isset($omdb_data->Metascore)) ? $omdb_data->Metascore : 'N/A';
            $imdbRating = (isset($omdb_data->imdbRating)) ? $omdb_data->imdbRating : 'N/A';
            $imdbVotes = (isset($omdb_data->imdbVotes)) ? $omdb_data->imdbVotes : 'N/A';
            $cast = (isset($omdb_data->Actors)) ? $omdb_data->Actors : 'N/A';
            $tomato_rating = 0;
            
            if(!empty($omdb_data->Ratings))
            {
                foreach($omdb_data->Ratings  as $rating)
                {
                    if($rating->Source == 'Rotten Tomatoes')
                    {
                        $tomato_rating = str_replace('%','',$rating->Value);
                    }
                }
            }
            
            if($this->runtime == 0 && $runtime != 'N/A') $this->runtime = $runtime;
            if(empty($this->mpa_rating) && $rated != 'N/A') $this->mpa_rating = $rated;
            if(empty($this->cast) && $cast != 'N/A') $this->cast = $cast;
            if(empty($this->director) && $director != 'N/A') $this->director = $director;
            if(empty($this->writer) && $writer != 'N/A') $this->writer = $writer;
            if(empty($this->$description_full) && $description_full != 'N/A') $this->description_full = $description_full;
            if($country != 'N/A') $this->country = $country;
            if($awards != 'N/A') $this->awards = $awards;
            if($critics != 'N/A') $this->tomato_critics = $critics;
            if($imdbVotes != 'N/A') $this->vote_count = str_replace(',','',$imdbVotes);
            if($imdbRating != 'N/A') $this->rating = $imdbRating;
            $this->tomato_audience = $tomato_rating;

            return 'updated';
        }        
        
        return 'api error';
    }

    public function eztvUpdate()
    {
        if(empty($this->imdb_code)) return 'no imdb code';
        $imdb_code = str_replace('tt', '', $this->imdb_code);
        $page_limit = 1;
        for ($i=1; $i <= $page_limit; $i++) 
        { 
            $api = 'https://eztv.li/api/get-torrents?limit=100&imdb_id='.$imdb_code.'&page='.$i;

            try{
                $response = file_get_contents($api);
                $data = json_decode($response);
            }
            catch(\Exception $e)
            {
                return 'api error';
            }

            $page_limit = ceil($data->torrents_count / 100);

            if(empty($data->torrents)) return 'no torrents';

            foreach ($data->torrents as $data_torrent) 
            {
                if ($data_torrent->season > 0 && $data_torrent->episode == 0) 
                {

                    $storrent = \App\Models\STorrent::where('hash',$data_torrent->hash)->where('series_id',$this->id)->where('season_number',$data_torrent->season)->first();
                    if(empty($storrent))
                    { 

                        $storrent = new \App\Models\STorrent();
                        $storrent->series_id = $this->id;
                        $storrent->season_number = $data_torrent->season;
                        $storrent->name = $data_torrent->title;
                        $storrent->hash = $data_torrent->hash;
                        $storrent->quality = $this->getQuality($data_torrent->title);
                        $storrent->resolution = $this->getResolution($storrent->quality);
                        $storrent->size_bytes = $data_torrent->size_bytes; 
                        $storrent->magnet = $data_torrent->magnet_url; 

                        $torrentPath = 'uploads/series/'.str_slug($this->title_long).'/'.str_slug('season '.$data_torrent->season);
                        if (!file_exists($torrentPath)) {
                            mkdir($torrentPath, 0775, true);
                            chmod($torrentPath, 0775);       
                        }                    
                        $torrent_file = $torrentPath."/".str_slug($this->title_long)."-".str_slug($storrent->quality)."-".str_random(3).".torrent";
                        try{    
                          //  file_put_contents($torrent_file, fopen($data_torrent->torrent_url, 'r'));  
                            $torrent_file = "/".$torrent_file;  
                        }   
                        catch(\Exception $e)    
                        {   
                            $torrent_file = 'magnet:?xt=urn:btih:'.$storrent->hash.'&dn='.urlencode($this->title_long).'&tr=udp://tracker.coppersurfer.tk:80&tr=udp://glotorrents.pw:6969/announce&tr=udp://tracker.leechers-paradise.org:6969&tr=udp://tracker.opentrackr.org:1337/announce&tr=udp://exodus.desync.com:6969'; 
                        } 

                        $storrent->file = $torrent_file;      

                        $this->created_at = date('Y-m-d H:i:s');             

                    }

                    $storrent->seeds = $data_torrent->seeds; 
                    $storrent->peers = $data_torrent->peers; 
                    $storrent->save();
                    continue;
                }

                $torrent = \App\Models\ETorrent::where('hash',$data_torrent->hash)->where('series_id',$this->id)->where('season_number',$data_torrent->season)->where('episode_number',$data_torrent->episode)->first();
                if(empty($torrent))
                { 
                    $torrent = new \App\Models\ETorrent();
                    $torrent->series_id = $this->id;
                    $torrent->season_number = $data_torrent->season;
                    $torrent->episode_number = $data_torrent->episode;
                    $torrent->name = $data_torrent->title;
                    $torrent->hash = $data_torrent->hash;
                    $torrent->quality = $this->getQuality($data_torrent->title);
                    $torrent->resolution = $this->getResolution($torrent->quality);
                    $torrent->size_bytes = $data_torrent->size_bytes; 
                    $torrent->magnet = $data_torrent->magnet_url; 

                    $torrentPath = 'uploads/series/'.str_slug($this->title_long).'/'.str_slug('season '.$data_torrent->season).'/'.str_slug('episode '.$data_torrent->episode);
                    if (!file_exists($torrentPath)) {
                        mkdir($torrentPath, 0775, true);
                        chmod($torrentPath, 0775);       
                    }                    
                    $torrent_file = $torrentPath."/".str_slug($this->title_long)."-".str_slug('season '.$data_torrent->season)."-". str_slug('episode '.$data_torrent->episode) ."-".str_slug($torrent->quality)."-".str_random(3).".torrent";
                    try{    
                       // file_put_contents($torrent_file, fopen($data_torrent->torrent_url, 'r'));  
                        $torrent_file = "/".$torrent_file;  
                    }   
                    catch(\Exception $e)    
                    {   
                        $torrent_file = 'magnet:?xt=urn:btih:'.$torrent->hash.'&dn='.urlencode($this->title_long).'&tr=udp://tracker.coppersurfer.tk:80&tr=udp://glotorrents.pw:6969/announce&tr=udp://tracker.leechers-paradise.org:6969&tr=udp://tracker.opentrackr.org:1337/announce&tr=udp://exodus.desync.com:6969'; 
                    } 

                    $torrent->file = $torrent_file;      

                    $this->created_at = date('Y-m-d H:i:s');             

                }

                $torrent->seeds = $data_torrent->seeds; 
                $torrent->peers = $data_torrent->peers; 
                $torrent->save();
                

            }
        }

    }


    protected static function getQuality($name)
    {
        if (strpos($name, '420p') !== false) {
            $quality = '420p';
        }
        elseif (strpos($name, 'HDCAM') !== false) {
            $quality = 'HDCAM';
        }        
        elseif (strpos($name, 'HDTS') !== false) {
            $quality = 'HDTS';
        }        
        elseif (strpos($name, '720p') !== false) {
            $quality = '720p';
        }
        elseif (strpos($name, '1080p') !== false) {
            $quality = '1080p';
        }         
        elseif (strpos($name, '2160p') !== false) {
            $quality = '2160p';
        }        
        elseif (strpos($name, 'blueray') !== false) {
            $quality = 'blueray';
        }        
        elseif (strpos($name, '3D') !== false) {
            $quality = '3D';
        }        
        else{
            $quality = '720p';
        }
        return $quality;
    }     

    protected static function getResolution($torrent_quality)
    {
        if($torrent_quality == '3D'){
            $torrent_resolution = '1920*1080';
        }
        elseif($torrent_quality == '2160p'){
            $torrent_resolution = '3840*2160';
        }                            
        elseif($torrent_quality == '1080p'){
            $torrent_resolution = '1920*1080';
        }
        elseif ($torrent_quality == '720p') {
            $torrent_resolution = '1280*720';
        }
        else{
            $torrent_resolution = '1280*720';
        }
        return $torrent_resolution;
    }
}