<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Subtitle extends Model {


    /*
	|--------------------------------------------------------------------------
	| GLOBAL VARIABLES
	|--------------------------------------------------------------------------
	*/

	protected $table = 'subtitles';
	protected $primaryKey = 'id';
	protected $guarded = ['id'];
	// protected $hidden = ['id'];
	public $timestamps = true;

	/*
	|--------------------------------------------------------------------------
	| FUNCTIONS
	|--------------------------------------------------------------------------
	*/

	/*
	|--------------------------------------------------------------------------
	| RELATIONS
	|--------------------------------------------------------------------------
	*/

	public function movie()
	{
		return $this->hasOne('App\Models\Movie','id','movie_id');
	}


	/*
	|--------------------------------------------------------------------------
	| SCOPES
	|--------------------------------------------------------------------------
	*/

	/*
	|--------------------------------------------------------------------------
	| ACCESORS
	|--------------------------------------------------------------------------
	*/


	public function getDownloadUrlAttribute()
	{
		return $this->attributes['file_f'] = url($this->file);
	}	



	/*
	|--------------------------------------------------------------------------
	| MUTATORS
	|--------------------------------------------------------------------------
	*/
}