<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Torrent extends Model {


    /*
	|--------------------------------------------------------------------------
	| GLOBAL VARIABLES
	|--------------------------------------------------------------------------
	*/

	protected $table = 'torrent';
	protected $primaryKey = 'id';
	protected $guarded = ['id'];
	// protected $hidden = ['id'];
	public $timestamps = true;

	/*
	|--------------------------------------------------------------------------
	| FUNCTIONS
	|--------------------------------------------------------------------------
	*/

	/*
	|--------------------------------------------------------------------------
	| RELATIONS
	|--------------------------------------------------------------------------
	*/

	public function movie()
	{
		return $this->hasOne('App\Models\Movie','id','movie_id');
	}


	/*
	|--------------------------------------------------------------------------
	| SCOPES
	|--------------------------------------------------------------------------
	*/

	/*
	|--------------------------------------------------------------------------
	| ACCESORS
	|--------------------------------------------------------------------------
	*/

	public function getBannerAttribute()
	{
		$banner = null;
		if (stripos($this->quality, '720') !== false) {
			$banner = url('img/banner720p.png');
		}
		elseif (stripos($this->quality, '1080') !== false) {
			$banner = url('img/banner1080p.png');
		}		
		elseif (stripos($this->quality, '3D') !== false) {
			$banner = url('img/banner3D.png');
		}		
		elseif (stripos($this->quality, '2160') !== false) {
			$banner = url('img/banner2160p.png');
		}
		return $this->attributes['banner'] = $banner;
	}

	public function getSizeFAttribute()
	{
	    $bytes = $this->size_bytes;
	    $precision = 2;
	    
        if ($bytes > pow(1024,3)) $size_f = round($bytes / pow(1024,3), $precision)."GB";
        else if ($bytes > pow(1024,2)) $size_f = round($bytes / pow(1024,2), $precision)."MB";
        else if ($bytes > 1024) $size_f = round($bytes / 1024, $precision)."KB";
        else $size_f = ($bytes)."B";
    
		return $this->attributes['size_f'] = $size_f;
	}	

	public function getDownloadUrlAttribute()
	{
	    if(starts_with($this->file,'magnet')) return $this->file;
		return $this->attributes['download_url'] = 'magnet:?xt=urn:btih:'.$this->hash.'&dn='.urlencode($this->movie->title).'&'.config('settings.torrent_trackers');
		//return $this->attributes['download_url'] = route('movie.torrent.download',[$this->hash]);
	}	

	public function getMetaTitleAttribute()
	{
		return $this->attributes['meta_title'] = 'Download '.$this->movie->title.' YIFY Torrent '.$this->quality;
	}

	public function getMetaMagnetTitleAttribute()
	{
		return $this->attributes['meta_magnet_title'] = 'Download '.$this->movie->title.' YIFY Torrent '.$this->quality;
	}



	/*
	|--------------------------------------------------------------------------
	| MUTATORS
	|--------------------------------------------------------------------------
	*/
}