<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

use App\Models\MenuItem;
use App\Models\Genre;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {    	
        if(env('DB_DATABASE') == 'MY_DBNAME'){
             redirect('/install')->send();
        }    	

        if(starts_with(env('APP_URL', 'http'),'https')){
            \URL::forceScheme('https');
        }

        $data['menu_items'] = \Cache::remember('menu_items',9000,function(){
            return MenuItem::orderBy('lft')->get();
        });
        
        $data['movie_genres'] =  \Cache::remember('movie_genres',900,function(){
            return Genre::orderBy('name')->get();
        });
        
        view()->share($data);
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        // register the services that are only used for development
        if ($this->app->environment() == 'local') {
            $this->app->register('Laracasts\Generators\GeneratorsServiceProvider');
            $this->app->register('Backpack\Generators\GeneratorsServiceProvider');
        }
    }
}
