<?php

namespace App;

use Backpack\Base\app\Notifications\ResetPasswordNotification as ResetPasswordNotification;
use Backpack\CRUD\CrudTrait;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
use DB;

class User extends Authenticatable
{
    use Notifiable;
    use CrudTrait;
    use HasRoles;
    
    protected $primaryKey = 'id';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * Send the password reset notification.
     *
     * @param string $token
     *
     * @return void
     */
    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetPasswordNotification($token));
    }

    public function role()
    {
        $role = DB::select('select * from role_users where user_id = ?', [$this->id]);
        if(count($role) == 0) return "-";
        $role = $role[0]->role_id;
        $user_role = DB::select('select name from roles where id = ?', [$role]);
        if(count($user_role) == 0) return "-";
        return $user_role[0]->name;
    }

    public function getAvatarAttribute()
    {   
        if(!empty($this->attributes['avatar'])){
            $random = rand(1000,9999);
            
            if(env('IS_DUMMY') == true) return $this->attributes['avatar'] = (!empty($this->avatar)) ? env('SOURCE_DOMAIN').$this->avatar : 'https://ui-avatars.com/api/?background=random&name='.$this->name;
            
            return $this->attributes['avatar'].'?t='.$random;
        }
        else{
            return $this->attributes['avatar'] = 'https://ui-avatars.com/api/?background=random&name='.$this->name;
        }
    }     

    public function getUrlAttribute()
    {
        return $this->attributes['url'] = route('user.show',[$this->name]);
    }     
}
