@extends('backpack::layout')
@section('after_styles')
<!-- include select2 css-->
<link href="{{ asset('vendor/adminlte/plugins/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2-bootstrap-theme/0.1.0-beta.10/select2-bootstrap.min.css" rel="stylesheet" type="text/css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css"  />
@stop
@section('after_scripts')
<script src="{{ asset('vendor/adminlte/plugins/select2/select2.min.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>
<script>
jQuery(document).ready(function($) {
    
    $('.select2_field').each(function (i, obj) {
        if (!$(obj).hasClass("select2-hidden-accessible"))
        {
            $(obj).select2({
                theme: "bootstrap"
            });
        }
    });
    
    $('[name="created_at"]').datepicker({ format: 'yyyy-mm-dd 00:00:01', todayBtn: true,todayHighlight: true });
 });
</script>
@stop
@section('content') 
<!-- Content Header (Page header) -->
<section class="content-header">
  <h1> Edit <span>Movie</span> </h1>
  <ol class="breadcrumb">
    <li><a href="{{url('admin/dashboard')}}">Admin</a></li>
    <li><a href="{{url('admin/movie')}}" class="text-capitalize">movies</a></li>
    <li class="active">Edit</li>
  </ol>
</section>

<!-- Main content -->
<section class="content">
  <div class="row">
    <div class="col-md-8 col-md-offset-2"> 
      <!-- Default box --> 
      <a href="{{url('admin/movie')}}"><i class="fa fa-angle-double-left"></i> Back to all <span>movies</span></a><br>
      <br>
      <form method="POST" action="" accept-charset="UTF-8" enctype="multipart/form-data">
        {{csrf_field()}}
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">Edit a movie</h3>
            - <a href="{{ $movie->url }}"> <i class="fa fa-eye"></i> View Movie</a>
          </div>
          <div class="box-body row"> 

            <div class="form-group col-md-6">
              <label>Title</label>
              <input type="text" name="title" placeholder="Movie Name" class="form-control" value="{{old('title',$movie->title)}}">
            </div>            

            <div class="form-group col-md-6">
              <label>Title Long</label>
              <input type="text" name="title_long" placeholder="Movie Name (Year)" class="form-control" value="{{old('title_long',$movie->title_long)}}">
            </div>
            
            <div class="form-group col-md-6">
              <label>Slug (Permalink)</label>
              <input type="text" name="slug" placeholder="Movie Slug" class="form-control" value="{{old('slug',$movie->slug)}}">
            </div>            
            
            <div class="form-group col-md-3">
              <label>IMDB Code</label>
              <input type="text" name="imdb_code" placeholder="XXXXXXXXXXX" class="form-control" value="{{old('imdb_code',$movie->imdb_code)}}">
            </div>            
            <div class="form-group col-md-3">
              <label>IMDB Rate</label>
              <input type="number" name="rating" placeholder="5" max="10" step="any" class="form-control" value="{{old('rating',$movie->rating)}}">
            </div>            

            <div class="form-group col-md-6">
              <label>Year</label>
              <input type="text" name="year" placeholder="YYYY" class="form-control" value="{{old('year',$movie->year)}}">
            </div>            
            <div class="form-group col-md-6">
              <label>Runtime</label>
              <input type="number" name="runtime" placeholder="60" class="form-control" value="{{old('runtime',$movie->runtime)}}">
            </div>

            <div class="form-group col-md-12">
                <label>Genre</label>
                <select name="genres[]" class="form-group select2_field" multiple="multiple" data-placeholder="Select Genres" style="width: 100%;">
                    @foreach($movie_genres as $genre)
                                                @php
                                                    if(old('genres')){
                                                      $selected_genres = old('genres');
                                                    }
                                                    else{
                                                      $selected_genres = array_filter(explode(',',$movie->genres));
                                                    }
                                                    if(in_array($genre->name,$selected_genres))
                                                        $selected = 'selected';
                                                    else
                                                        $selected = '';
                                                @endphp

                    <option value="{{$genre->name}}" {{$selected}}>{{$genre->name}}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group col-md-6">
              <label>YouTube Trailer Code / Trailer Link</label>
              <input type="text" name="yt_trailer_code" placeholder="XXXXXXXXXXX" class="form-control" value="{{old('yt_trailer_code',$movie->yt_trailer_code)}}">
            </div>                
            <div class="form-group col-md-6">
              <label>Language</label>
              <input type="text" name="language" placeholder="English" class="form-control" value="{{old('language',$movie->language)}}">
            </div>   

            <div class="form-group col-md-6">
              <label>MPA Rating</label>
              <input type="text" name="mpa_rating" placeholder="G / PG / PG-13 / R / NC-17" class="form-control" value="{{old('mpa_rating',$movie->mpa_rating)}}">
            </div>            
            <div class="form-group col-md-6">
              <label>Director</label>
              <input type="text" name="director" placeholder="Director Name" class="form-control" value="{{old('director',$movie->director)}}">
            </div> 

            <div class="form-group col-md-12">
                <label>Cast</label>
                <textarea class="form-control" name="cast" placeholder="names separated by comma">{{old('cast',$movie->cast)}}</textarea>
            </div>     


            <div class="form-group col-md-6">
              <label>Tomato Critics</label>
                <div class="input-group">              
              <input type="number" name="tomato_critics" placeholder="30" max="100" class="form-control" value="{{old('tomato_critics',$movie->tomato_critics)}}">
                                <div class="input-group-addon">
                    <i class="fa fa-percent"></i>
                  </div>
          </div>
            </div>            
            <div class="form-group col-md-6">
              <label>Tomato Audience</label>
                              <div class="input-group"> 
              <input type="number" name="tomato_audience" placeholder="30" max="100" class="form-control" value="{{old('tomato_audience',$movie->tomato_audience)}}">
                                              <div class="input-group-addon">
                    <i class="fa fa-percent"></i>
                  </div>
          </div>
            </div>  
            <div class="form-group col-md-12">
              <label>Cover Image</label><br/>
              <img src="{{$movie->cover_image}}?v={{rand()}}" height="120" width="80" alt="Cover Image">
            </div>
            <div class="form-group col-md-12">
                <label>Change Cover Image</label>
                <input type="file" name="cover_image" class="form-control" accept="image/jpeg;image/png">
            </div>                
            <div class="form-group col-md-12">
              <label>Background Image</label><br/>
              @if(!empty($movie->background_image))<a href="{{$movie->background_image}}?v={{rand()}}" target="_blank"><img src="{{$movie->background_image}}?v={{rand()}}" height="120" width="120" alt="Background Image"></a>@else Not available @endif
            </div>
            <div class="form-group col-md-12">
                <label>Change Background Image</label>
                <input type="file" name="background_image" class="form-control" accept="image/jpeg;image/png">
            </div>              
            <div class="form-group col-md-12">
              <label>Screenshots</label><br/>
              @if(!empty($movie->screenshots))
                @php $screenshots = json_decode($movie->screenshots); @endphp
                @foreach($screenshots  as $screenshot)
                 <a href="{{$screenshot}}?v={{rand()}}" target="_blank"><img src="{{$screenshot}}?v={{rand()}}" height="80" width="120" alt="Screenshot"></a> 
                @endforeach
              @else Not available @endif
            </div>
            <div class="form-group col-md-12">
                <label>Change Screenshots</label>
                <input type="file" name="screenshots[]" class="form-control" accept="image/jpeg;image/png" multiple>
            </div>     

            <div class="form-group col-md-12">
                <label>Description</label>
                <textarea class="form-control" name="description_full">{{old('description_full',$movie->description_full)}}</textarea>
            </div>

            <div class="form-group col-md-6">
                <label>Active</label>
                @php $selected = old('active',$movie->active); @endphp
                <select name="active" class="form-control">
                    <option value="1" @if($selected == "1") selected @endif>Yes</option>
                    <option value="0" @if($selected == "0") selected @endif>No</option>
                </select>
            </div>            
            
            <div class="form-group col-md-6">
                <label>Featured</label>
                @php $selected = old('featured',$movie->featured); @endphp
                <select name="featured" class="form-control">
                    <option value="1" @if($selected == 1) selected @endif>Yes</option>
                    <option value="0" @if($selected == 0) selected @endif>No</option>
                </select>
            </div>

            <div class="form-group col-md-6">
                <label>Created At</label>
                <input type="text" class="form-control" name="created_at" value="{{old('created_at',$movie->created_at)}}">
            </div>            
            
            <div class="form-group col-md-6">
                <label>Find Me</label>
                <input type="text" class="form-control" name="findme" value="{{old('findme',$movie->findme)}}">
            </div>


            <div class="form-group col-md-6">
                <label>Direct Download Link</label>
                <input type="text" class="form-control" name="direct_link" value="{{old('direct_link',$movie->direct_link)}}">
            </div>
            

          </div>
          <!-- /.box-body -->
          <div class="box-footer">
            <div id="saveActions" class="form-group">
                <button type="submit" class="btn btn-success" onclick=""> Save </button>
                <a href="{{url('admin/movies')}}" class="btn btn-default"><span class="fa fa-ban"></span> &nbsp;Cancel</a> 
            </div>
          </div>
          <!-- /.box-footer--> 
        </div>
        <!-- /.box -->
      </form>
    </div>
  </div>
</section>
<!-- /.content --> 
@stop

@section('after_scripts')
<script type="text/javascript">
window.onbeforeunload = renderLoading;
function renderLoading()
{
    Pace.stop()
    Pace.bar.render();
}  
</script>
@stop