@extends('backpack::layout')
@section('content') 
<!-- Content Header (Page header) -->
<section class="content-header">
  <h1> TGX & 1337x Scrapper </h1>
  <ol class="breadcrumb">
    <li><a href="{{url('admin/dashboard')}}">Admin</a></li>
    <li><a href="{{ url('admin/movie') }}">Movies</a></li>
    <li><a href="#" class="text-capitalize">{{ $movie->title_long }}</a></li>
    <li class="active">TGX & 1337x</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
    
    
  <div class="row">
    <div class="col-md-8 col-md-offset-2"> 
      <!-- Default box --> 
      <form method="POST" action="" accept-charset="UTF-8" enctype="multipart/form-data">
        {{csrf_field()}}
        <input type="hidden" name="movie_id" value="{{ $movie->id }}">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">TGX Scrapper - {{ $movie->title_long }}</h3>
          </div>
          <div class="box-body row"> 
        
            <div class="form-group col-md-12">
                <label>TGX Page Link</label>
                <input type="text" class="form-control" name="page_link" placeholder="https://torrentgalaxy.to/torrent/XXXXXXX/XXXXXXXXXXXXXXXXXXXXXXXXX" value="{{old('page_link')}}" autocomplete="off">
            </div>              
            

          </div>
          <!-- /.box-body -->
          <div class="box-footer">
            <div id="saveActions" class="form-group">
                <button type="submit" class="btn btn-success" onclick=""> Scrap </button>
            </div>
          </div>
          <!-- /.box-footer--> 
        </div>
        <!-- /.box -->
      </form>
    </div>
  </div>
  
  
  <div class="row">
    <div class="col-md-8 col-md-offset-2"> 
      <!-- Default box --> 
      <form method="POST" action="{{ route('admin.movie.t1337_torrents',[$movie->id]) }}" accept-charset="UTF-8" enctype="multipart/form-data">
        {{csrf_field()}}
        <input type="hidden" name="movie_id" value="{{ $movie->id }}">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">1337x Scrapper - {{ $movie->title_long }}</h3>
          </div>
          <div class="box-body row"> 
        
            <div class="form-group col-md-12">
                <label>1337x Page Link</label>
                <input type="text" class="form-control" name="torrent_link" placeholder="https://1337x.to/XXXXXXX/XXXXXXXXXXXXXXXXXXXXXXXXX" value="{{old('torrent_link')}}" autocomplete="off">
            </div>              
            

          </div>
          <!-- /.box-body -->
          <div class="box-footer">
            <div id="saveActions" class="form-group">
                <button type="submit" class="btn btn-success" onclick=""> Scrap </button>
            </div>
          </div>
          <!-- /.box-footer--> 
        </div>
        <!-- /.box -->
      </form>
    </div>
  </div>
    
  
  
  
</section>
<!-- /.content --> 
@stop

@section('after_scripts')
<script type="text/javascript">
window.onbeforeunload = renderLoading;
function renderLoading()
{
    Pace.stop()
    Pace.bar.render();
}  
</script>
@stop