@extends('backpack::layout')
@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>
  <span class="text-capitalize">torrents</span>
  <small>All  <span>torrents</span> in {{$movie->title_long}}.</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="{{url('admin/dashboard')}}">Admin</a></li>
    <li><a href="{{url('admin/movie')}}" class="text-capitalize">movies</a></li>
    <li><a href="#" class="text-capitalize">{{$movie->title_long}}</a></li>
    <li class="active">Torrents</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
  <!-- Default box -->
  <div class="row">
    <!-- THE ACTUAL CONTENT -->
    <div class="col-md-12">
      <div class="box">
        <div class="box-header with-border">
          <a href="{{url('admin/movie/'.$movie->id.'/torrent/create')}}" class="btn btn-primary ladda-button" data-style="zoom-in"><span class="ladda-label"><i class="fa fa-plus"></i> Add Torrent</span></a>
          
          <div id="datatable_button_stack" class="pull-right text-right"></div>
        </div>
        <div class="box-body table-responsive">
          
          
          <table id="crudTable" class="table table-bordered table-striped display">
            <thead>
              <tr>                            
                <th>Quality</th>
                <th>Resolution</th>
                <th>Seeds</th>
                <th>Peers</th>
                <th>FPS</th>
                <th>Size</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              @forelse($torrents as $torrent)
              <tr>                            
                <td>{{$torrent->quality}}</td>
                <td>{{$torrent->resolution}}</td>
                <td>{{$torrent->seeds}}</td>
                <td>{{$torrent->peers}}</td>
                <td>{{$torrent->fps}}</td>
                <td>{{round($torrent->size_bytes/1024/1024,2)}} MB</td>
                <td>  <a href="{{ url('admin/movie/'.$movie->id.'/torrent/'.$torrent->id.'/edit') }}" class="btn btn-xs btn-default"><i class="fa fa-edit"></i> Edit</a> <a href="{{ url('admin/movie/'.$movie->id.'/torrent/'.$torrent->id.'/delete') }}" class="btn btn-xs btn-default"><i class="fa fa-trash"></i> Delete</a> </td>
              </tr>    
              @empty
                <tr>
                  <td colspan="7" align="center">No torrents available.</td>
                </tr> 
              @endforelse
            </tbody>            
            <tfoot>
              <tr>                            
                <th>Quality</th>
                <th>Resolution</th>
                <th>Seeds</th>
                <th>Peers</th>
                <th>FPS</th>
                <th>Size</th>
                <th>Actions</th>
              </tr>
            </tfoot>
          </table>
          </div><!-- /.box-body -->
          
          </div><!-- /.box -->
        </div>
      </div>
    </section>
    <!-- /.content -->
@stop