@extends('backpack::layout')
@section('after_styles')
<!-- include select2 css-->
<link href="{{ asset('vendor/adminlte/plugins/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2-bootstrap-theme/0.1.0-beta.10/select2-bootstrap.min.css" rel="stylesheet" type="text/css" />
@stop
@section('after_scripts')
<script src="{{ asset('vendor/adminlte/plugins/select2/select2.min.js') }}"></script>
<script>
jQuery(document).ready(function($) {
    
    $('.select2_field').each(function (i, obj) {
        if (!$(obj).hasClass("select2-hidden-accessible"))
        {
            $(obj).select2({
                theme: "bootstrap"
            });
        }
    });
 });
</script>
@stop
@section('content') 
<!-- Content Header (Page header) -->
<section class="content-header">
  <h1> Edit <span>Video</span> </h1>
  <ol class="breadcrumb">
    <li><a href="{{url('admin/dashboard')}}">Admin</a></li>
    <li><a href="{{url('admin/series')}}" class="text-capitalize">series</a></li>
    <li><a href="{{url('admin/series/'.$series->id.'/seasons')}}" class="text-capitalize">seasons</a></li>
    <li><a href="#" class="text-capitalize">{{$season->title_long}}</a></li>
    <li class="active">Edit</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
  <div class="row">
    <div class="col-md-8 col-md-offset-2"> 
      <!-- Default box --> 
      <a href="{{url('admin/series/'.$series->id.'/seasons/'.$season->id.'/video')}}"><i class="fa fa-angle-double-left"></i> Back to all <span>videos</span> of {{$season->title_long}}</a><br>
      <br>
      <form method="POST" action="" accept-charset="UTF-8" enctype="multipart/form-data">
        {{csrf_field()}}
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">Edit a video from {{$season->title_long}}</h3>
          </div>
          <div class="box-body row"> 

            <div class="form-group col-md-6">
                <label>Quality</label>
                @php $selected = Input::old('quality',$video->quality); @endphp
                <select name="quality" class="form-control select2">
                    <option value="1080p" @if($selected == "1080p") selected @endif>1080p</option>
                    <option value="720p" @if($selected == "720p") selected @endif>720p</option>
                    <option value="3D" @if($selected == "3D") selected @endif>3D</option>
                </select>
            </div>          

            <div class="form-group col-md-6">
              <label>Source</label>
              <input type="text" name="source" placeholder="Mirror 1" class="form-control" value="{{Input::old('source',$video->source)}}">
            </div>

            <div class="form-group col-md-12">
              <label>Video Link</label>
              <input type="text" name="video_link" class="form-control" placeholder="http://mysite.com/video.mp4" value="{{Input::old('video_link',$video->video_link)}}">
            </div>
         

          </div>
          <!-- /.box-body -->
          <div class="box-footer">
            <div id="saveActions" class="form-group">
                <button type="submit" class="btn btn-success" onclick=""> Save </button>
                <a href="{{url('admin/series/'.$series->id.'/seasons/'.$season->id.'/video')}}" class="btn btn-default"><span class="fa fa-ban"></span> &nbsp;Cancel</a> 
            </div>
          </div>
          <!-- /.box-footer--> 
        </div>
        <!-- /.box -->
      </form>
    </div>
  </div>
</section>
<!-- /.content --> 
@stop

@section('after_scripts')
<script type="text/javascript">
window.onbeforeunload = renderLoading;
function renderLoading()
{
    Pace.stop()
    Pace.bar.render();
}  
</script>
@stop