@extends('backpack::layout')
@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>
  <span class="text-capitalize">videos</span>
  <small>All  <span>videos</span> in {{$season->title_long}}.</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="{{url('admin/dashboard')}}">Admin</a></li>
    <li><a href="{{url('admin/series')}}" class="text-capitalize">series</a></li>
    <li><a href="{{url('admin/series/'.$series->id.'/seasons')}}" class="text-capitalize">seasons</a></li>
    <li><a href="#" class="text-capitalize">{{$season->title_long}}</a></li>
    <li class="active">Videos</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
  <!-- Default box -->
  <div class="row">
    <!-- THE ACTUAL CONTENT -->
    <div class="col-md-12">
      <div class="box">
        <div class="box-header with-border">
          <a href="{{url('admin/series/'.$series->id.'/seasons/'.$season->id.'/video/create')}}" class="btn btn-primary ladda-button" data-style="zoom-in"><span class="ladda-label"><i class="fa fa-plus"></i> Add Video</span></a>
          
          <div id="datatable_button_stack" class="pull-right text-right"></div>
        </div>
        <div class="box-body table-responsive">
          
          
          <table id="crudTable" class="table table-bordered table-striped display">
            <thead>
              <tr>                            
                <th>Quality</th>
                <th>Source</th>
                <th>Video Link</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              @forelse($videos as $video)
              <tr>                            
                <td>{{$video->quality}}</td>
                <td>{{$video->source}}</td>
                <td>{{$video->video_link}}</td>
                <td>  <a href="{{url('admin/series/'.$series->id.'/seasons/'.$season->id.'/video/'.$video->id.'/edit')}}" class="btn btn-xs btn-default"><i class="fa fa-edit"></i> Edit</a> <a href="{{url('admin/series/'.$series->id.'/seasons/'.$season->id.'/video/'.$video->id.'/delete')}}" class="btn btn-xs btn-default"><i class="fa fa-trash"></i> Delete</a> </td>
              </tr>    
              @empty
                <tr>
                  <td colspan="7" align="center">No videos available.</td>
                </tr> 
              @endforelse
            </tbody>            
            <tfoot>
              <tr>                            
                <th>Quality</th>
                <th>Source</th>
                <th>Video Link</th>
                <th>Actions</th>
              </tr>
            </tfoot>
          </table>
          </div><!-- /.box-body -->
          
          </div><!-- /.box -->
        </div>
      </div>
    </section>
    <!-- /.content -->
@stop