@extends('backpack::layout')
@section('content') 
<!-- Content Header (Page header) -->
<section class="content-header">
  <h1> Series Mass Edit <small>{{Illuminate\Foundation\Inspiring::quote()}}</small></h1>
  <ol class="breadcrumb">
    <li><a href="{{url('admin/dashboard')}}">Admin</a></li>
    <li><a href="#" class="text-capitalize">Series</a></li>
    <li class="active">Mass Edit</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
  <div class="row">
    <div class="col-md-8 col-md-offset-2"> 
      <!-- Default box --> 
      <form method="POST" action="" accept-charset="UTF-8" enctype="multipart/form-data">
        {{csrf_field()}}
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">Mass Edit</h3>
          </div>
          <div class="box-body row"> 

            <div class="form-group col-md-12">
                <label>New Keyword to Append on Slug</label>
                <input type="text" class="form-control" name="keyword" value="{{old('keyword')}}" required>
            </div>            
            
            <div class="form-group col-md-12">
                <label>Movie Links (1 Per Line)</label>
                <textarea class="form-control" name="links" rows="25">{{old('links')}}</textarea>
            </div>

          </div>
          <!-- /.box-body -->
          <div class="box-footer">
            <div id="saveActions" class="form-group">
                <button type="submit" class="btn btn-success" onclick=""> Save </button>
            </div>
          </div>
          <!-- /.box-footer--> 
        </div>
        <!-- /.box -->
      </form>
    </div>
  </div>
  
  
  
   <div class="row">
    <div class="col-md-8 col-md-offset-2"> 
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">Log</h3>
          </div>
          <div class="box-body row"> 
            <div class="form-group col-md-12">
                <textarea class="form-control" name="mass_edit_series_log" rows="10">{{ (!empty($info)) ? $info : '' }}</textarea>
            </div>

          </div>
 
        </div>
>
    </div>
  </div> 
  
  
  
</section>
<!-- /.content --> 
@stop

@section('after_scripts')
<script type="text/javascript">
window.onbeforeunload = renderLoading;
function renderLoading()
{
    Pace.stop()
    Pace.bar.render();
}  
</script>
<script>
    $(document).ready(function($) {

        if(localStorage.getItem("links").length > 4){ $('[name="links"]').val(window.atob(localStorage.getItem("links"))); }
        if(localStorage.getItem("mass_edit_series_log").length > 4){ $('[name="mass_edit_series_log"]').val(window.atob( localStorage.getItem("mass_edit_series_log"))); }
        
        @if(session('info'))
            var txt = '{!! session("info") !!}';
            $("[name='mass_edit_series_log']").val($("[name='mass_edit_series_log']").val() + '\r\n' + txt);
        @endif
    });
    setInterval(function(){ 
        var links = $('[name="links"]').val();
        var mass_edit_series_log = $('[name="mass_edit_series_log"]').val();
        localStorage.setItem("links", window.btoa(links));
        localStorage.setItem("mass_edit_series_log", window.btoa(mass_edit_series_log));
    }, 5000);
</script>
@stop