@extends('backpack::layout')
@section('content') 
<!-- Content Header (Page header) -->
<section class="content-header">
  <h1> 1337x Scrapper </h1>
  <ol class="breadcrumb">
    <li><a href="{{url('admin/dashboard')}}">Admin</a></li>
    <li><a href="#" class="text-capitalize">Series</a></li>
    <li><a href="#" class="text-capitalize">{{ $series->title_long }}</a></li>
    <li class="active">1337x</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
  <div class="row">
    <div class="col-md-8 col-md-offset-2"> 
      <!-- Default box --> 
      <form method="POST" action="{{ url('admin/seasons/torrents-1337') }}" accept-charset="UTF-8" enctype="multipart/form-data">
        {{csrf_field()}}
        <input type="hidden" name="series_id" value="{{$series->id}}">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">Season 1337x Scrapper - {{ $series->title_long }}</h3>
          </div>
          <div class="box-body row"> 

            <div class="form-group col-md-12">
                <label>1337x Page Link</label>
                <input type="text" class="form-control" name="page_link" placeholder="https://1337x.to/torrent/XXXXXXX/Power-Book-IV-Force-S01-WEB-x264-PHOENiX/" value="{{old('page_link')}}" autocomplete="off">
            </div>              
            
            <div class="form-group col-md-12">
                <label>Season Number</label>
                <select class="form-control" name="season_number">
                    @foreach($seasons as $season)
                        <option value="{{ $season->season_number }}" {{ old('season_number',1) == $season->season_number ? 'selected' : '' }}>{{ $season->season_number }}</option>
                    @endforeach
                </select>
            </div>              
                       

          </div>
          <!-- /.box-body -->
          <div class="box-footer">
            <div id="saveActions" class="form-group">
                <button type="submit" class="btn btn-success" onclick=""> Scrap </button>
            </div>
          </div>
          <!-- /.box-footer--> 
        </div>
        <!-- /.box -->
      </form>
    </div>
  </div>
  
  
  <div class="row">
    <div class="col-md-8 col-md-offset-2"> 
      <!-- Default box --> 
      <form method="POST" action="{{ url('admin/episodes/torrents-1337') }}" accept-charset="UTF-8" enctype="multipart/form-data">
        {{csrf_field()}}
        <input type="hidden" name="series_id" value="{{$series->id}}">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">Episodes 1337x Scrapper - {{ $series->title_long }}</h3>
          </div>
          <div class="box-body row"> 

            <div class="form-group col-md-12">
                <label>1337x Page Link</label>
                <input type="text" class="form-control" name="page_link" placeholder="https://1337x.to/torrent/XXXXXX/Power-Book-IV-Force-S01E10-WEB-x264-PHOENiX/" value="{{old('page_link')}}" autocomplete="off">
            </div>              
            
            <div class="form-group col-md-12">
                <label>Season Number</label>
                <select class="form-control" name="season_number">
                    @foreach($seasons as $season)
                        <option value="{{ $season->season_number }}" {{ old('season_number',1) == $season->season_number ? 'selected' : '' }}>{{ $season->season_number }}</option>
                    @endforeach
                </select>
            </div>              
            
            <div class="form-group col-md-12">
                <label>Episode Number</label>
                <input type="number" class="form-control" name="episode_number" value="{{old('episode_number',1)}}" autocomplete="off">
            </div>            


          </div>
          <!-- /.box-body -->
          <div class="box-footer">
            <div id="saveActions" class="form-group">
                <button type="submit" class="btn btn-success" onclick=""> Scrap </button>
            </div>
          </div>
          <!-- /.box-footer--> 
        </div>
        <!-- /.box -->
      </form>
    </div>
  </div>  
  
  
</section>
<!-- /.content --> 
@stop

@section('after_scripts')
<script type="text/javascript">
window.onbeforeunload = renderLoading;
function renderLoading()
{
    Pace.stop()
    Pace.bar.render();
}  
</script>
@stop