@extends('front.layouts.default')


@section('meta')
	<meta http-equiv="content-language" itemprop="inLanguage" content="en">
	<link rel="alternate" href="{{url()->current()}}" hreflang="en" />
	<meta name="revisit-after" content="1 days">
	<meta name="robots" content="INDEX,FOLLOW">

    <meta name="description" content="{{$article->title}}" />
    <meta name="keywords" content="{{$article->tags_f}}" />
    <meta property="og:title" content="{{$article->title}}" />
    <meta property="og:image" content="{{$article->image_f}}" />
    <meta property="og:description" content="{{$article->title}}" />
    <meta property="og:url" content="{{url()->current()}}" />

	<meta name="twitter:card" content="summary_large_image">
	<meta name="twitter:url" value="{{url()->current()}}">
	<meta name="twitter:title" content="{{$article->title}}">
	<meta name="twitter:description" content="{{$article->title}}">
	<meta name="twitter:image" content="{{$article->image_f}}" />    
@stop

@section('content')
<div class="container" id="info-page">
	<div class="row">
		<div class="col-xs-20">
			<h2>{{$article->title}}</h2>
		</div>
	</div>
	<div class="row blog blog-text">
		<div class="col-xs-20">
			{!!$article->content!!}
		</div>
	</div>
	<div class="row blog">
		<div class="col-xs-20">
			<a href="{{url('user/admin')}}">Author - admin</a>
		</div>
	</div>
	<div class="row blog">
		<div class="col-xs-20">
			<span class="hidden-xs blog-date">{{$article->created_at->format('F d, Y \a\t h:i A')}}</span><br/>
		</div>		
		<div class="col-xs-20">
			<span class="hidden-xs blog-date">Tags - {!! $article->tags_f !!}</span>
		</div>
	</div>	
	@if(config('settings.disqus') == 1)
	<br/>
	<div class="row blog">
		<div class="col-xs-20">
			{!!config('settings.disqus_code')!!}
		</div>
	</div>
	@endif

@if(config('settings.facebook_comments') == 1)	
	<div class="row blog" style="margin-top: 20px;">
		<div class="col-xs-20">
			<div class="fb-comments" data-href="{{url('blog/'.$article->slug)}}" data-width="100%" data-numposts="10" data-colorscheme="{{config('settings.facebook_comments_colorscheme')}}"></div>
		</div>
	</div>
@endif


</div>
@stop