@extends('front.layouts.default')

@section('meta')
    @include('front.inc.default_meta')
@stop

@section('content')
<div id="info-page">
  <div class="container">
    <div class="row">
      <div class="col-xs-20">
        <h2 class="green-title">Recent blog posts</h2>
      </div>
    </div>
    <div class="row">
      <div class="col-xs-20">
        <div class="line"></div>
      </div>
    </div>

    @forelse($articles as $article)
    <div class="row blog">
      <div class="col-xs-2 hidden-sm hidden-xs">
        <img src="{{$article->image_f}}" style="max-width:150px;max-height: 150px;">
      </div>
      <div class="col-xs-18">        
        <h3><a href="{{url('blog/'.$article->slug)}}">{{$article->title}}</a></h3>
        <p> {{str_limit(strip_tags($article->content),150,'...')}} </p>
        <div class="container">
          <div class="row"> <span class="hidden-xs blog-date">{{$article->created_at->format('F d, Y \a\t h:i A')}}</span> </div>
          <div class="row"> <a href="{{url('user/admin')}}">Author - admin</a> </div>
          <div class="row"> <a href="{{url('blog/'.$article->slug)}}">Read More</a> </div>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-xs-20">
        <div class="line"></div>
      </div>
    </div>
    @empty
      <div class="row blog">
        <div class="col-xs-20">
          <h3 style="text-align: center;">No results</h3>
        </div>
      </div>
    @endforelse

   

    <div class="row center-important">
      <div class="col-xs-20">
        {{ $articles->links('vendor.pagination.front') }}
      </div>
    </div>

    
  </div>
</div>
@stop