@extends('front.layouts.default')

@section('meta')
   @include('front.inc.default_meta')
@stop

@section('after_styles')
<link rel="stylesheet" href="{{ url('css/pages/home.min.css') }}">
<style type="text/css">
.ibox-bordered {
    border: 5px solid {{config('settings.theme_pattern_color')}};
}
</style>
@stop

@section('background_image')
@if($popular_movies->count() > 0)
    @if(!empty($popular_movies->random()->background_image))
<div id="background-image" style="background: url({{$popular_movies->random()->background}}) no-repeat center center; background-size: cover; -webkit-background-size: cover;-moz-background-size: cover; -o-background-size: cover;"></div>
<div id="background-overlay"></div>
    @endif
@endif 
@stop


@section('content')

        <div class="container home-content">
            <div class="hidden-xs hidden-sm">
               {!! config('settings.home_page_block1')!!}
            </div>
            <div id="popular-downloads">
                
                @foreach($genre_movies as $featured_genre => $featured_genre_movies)
                <div class="row">
                    <h2><span class="icon-star"></span>{{ $featured_genre }} YIFY Movie Torrents</h2>
                </div>
                <div class="row">
                    @forelse($featured_genre_movies as $movie)
                    <div class="browse-movie-wrap col-xs-10 col-sm-5">
                        <a href="{{ $movie->url }}" class="browse-movie-link">
                            <figure>
                                <img class="img-responsive lazyload" src="{{ url('img/default_thumbnail.svg') }}" data-src="{{$movie->thumbnail}}" alt="{{$movie->title_long}} YIFY Torrent" width="210" height="315" />
                                <figcaption class="hidden-xs hidden-sm">
                                <span class="icon-star"></span>
                                <h4 class="rating">{{$movie->rating}} / 10</h4>
                                {!! $movie->thumbnail_genres !!}
                                <span class="button-green-download2-big">View Details</span>
                                </figcaption>
                            </figure>
                        </a>
                        <div class="browse-movie-bottom">
                            <a href="{{ $movie->url }}" class="browse-movie-title">{{$movie->title}}</a>
                            <div class="browse-movie-year">{{$movie->year}}</div>
                        </div>
                    </div>
                    @empty
                        <h1>No results</h1>
                    @endforelse

                </div> 
                @endforeach                

                @foreach($genre_series as $featured_genre => $featured_genre_series)
                <div class="row">
                    <h2><span class="icon-star"></span>{{ $featured_genre }} YIFY Series Torrents</h2>
                </div>
                <div class="row">
                    @forelse($featured_genre_series as $fseries)
                    <div class="browse-movie-wrap col-xs-10 col-sm-5">
                        <a href="{{ $fseries->url }}" class="browse-movie-link">
                            <figure>
                                <img class="img-responsive lazyload" src="{{ url('img/default_thumbnail.svg') }}" data-src="{{$fseries->thumbnail}}" alt="{{$fseries->title_long}} YIFY Torrent" width="210" height="315" />
                                <figcaption class="hidden-xs hidden-sm">
                                <span class="icon-star"></span>
                                <h4 class="rating">{{$fseries->rating}} / 10</h4>
                                {!! $fseries->thumbnail_genres !!}
                                <span class="button-green-download2-big">View Details</span>
                                </figcaption>
                            </figure>
                        </a>
                        <div class="browse-movie-bottom">
                            <a href="{{ $fseries->url }}" class="browse-movie-title">{{$fseries->title}}</a>
                            <div class="browse-movie-year">{{$fseries->year}}</div>
                        </div>
                    </div>
                    @empty
                        <h1>No results</h1>
                    @endforelse

                </div> 
                @endforeach
                
                
                
                <div class="row">
                    <h2><span class="icon-star"></span>Popular YIFY Movie Torrents</h2>
                </div>
                <div class="row">
                    @forelse($popular_movies as $movie)
                    <div class="browse-movie-wrap col-xs-10 col-sm-5">
                        <a href="{{ $movie->url }}" class="browse-movie-link">
                            <figure>
                                <img class="img-responsive lazyload" src="{{ url('img/default_thumbnail.svg') }}" data-src="{{$movie->thumbnail}}" alt="{{$movie->title_long}} YIFY Torrent" width="210" height="315" />
                                <figcaption class="hidden-xs hidden-sm">
                                <span class="icon-star"></span>
                                <h4 class="rating">{{$movie->rating}} / 10</h4>
                                {!! $movie->thumbnail_genres !!}
                                <span class="button-green-download2-big">View Details</span>
                                </figcaption>
                            </figure>
                        </a>
                        <div class="browse-movie-bottom">
                            <a href="{{ $movie->url }}" class="browse-movie-title">{{$movie->title}}</a>
                            <div class="browse-movie-year">{{$movie->year}}</div>
                        </div>
                    </div>
                    @empty
                        <h1>No results</h1>
                    @endforelse

                </div>                
                <div class="row">
                    <h2><span class="icon-star"></span>Popular YIFY Series Torrents</h2>
                </div>
                <div class="row">
                    @forelse($popular_series as $pseries)
                    <div class="browse-movie-wrap col-xs-10 col-sm-5">
                        <a href="{{ $pseries->url }}" class="browse-movie-link">
                            <figure>
                                <img class="img-responsive lazyload" src="{{ url('img/default_thumbnail.svg') }}" data-src="{{$pseries->thumbnail}}" alt="{{$pseries->title_long}} YIFY Torrent" width="210" height="315" />
                                <figcaption class="hidden-xs hidden-sm">
                                <span class="icon-star"></span>
                                <h4 class="rating">{{$pseries->rating}} / 10</h4>
                                {!! $pseries->thumbnail_genres !!}
                                <span class="button-green-download2-big">View Details</span>
                                </figcaption>
                            </figure>
                        </a>
                        <div class="browse-movie-bottom">
                            <a href="{{ $pseries->url }}" class="browse-movie-title">{{$pseries->title}}</a>
                            <div class="browse-movie-year">{{$pseries->year}}</div>
                        </div>
                    </div>
                    @empty
                        <h1>No results</h1>
                    @endforelse

                </div>
                
                
                
            </div>
                 

            @if(config('settings.advertisement') == 1)
                
                @if(!empty(config('settings.advertisement_block_1')))                    
                    {!!config('settings.advertisement_block_1')!!}
                @else
                
                @endif
                
            @endif

        </div>
        <div class="content-dark">
            <div class="container home-content">
                <div class="home-movies">



                    <div class="row">
                        <h2>Latest {{config('settings.site_title')}} Movies Torrents Magnets <a href="{{route('movie.index')}}">Browse All</a></h2>
                    </div>
                    <div class="row">
                        @forelse($movies as $movie)
                        <div class="browse-movie-wrap col-xs-10 col-sm-5">
                            <a href="{{ $movie->url }}" class="browse-movie-link">
                                <figure>
                                    <img class="img-responsive lazyload" src="{{ url('img/default_thumbnail.svg') }}" data-src="{{$movie->thumbnail}}" alt="{{$movie->title_long}} yify torrent" style="width: 210px;" />
                                    @if(!empty($movie->latest_torrent) && !empty($movie->latest_torrent->banner))
                                    <img class="quality-banner img-responsive" src="{{ $movie->latest_torrent->banner }}" alt="{{$movie->title_long}}" width="118" height="91">
                                    @endif
                                    <figcaption class="hidden-xs hidden-sm">
                                    <span class="icon-star"></span>
                                    <h4 class="rating">{{$movie->rating}} / 10</h4>

                                    {!! $movie->thumbnail_genres !!}

                                    <span class="button-green-download2-big">View Details</span>
                                    </figcaption>
                                </figure>
                            </a>
                            <div class="browse-movie-bottom">
                                <a href="{{ $movie->url }}" class="browse-movie-title">{{$movie->title}}</a>
                                <div class="browse-movie-year">{{$movie->year}}</div>
                            </div>
                        </div>
                        @empty
                            No results
                        @endforelse

                    </div>                    

                    <div class="row">
                        <h2>Latest {{config('settings.site_title')}} Series Torrents Magnets <a href="{{route('series.index')}}">Browse All</a></h2>
                    </div>

                    <div class="row">
                        @forelse($series as $s)
                    
                        <div class="browse-movie-wrap col-xs-10 col-sm-5">
                            <a href="{{ $s->url }}" class="browse-movie-link">
                                <figure>
                                    <img class="img-responsive lazyload" src="{{ url('img/default_thumbnail.svg') }}" data-src="{{$s->thumbnail}}" alt="{{$s->title_long}} yify torrent" style="width: 210px;" />
                                    @if(!empty($s->latest_torrent) && !empty($s->latest_torrent->banner))
                                    <img class="quality-banner img-responsive" src="{{ $s->latest_torrent->banner }}" alt="{{$s->title_long}}" width="118" height="91">
                                    @endif
                                    <figcaption class="hidden-xs hidden-sm">
                                    <span class="icon-star"></span>
                                    <h4 class="rating">{{$s->rating}} / 10</h4>

                                    {!! $s->thumbnail_genres !!}

                                    <span class="button-green-download2-big">View Details</span>
                                    </figcaption>
                                </figure>
                            </a>
                            <div class="browse-movie-bottom">
                                <a href="{{ $s->url }}" class="browse-movie-title">{{$s->title}}</a>
                                <div class="browse-movie-year">{{$s->year}}</div>
                            </div>
                        </div>
                        @empty
                            No results
                        @endforelse

                    </div>





                </div>               

            </div>
        </div>
@stop