@php
   if(Route::currentRouteName() == 'home'){
        $title = config('settings.site_title');
        if(isset($page_title)) $title .= ' - '.$page_title;
   } 
   else{
        $title = '';
        if(isset($page_title)) $title .= $page_title.' - ';
        $title .= config('settings.site_title');
   }
@endphp


<meta http-equiv="content-language" itemprop="inLanguage" content="en">
<meta charset="utf-8">
<meta property="og:locale" content="en_US"/>
<meta property="og:type" content="article"/>
<link rel="profile" href="https://gmpg.org/xfn/11"/>
<link rel="pingback" href=""/>
<link rel="canonical" href="{{url()->current()}}"/>
<link rel="alternate" href="{{url()->current()}}" hreflang="en" />
<meta name="revisit-after" content="1 days">
<meta name="robots" content="INDEX,FOLLOW">

<meta name="description" content="{{config('settings.meta_description')}}" />
<meta name="keywords" content="{{config('settings.meta_keywords')}}" />
<meta property="og:title" content="{{ $title }}" />
@if(!empty(config('settings.site_logo')))<meta property="og:image" content="{{ url(config('settings.site_logo')) }}" />@endif
<meta property="og:description" content="{{config('settings.meta_description')}}" />
<meta property="og:url" content="{{url()->current()}}" />


<meta property="og:title" content="{{ $title }}" />
@if(!empty(config('settings.site_logo')))<meta property="og:image" content="{{ url(config('settings.site_logo')) }}" />@endif
<meta property="og:description" content="{{config('settings.meta_description')}}" />
<meta property="og:url" content="{{url()->current()}}" />

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:url" value="{{url()->current()}}">
<meta name="twitter:title" content="{{ $title }}">
<meta name="twitter:description" content="{{config('settings.meta_description')}}">
@if(!empty(config('settings.site_logo')))<meta name="twitter:image" content="{{ url(config('settings.site_logo')) }}" />@endif