@extends('front.layouts.default')

@section('meta')
	@include('front.inc.default_meta')
@stop

@section('after_styles')
<style type="text/css">	
@media (min-width: 768px)
{
	.poster {
	    height: 255px;
	}
}
</style>
@stop

@section('content')
<div id="main-search" class="content-dark hidden-sm hidden-xs">
	<div class="container">
		<form method="get" action="{{ route('movie.index') }}" accept-charset="UTF-8">
			<div id="main-search-fields" style="width: 880px;">
				<p class="pull-left term">Search Term:</p>
				<input name="keyword" placeholder="Search for a movie&hellip;" autocomplete="off" type="search" value="{{app('request')->input('keyword')}}">
				<div class="selects-container">
					<p>Quality:</p>
					<select name="quality">
					@php
						$selected = app('request')->input('quality'); 
					@endphp						
						<option value="" @if($selected == '') selected @endif>All</option>
						<option value="720p" @if($selected == '720p') selected @endif>720p</option>
						<option value="1080p" @if($selected == '1080p') selected @endif>1080p</option>
						<option value="2160p" @if($selected == '2160p') selected @endif>2160p</option>
						<option value="3D" @if($selected == '3D') selected @endif>3D</option>
					</select>
				</div>
				<div class="selects-container">
					<p>Genre:</p>
					<select name="genre">
						<option value="">All</option>
						@php
							$selected = app('request')->input('genre'); 
						@endphp							
						@foreach($movie_genres as $genre)
						<option value="{{$genre->name}}" @if($selected == $genre->name) selected @endif>{{$genre->name}}</option>
						@endforeach
					</select>
				</div>
				<div class="selects-container">
					<p>Rating:</p>
					<select name="rating">
						<option value="0">All</option>
						@php
							$selected = app('request')->input('rating'); 
						@endphp
						@for($i = 9; $i > 0 ; $i--)
						<option value="{{$i}}" @if($selected == $i) selected @endif>{{$i}}+</option>
						@endfor

					</select>
				</div>				
				<div class="selects-container">
					<p>Year:</p>
					<select name="year">
						@php $selected = request()->input('year') @endphp
						<option value="0">All</option>
						@for($i = date('Y'); $i >= 2019; $i--)
						<option value="{{ $i }}" {{ $selected == $i ? 'selected' : '' }}>{{ $i }}</option>
						@endfor
						<option value="2015-2018" {{ $selected == '2015-2018' ? 'selected' : '' }}>2015-2018</option>
						<option value="2010-2014" {{ $selected == '2010-2014' ? 'selected' : '' }}>2010-2014</option>
						<option value="2000-2009" {{ $selected == '2000-2009' ? 'selected' : '' }}>2000-2009</option>
						<option value="1990-1999" {{ $selected == '1990-1999' ? 'selected' : '' }}>1990-1999</option>
						<option value="1980-1989" {{ $selected == '1980-1989' ? 'selected' : '' }}>1980-1989</option>
						<option value="1970-1979" {{ $selected == '1970-1979' ? 'selected' : '' }}>1970-1979</option>
						<option value="1900-1969" {{ $selected == '1900-1969' ? 'selected' : '' }}>1900-1969</option>
					</select>
				</div>
				<div class="selects-container">
				<p>Language:</p>
				<select name="language">
					@php $selected = request()->input('language') @endphp
				<option value="">All</option>
				<option value="en" {{ $selected == 'en' ? 'selected' : '' }}>English</option>
				<option value="ja" {{ $selected == 'ja' ? 'selected' : '' }}>Japanese</option>
				<option value="fr" {{ $selected == 'fr' ? 'selected' : '' }}>French</option>
				<option value="it" {{ $selected == 'it' ? 'selected' : '' }}>Italian</option>
				<option value="de" {{ $selected == 'de' ? 'selected' : '' }}>German</option>
				<option value="es" {{ $selected == 'es' ? 'selected' : '' }}>Spanish</option>
				<option value="zh" {{ $selected == 'zh' ? 'selected' : '' }}>Chinese</option>
				<option value="hi" {{ $selected == 'hi' ? 'selected' : '' }}>Hindi</option>
				<option value="cn" {{ $selected == 'cn' ? 'selected' : '' }}>Cantonese</option>
				<option value="ko" {{ $selected == 'ko' ? 'selected' : '' }}>Korean</option>
				<option value="ru" {{ $selected == 'ru' ? 'selected' : '' }}>Russian</option>
				<option value="sv" {{ $selected == 'sv' ? 'selected' : '' }}>Swedish</option>
				<option value="pt" {{ $selected == 'pt' ? 'selected' : '' }}>Portuguese</option>
				<option value="pl" {{ $selected == 'pl' ? 'selected' : '' }}>Polish</option>
				<option value="da" {{ $selected == 'da' ? 'selected' : '' }}>Danish</option>
				<option value="no" {{ $selected == 'no' ? 'selected' : '' }}>Norwegian</option>
				<option value="te" {{ $selected == 'te' ? 'selected' : '' }}>Telugu</option>
				<option value="th" {{ $selected == 'th' ? 'selected' : '' }}>Thai</option>
				<option value="nl" {{ $selected == 'nl' ? 'selected' : '' }}>Dutch</option>
				<option value="fi" {{ $selected == 'fi' ? 'selected' : '' }}>Finnish</option>
				<option value="cs" {{ $selected == 'cs' ? 'selected' : '' }}>Czech</option>
				<option value="ta" {{ $selected == 'ta' ? 'selected' : '' }}>Tamil</option>
				<option value="vi" {{ $selected == 'vi' ? 'selected' : '' }}>Vietnamese</option>
				<option value="tr" {{ $selected == 'tr' ? 'selected' : '' }}>Turkish</option>
				<option value="id" {{ $selected == 'id' ? 'selected' : '' }}>Indonesian</option>
				<option value="fa" {{ $selected == 'fa' ? 'selected' : '' }}>Persian</option>
				<option value="el" {{ $selected == 'el' ? 'selected' : '' }}>Greek</option>
				<option value="ar" {{ $selected == 'ar' ? 'selected' : '' }}>Arabic</option>
				<option value="he" {{ $selected == 'he' ? 'selected' : '' }}>Hebrew</option>
				<option value="ur" {{ $selected == 'ur' ? 'selected' : '' }}>Urdu</option>
				<option value="tl" {{ $selected == 'tl' ? 'selected' : '' }}>Tagalog</option>
				<option value="hu" {{ $selected == 'hu' ? 'selected' : '' }}>Hungarian</option>
				<option value="ms" {{ $selected == 'ms' ? 'selected' : '' }}>Malay</option>
				<option value="bn" {{ $selected == 'bn' ? 'selected' : '' }}>Bangla</option>
				<option value="is" {{ $selected == 'is' ? 'selected' : '' }}>Icelandic</option>
				<option value="ro" {{ $selected == 'ro' ? 'selected' : '' }}>Romanian</option>
				<option value="ca" {{ $selected == 'ca' ? 'selected' : '' }}>Catalan</option>
				<option value="ml" {{ $selected == 'ml' ? 'selected' : '' }}>Malayalam</option>
				<option value="et" {{ $selected == 'et' ? 'selected' : '' }}>Estonian</option>
				<option value="uk" {{ $selected == 'uk' ? 'selected' : '' }}>Ukrainian</option>
				<option value="pa" {{ $selected == 'pa' ? 'selected' : '' }}>Punjabi</option>
				<option value="xx" {{ $selected == 'xx' ? 'selected' : '' }}>xx</option>
				<option value="sr" {{ $selected == 'sr' ? 'selected' : '' }}>Serbian</option>
				<option value="af" {{ $selected == 'af' ? 'selected' : '' }}>Afrikaans</option>
				<option value="kn" {{ $selected == 'kn' ? 'selected' : '' }}>Kannada</option>
				<option value="eu" {{ $selected == 'eu' ? 'selected' : '' }}>Basque</option>
				<option value="sk" {{ $selected == 'sk' ? 'selected' : '' }}>Slovak</option>
				<option value="bo" {{ $selected == 'bo' ? 'selected' : '' }}>Tibetan</option>
				<option value="am" {{ $selected == 'am' ? 'selected' : '' }}>Amharic</option>
				<option value="gl" {{ $selected == 'gl' ? 'selected' : '' }}>Galician</option>
				<option value="bs" {{ $selected == 'bs' ? 'selected' : '' }}>Bosnian</option>
				<option value="la" {{ $selected == 'la' ? 'selected' : '' }}>Latin</option>
				<option value="mn" {{ $selected == 'mn' ? 'selected' : '' }}>Mongolian</option>
				<option value="mr" {{ $selected == 'mr' ? 'selected' : '' }}>Marathi</option>
				<option value="nb" {{ $selected == 'nb' ? 'selected' : '' }}>Norwegian Bokmål</option>
				<option value="lv" {{ $selected == 'lv' ? 'selected' : '' }}>Latvian</option>
				<option value="ps" {{ $selected == 'ps' ? 'selected' : '' }}>Pashto</option>
				<option value="st" {{ $selected == 'st' ? 'selected' : '' }}>Southern Sotho</option>
				<option value="iu" {{ $selected == 'iu' ? 'selected' : '' }}>Inuktitut</option>
				<option value="so" {{ $selected == 'so' ? 'selected' : '' }}>Somali</option>
				<option value="wo" {{ $selected == 'wo' ? 'selected' : '' }}>Wolof</option>
				<option value="az" {{ $selected == 'az' ? 'selected' : '' }}>Azerbaijani</option>
				<option value="sw" {{ $selected == 'sw' ? 'selected' : '' }}>Swahili</option>
				<option value="ab" {{ $selected == 'ab' ? 'selected' : '' }}>Abkhazian</option>
				<option value="ht" {{ $selected == 'ht' ? 'selected' : '' }}>Haitian Creole</option>
				<option value="sh" {{ $selected == 'sh' ? 'selected' : '' }}>Serbo-Croatian</option>
				<option value="ky" {{ $selected == 'ky' ? 'selected' : '' }}>Kyrgyz</option>
				<option value="ak" {{ $selected == 'ak' ? 'selected' : '' }}>Akan</option>
				<option value="os" {{ $selected == 'os' ? 'selected' : '' }}>Ossetic</option>
				<option value="lb" {{ $selected == 'lb' ? 'selected' : '' }}>Luxembourgish</option>
				<option value="ka" {{ $selected == 'ka' ? 'selected' : '' }}>Georgian</option>
				<option value="mi" {{ $selected == 'mi' ? 'selected' : '' }}>Maori</option>
				<option value="aa" {{ $selected == 'aa' ? 'selected' : '' }}>Afar</option>
				<option value="ga" {{ $selected == 'ga' ? 'selected' : '' }}>Irish</option>
				<option value="yi" {{ $selected == 'yi' ? 'selected' : '' }}>Yiddish</option>
				<option value="km" {{ $selected == 'km' ? 'selected' : '' }}>Khmer</option>
				<option value="mk" {{ $selected == 'mk' ? 'selected' : '' }}>Macedonian</option>
				</select>
				</div>				
				<div class="selects-container selects-container-last">
					<p>Order By:</p>
					<select name="order_by">
						@php
							$selected = app('request')->input('order_by'); 
						@endphp						
						<option value="latest" @if($selected == 'latest') selected @endif>Latest</option>
						<option value="oldest" @if($selected == 'oldest') selected @endif>Oldest</option>
						<option value="year" @if($selected == 'year') selected @endif>Year</option>
						<option value="rating" @if($selected == 'rating') selected @endif>Rating</option>
						<option value="alphabetical" @if($selected == 'alphabetical') selected @endif>Alphabetical</option>
						<option value="downloads" @if($selected == 'downloads') selected @endif>Downloads</option>
					</select>
				</div>
			</div>
			<div id="main-search-btn">
				<input class="button-green-download2-big" type="submit" value="Search">
			</div>
		</form>
	</div>
</div>
<div class="browse-content">
	<div class="container">
		<h2>{{number_format($movies_count)}} {{config('settings.site_title')}} Movies Found</h2>
		<div>
			{{ $movies->appends(Input::except('page'))->links('vendor.pagination.front') }}
		</div>
		<section>
			<div class="row">
				@forelse($movies as $movie)			
				<div class="browse-movie-wrap col-xs-10 col-sm-4 col-md-5 col-lg-4">
					<a href="{{ $movie->url }}" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="{{ url('img/default_thumbnail.svg') }}" data-src="{{ $movie->thumbnail }}" alt="{{$movie->title_long}} YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">{{$movie->rating}} / 10</h4>
                             {!! $movie->thumbnail_genres !!}
							<span class="button-green-download2-big">View Details</span>
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="{{ $movie->url }}" class="browse-movie-title">{{$movie->title}}</a>
						<div class="browse-movie-year">{{$movie->year}}</div>						
					</div>
				</div>
				@empty
				<h1 class="text-center">No results</h1>
				<br/><br/><br/><br/><br/><br/><br/><br/><br/><br/><br/>	
				@endforelse				
			</div><br/><br/><br/><br/>
		</section>
		<div>
			{{ $movies->appends(Input::except('page'))->links('vendor.pagination.front') }}
		</div>
	</div>
</div>
@stop