@extends('front.layouts.default')

@section('meta')
	@include('front.inc.default_meta')
@stop

@section('after_styles')
<style type="text/css">	
@media (min-width: 768px)
{
	.poster {
	    height: 255px;
	}
}
</style>
@stop

@section('content')
<div class="browse-content">
	<div class="container">
		<h2>{{ $page_title }}</h2>
		<div>
			{{ $movies->appends(Input::except('page'))->links('vendor.pagination.front') }}
		</div>
		<section>
			<div class="row">
				@forelse($movies as $movie)
				<div class="browse-movie-wrap col-xs-10 col-sm-4 col-md-5 col-lg-4">
					<a href="{{ $movie->url }}" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="{{ url('img/default_thumbnail.svg') }}" data-src="{{ $movie->thumbnail }}" alt="{{$movie->title_long}} download" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">{{$movie->rating}} / 10</h4>
                             {!! $movie->thumbnail_genres !!}
							<span class="button-green-download2-big">View Details</span>
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="{{ $movie->url }}" class="browse-movie-title">{{$movie->title}}</a>
						<div class="browse-movie-year">{{$movie->year}}</div>						
					</div>
				</div>
				@empty
				<h1 class="text-center">No results</h1>
				<br/><br/><br/><br/><br/><br/><br/><br/><br/><br/><br/>	
				@endforelse				
			</div><br/>
		</section>
		<div>
			{{ $movies->appends(Input::except('page'))->links('vendor.pagination.front') }}
		</div>
	</div>
</div>
@stop