@extends('front.layouts.default')

@section('meta')
   @include('front.inc.default_meta')
@stop

@section('after_styles')
<link rel="stylesheet" type="text/css" href="//cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css">
@stop
@section('after_scripts')
<script src="//cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script type="text/javascript">
@if(count($errors) > 0)
	@foreach($errors->all() as $error)
		toastr.error('{{$error}}')
	@endforeach
@endif
@if(Session::has('success'))
	toastr.success('{{session("success")}}')
@endif

function captcha_callback()
{
	$('#verifyForm').submit();
}
</script>
@stop
@section('content')
<div class="container">
	<div class="row" id="info-page">
		<div class="col-md-10 col-md-push-4">
			<h2>Welcome to {{ config('settings.site_title') }}</h2>
			<h3>{{config('settings.meta_description')}}</h3>
			<form id="verifyForm" method="post" action="{{ route('verify') }}" accept-charset="UTF-8" autocomplete="off" style="margin-top: 1rem;">
				{{csrf_field()}}
				{!! Recaptcha::render(['theme'=> Config::Get('settings.recaptcha_colorscheme'), 'callback' => 'captcha_callback' ]) !!}
				<input type="hidden" name="url" value="{{ app('request')->input('url') }}">
				
			</form>
		</div>
	</div>
</div>
@stop