@extends('front.layouts.default')

@section('meta')
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<link rel="alternate" href="{{url()->current()}}" hreflang="en" />
<meta name="revisit-after" content="1 days">
<meta name="robots" content="NOINDEX, NOFOLLOW">

<meta name="description" content="{{ $episode->meta_description }}" />
<meta name="keywords" content="{{ $episode->meta_keywords }}" />

<meta property="og:title" content="{{$episode->meta_title}}" />
<meta property="og:image" content="{{$episode->thumbnail}}" />
<meta property="og:description" content="{{ $episode->meta_description }}" />
<meta property="og:url" content="{{url()->current()}}" />

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:url" value="{{url()->current()}}">
<meta name="twitter:title" content="{{ $episode->meta_title }}">
<meta name="twitter:description" content="{{ $episode->meta_description }}">
<meta name="twitter:image" content="{{$episode->thumbnail}}" />

@stop

@section('after_styles')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.1.25/jquery.fancybox.min.css" />
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.3.1/css/all.css">
<link rel="stylesheet" href="{{ url('css/pages/movie.min.css') }}">
<link rel="stylesheet" href="{{ url('css/pages/bs4.css') }}">
<link rel="stylesheet" href="{{ url('css/pages/badge.css') }}">
<link rel="stylesheet" href="{{ url('css/pages/series.css') }}">
@stop
@section('after_scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.1.25/jquery.fancybox.min.js"></script>
<script type="text/javascript">
$("a.fancybox").fancybox({
   type: "iframe",
});	

$(".season-item").on('click',function() {
//	$(".season-item").removeClass("active");
	$(".season-item").parent().removeClass("active"); 
	$(this).parent().addClass("active");
	$('.season_episodes').removeClass('active show fade');
	$('#season-'+$(this).data('sid')).addClass('active show fade');
})

$(".episode-item").click(function(e) {
	e.preventDefault(), 
	$(".episode-item").removeClass("active"), $(this).addClass("active");
	var t = $(this).attr("data-s-number"),
	i = $(this).attr("data-number"),
	e = $(this).attr("href");
	window.location.href = e;
});
</script>
@stop
@section('background_image')
	@if(!empty($series->background_image))
<div id="background-image" style="background: url({{$series->background}}) no-repeat center center; background-size: cover; -webkit-background-size: cover;-moz-background-size: cover; -o-background-size: cover;"></div>
<div id="background-overlay"></div>
	@endif
@stop
@section('content')
<div class="container" id="movie-content" itemscope itemtype="http://schema.org/TVSeries">

	<div class="row">
		<div id="mobile-movie-info" class="visible-xs col-xs-20">
			<h1>{{$series->title}} {{ $season->name }}</h1>
			<h2>{{$season->year}}</h2>
			<h2>{{str_replace(',',' - ',$series->genres)}}</h2>
		</div>

		<div id="movie-poster" class="col-xs-10 col-sm-6 col-lg-5">
		    
		      <a class="button-green-download2-big" href="https://linkboss.shop/?title={{$series->title}} (TV Series {{$season->year}}) {{ $season->name }} - Episode {{ $episode->episode_number }}" rel="nofollow sponsored" target="_blank" style="margin-bottom:8px;"><span class="icon-in"></span>Download in HD</a>
		    <a class="button-green-download2-big" href="https://linkboss.shop/?title={{$series->title}} (TV Series {{$season->year}}) {{ $season->name }} - Episode {{ $episode->episode_number }}" rel="nofollow sponsored" target="_blank" style="margin-bottom:8px;"><span class="icon-screen"></span> Stream in HD</a>

			@if(Auth::check())
				@if(Auth::user()->hasRole('Administrator'))
				<a class="button-green-download2-big" href="{{ route('admin.series.tgx_torrents',[$series->id]) }}" style="margin-bottom:8px;">TGX</a>
					<a class="button-green-download2-big" href="{{url('admin/episodes/'.$episode->id.'/edit')}}" style="margin-bottom:8px;">Edit Episode</a>
					<a class="button-green-download2-big" href="{{route('admin.episode.torrents',[$episode->id])}}" style="margin-bottom:8px;">Edit Torrents</a>
				@endif	
			@endif

		    
			<img class="img-responsive lazyload" src="{{ url('img/default_thumbnail.svg') }}" data-src="{{ $season->thumbnail }}" alt="{{$series->title}} {{ $season->name }} YIFY Torrent" title="{{$series->title}} {{ $season->name }} On {{ strtoupper(request()->getHost()) }}" />
			<a class="torrent-modal-download button-green-download2-big " href="javascript:void(0);"><span class="icon-in"></span>Download</a>
		</div>
		
		{{--
		<div class="modal modal-download">
			<div class="modal-container">
				<div class="modal-title">{{$series->title}} {{ $season->name }} - Episode {{ $episode->episode_number }} :</div>
				<span class="modal-close glyphicon glyphicon-remove"></span>
				<div class="modal-content">

					@forelse($episode->torrents as $torrent)
					<div class="modal-torrent">
						<div class="modal-quality" id="modal-quality-{{ strtolower($torrent->quality) }}"><span>{{$torrent->quality}}</span></div>
						<p><strong><small style="word-break: break-all;color:black">{{ $torrent->name }}</small></strong></p>

						<p class="quality-size">{{ strtoupper($torrent->type) }} </p>
						<p class="quality-size">{{ $torrent->size_f }} </p>

						<a download class="download-torrent button-green-download2-big" href="{{ $torrent->download_url }}" rel="nofollow" title="{{$torrent->meta_title}}"><span class="icon-in"></span>Download</a>

						<a data-torrent-id="{{$torrent->id}}" href="{{ $torrent->magnet_url }}" class="magnet-download download-torrent magnet" title="{{$torrent->meta_magnet_title}}" rel="nofollow"><span>Magnet</span></a>
					</div>
					@empty

						@forelse($season->torrents as $torrent)
						<div class="modal-torrent">
							<div class="modal-quality" id="modal-quality-{{ strtolower($torrent->quality) }}"><span>{{$torrent->quality}}</span></div>
							<p><strong><small>{{ $torrent->name }}</small></strong></p>

							<p class="quality-size">{{ strtoupper($torrent->type) }} </p>
							<p class="quality-size">{{ $torrent->size_f }} </p>

							<a download class="download-torrent button-green-download2-big" href="{{ $torrent->download_url }}" rel="nofollow" title="{{$torrent->meta_title}}"><span class="icon-in"></span>Download</a>

							<a data-torrent-id="{{$torrent->id}}" href="{{$torrent->magnet_url}}" class="magnet-download download-torrent magnet" title="{{$torrent->meta_magnet_title}}" rel="nofollow"><span>Magnet</span></a>
						</div>
						@empty
						<div class="modal-torrent">
							<p>Coming Soon</p>
						</div>
						@endforelse

					@endforelse

				</div>
			</div>-
		</div>
		--}}
		
		<div class="modal modal-download">
			<div class="modal-container" style="background-color:black;width:900px;">
				<div class="modal-title"> {{$series->title}} {{ $season->name }} - Episode {{ $episode->episode_number }} : </div>
				<span class="modal-close glyphicon glyphicon-remove"></span>
				<div class="modal-content">
				    <table class="table">
				        <thead>
                    <tr>
                        <td>Quality</td>
                        <td>Name</td>
                        <td>Size</td>
                        <td>Download</td>
                        <td>Magnet</td>
                    </tr>
                    </thead>
                    <tbody>
					@forelse($episode->torrents as $torrent)
					
                    <tr>
                        <td>{{$torrent->quality}}</td>
                        <td title="{{ $torrent->name_f }}">{{ str_limit($torrent->name_f,60) }}</td>
                        <td>{{ $torrent->size_f }}</td>
                        <td><a download href="{{ $torrent->download_url }}" rel="nofollow" title="{{$torrent->meta_title}}"><span class="icon-in" style="color:green"></span></a></td>
                        <td><a data-torrent-id="{{$torrent->id}}" href="{{$torrent->magnet_url}}" class="magnet-download download-torrent magnet" title="{{$torrent->meta_magnet_title}}" rel="nofollow" style="margin-top: 0;"><span>Magnet</span></a></td>
                    </tr>					
					
					@empty
    					@forelse($season->torrents as $torrent)
    					
                        <tr>
                            <td>{{$torrent->quality}}</td>
                            <td title="{{ $torrent->name_f }}">{{ str_limit($torrent->name_f,60) }}</td>
                            <td>{{ $torrent->size_f }}</td>
                            <td><a download href="{{ $torrent->download_url }}" rel="nofollow" title="{{$torrent->meta_title}}"><span class="icon-in" style="color:green"></span></a></td>
                            <td><a data-torrent-id="{{$torrent->id}}" href="{{$torrent->magnet_url}}" class="magnet-download download-torrent magnet" title="{{$torrent->meta_magnet_title}}" rel="nofollow" style="margin-top: 0;"><span>Magnet</span></a></td>
                        </tr>					
    					
    					@empty    					
    					<tr>
    					    <td colspan="5" class="text-center">Coming soon</td>
    					</tr>
    					@endforelse
    					
					@endforelse
					</tbody>
                    </table>


				</div>
			</div>
		</div>		
		
		
		
		<div id="movie-info" class="col-xs-10 col-sm-14 col-md-7 col-lg-8 col-lg-offset-1 movie-info" data-movie-id="{{$series->id}}">
			<div class="hidden-xs">
				<h1>{{$series->title}} {{ $season->name }} - Episode {{ $episode->episode_number }}</h1>
				<h2>Episode {{ $episode->episode_number }} - {{ $episode->name }}</h2><br/>
				<h2>{{$season->year}}</h2>
				<h2>{{str_replace(',',' - ',$series->genres)}}</h2>
			</div>
			<p class="hidden-xs hidden-sm">
				<em class="pull-left">Available in: &nbsp;</em>
					@forelse($episode->torrents as $torrent)
					<a href="{{$torrent->download_url}}" rel="nofollow sponsored" title="{{$torrent->meta_title}}">{{$torrent->quality.'.'.strtoupper($torrent->type)}}</a>
					@empty

						@forelse($season->torrents as $torrent)
						<a href="{{$torrent->download_url}}" rel="nofollow sponsored" title="{{$torrent->meta_title}}">{{$torrent->quality.'.'.strtoupper($torrent->type)}}</a>
						@empty
						<a href="#" rel="nofollow" title="{{$episode->title_long}}">Coming Soon</a>
						@endforelse

					@endforelse

			</p>
			@if(!empty($episode->video_link))
			<p class="hidden-xs hidden-sm">
				<em class="pull-left">Watch Online: &nbsp;</em>
					
					<a href="{{ $episode->video_link }}" class="fancybox" rel="nofollow" title="{{$episode->title_long}}"><span class="icon-screen" style="margin-right: 5px;color: {{config('settings.theme_pattern_color')}};"></span> Watch Now </a>
					
			</p>
			@endif					
			<p class="hidden-xs hidden-sm">
				<!---<a href="{{ ($series->episode_torrents->count() > 0) ? 'https://yify-subs.net/movie-imdb/'. $series->imdb_code : config('settings.subtitle_download_alt') }}" target="_blank" title="Download subtitles for {{$series->title}} {{ $season->name }} ({{$season->year}}) 1080p"><span class="icon-in download_subtitles"></span> Download Subtitles</a>
			-->
			</p>
			<div class="bottom-info">
				<div class="rating-row">					
					<span title="Likes" class="icon icon-heart"></span>
					<span id="movie-likes">{{ $series->like_count }}</span><span class="hidden-xs"> - Likes</span>
				</div>

				<div class="rating-row ">
					<a class="icon" rel="nofollow" target="_blank" href="https://www.rottentomatoes.com/m/{{ str_replace('-','_',str_slug($series->title)) }}" title="Rotten Tomatoes Critics - Rotten"> <img src="/img/rt-rotten.png" alt="Rotten Tomatoes Critics - Rotten - {{ strtoupper(request()->getHost()) }}" /> </a>
					<span>{{ $series->tomato_critics }}&#37;</span><span class="hidden-xs"> - Critics</span>
				</div>
				<div class="rating-row ">
					<a class="icon" rel="nofollow" target="_blank" href="https://www.rottentomatoes.com/m/{{ str_replace('-','_',str_slug($series->title)) }}" title="Rotten Tomatoes Audience - Spilled"> <img src="/img/rt-spilled.png" alt="Rotten Tomatoes Audience - Spilled - {{ strtoupper(request()->getHost()) }}" /> </a>
					<span>{{ $series->tomato_audience }}&#37;</span><span class="hidden-xs"> - Audience</span>
				</div>

<div class="rating-row" itemprop="aggregateRating" itemscope="" itemtype="http://schema.org/AggregateRating"> <a class="icon" href="https://www.imdb.com/title/{{$series->imdb_code}}/" title="{{$series->title}} IMDb Rating" target="_blank">
<img src="/img/logo-imdb.svg" alt="{{$series->title}} Rating For {{$series->title}} By {{ strtoupper(request()->getHost()) }}"> </a>
<span itemprop="itemReviewed" style="display: none;">{{$series->title}} ({{$series->year}})</span>
<span itemprop="ratingValue">{{$series->rating}}</span>
<span itemprop="bestRating" style="display: none;">10</span> <span itemprop="ratingCount" style="display: none;">{{ $series->download_count }}</span> 
<span class="hidden-xs icon-star"></span> 
</div>
				@if(!empty($series->direct_link))
				<div class="rating-row hidden-sm hidden-xs">
			
			
			
				</div>
				@endif
				
					<div class="rating-row hidden-sm hidden-xs">
				
				</div>
				
				<div class="rating-row hidden-sm hidden-xs v211">
		            @if(config('settings.advertisement') == 1)
		                @if(!empty(config('settings.advertisement_block_2')))                    
		                    {!!config('settings.advertisement_block_2')!!}
		                @else
							<a href="{{route('contact')}}" style="color: white; font-weight: bold">Advertise with Us</a>
		                @endif
		            @endif					
				</div>

			<p class="hidden-md hidden-lg">
				@forelse($episode->torrents as $torrent)
				<a href="{{$torrent->download_url}}" rel="nofollow sponsored" title="{{$torrent->meta_title}}"><span class="icon-in" style="color: {{config('settings.theme_pattern_color')}};"></span> {{$torrent->quality.'.'.strtoupper($torrent->type)}}</a>
				@empty

						@forelse($season->torrents as $torrent)
						<a href="{{$torrent->download_url}}" rel="nofollow sponsored" title="{{$torrent->meta_title}}"><span class="icon-in" style="color: {{config('settings.theme_pattern_color')}};"></span> {{$torrent->quality.'.'.strtoupper($torrent->type)}}</a>
						@empty
						<a href="#" rel="nofollow" title="{{$episode->title_long}}">Coming Soon</a>
						@endforelse
						
				@endforelse

			</p>



			<p class="hidden-md hidden-lg">
				<!--- <a href="{{ ($episode->torrents->count() > 0) ? 'https://yify-subs.net/movie-imdb/'. $series->imdb_code : config('settings.subtitle_download_alt') }}" target="_blank" title="Download subtitles for {{$series->title}} {{ $season->name }} ({{$season->year}}) 1080p"><span class="icon-in download_subtitles"></span> Download Subtitles</a>	
			-->
			</p>


			</div>
		</div>

		@if(!empty($episode->cover_image))
		<div class="col-md-6 hidden-xs hidden-sm">
			
			<img class="img-responsive lazyload" style="border: 5px solid #fff;" src="{{ 'https://via.placeholder.com/300x169/808080/ffffff/?text='.$episode->name }}" data-src="{{ $episode->thumbnail }}" alt="{{$series->title}} {{ $season->name }} Episode {{ $episode->episode_number }} - {{ $episode->name }} YIFY Torrent" title="{{$series->title}} {{ $season->name }} Episode {{ $episode->episode_number }} - {{ $episode->name }} On {{ strtoupper(request()->getHost()) }}" />

		</div>
		@endif

	</div>

<!--- Seasons & Episodes -->

<div class="seasons-list mt-5">
                            <div class="sl-content">
                                <div class="slc-seasons">
                                    <div class="sl-title"><i class="fa fa-list-ul mr-2"></i>Seasons</div>
                                    <ul class="ulclear slcs-ul">
                                        	@foreach($series->seasons as $s)
                                            <li class="{{ $season->id == $s->id ? 'active' : '' }}" >
                                                <a class="season-item" data-toggle="tab" href="javascript:void(0)" title="{{ $s->name  }}" data-sid="{{ $s->id }}">
                                                     {{ ($s->season_number > 0) ? 'Season '.$s->season_number : $s->name }}
                                                    <span class="badge badge-light float-right">{{ $s->year }}</span>
                                                </a>
                                            </li>
                                        	@endforeach
                                        
                                    </ul>
                                </div>
                                <div class="slc-eps">
                                    <div class="sl-title">Episodes</div>
                                    <div class="clearfix"></div>
                                    <div class="slce-list">
                                        <div class="tab-content">
                                            	@foreach($series->seasons as $s)
                                                <div class="tab-pane season_episodes fade {{ $season->id == $s->id ? 'show active' : '' }}" id="season-{{ $s->id }}">
                                                    <ul class="nav">
                                                    		@if($s->torrents->count() > 0)
                                                            <li class="nav-item" style="width: 99%;">
                                                                <a class="nav-link btn btn-sm btn-secondary episode-item" href="{{ $s->url }}" title="{{ $s->name }}">
                                                                    <i class="fas fa-play"></i><strong>Full Season {{ $s->season_number > 0 ? $s->season_number : '' }}
                                                                        : </strong>{{ $s->name }}
                                                                </a>
                                                            </li>                        
                                                            @endif                            	
                                                        	@foreach($s->episodes as $e)
                                                            <li class="nav-item">
                                                                <a class="nav-link btn btn-sm btn-secondary episode-item {{ $episode->id == $e->id ? 'active' : '' }}" data-number="{{ $e->id }}" data-s-number="{{ $e->id }}" href="{{ $e->url }}" title="{{ $e->name }}">
                                                                    <i class="fas fa-play"></i><strong>Episode {{ $e->episode_number }}
                                                                        : </strong>{{ $e->name }}
                                                                </a>
                                                            </li>
                                                          	@endforeach
                                                    </ul>
                                                </div>
                                            	@endforeach


                                            
                                        </div>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </div>



<!--- /Seasons & Episodes -->




	<div id="movie-sub-info" class="row">
		<div id="synopsis" class="col-sm-10 col-md-13 col-lg-12">
			<h3>Synopsis Of {{$series->title}} {{ $season->name }} Episode {{ $episode->episode_number }} - {{ $episode->name }} Torrent On YIFY ({{ strtoupper(request()->getHost()) }}) :</h3>
			<p class="hidden-sm hidden-md hidden-lg"> {{$episode->overview}} </p>
			<p class="hidden-xs"> {{$episode->overview}} </p>
			<p class="hidden-xs"> {{$series->title}} {{ $season->name }} Episode {{ $episode->episode_number }} - {{ $episode->name }}  YIFY MOVIE YTS: {{$series->title}} {{ $season->name }} Episode {{ $episode->episode_number }} - {{ $episode->name }}  ({{$season->year}}) Torrent, Download movie {{$series->title}} {{ $season->name }} Episode {{ $episode->episode_number }} - {{ $episode->name }}  ({{$series->year}}) over a torrent, {{$series->title}} {{ $season->name }} Episode {{ $episode->episode_number }} - {{ $episode->name }}  ({{$series->year}}) yify torrent, {{$series->title}} {{ $season->name }} Episode {{ $episode->episode_number }} - {{ $episode->name }}  ({{$series->year}}) magnet torrent, {{$series->title}} {{ $season->name }} Episode {{ $episode->episode_number }} - {{ $episode->name }}  ({{$series->year}}) quality HD, 1080, 720, 3D, Bluray </p>
			
			@if(!empty($season->air_date))
			<p>
			    <em>{{$series->title}} {{ $season->name }} Episode {{ $episode->episode_number }} - {{ $episode->name }}  Air Date : <b> {{ $season->air_date }} </b></em>
			</p>
			@endif			

			@if(!empty($series->writer))
			<p>
			    <em>{{$series->title}} Writers : <b> {{ $series->writer }} </b></em>
			</p>
			@endif
			
			<p>
			    @if(!empty($series->production))<br /> <em>{{$series->title}} Production : <b> {{ $series->production }} </b></em>@endif
			    @if(!empty($series->box_office))<br /> <em>{{$series->title}} Box Office : <b> {{ $series->box_office }} </b></em>@endif
			    @if(!empty($series->awards))<br /> <em>{{$series->title}} Awards : <b> {{ $series->awards }} </b></em>@endif
			    @if(!empty($series->country))<br /> <em>{{$series->title}} Country : <b> {{ $series->country }} </b></em>@endif
			</p>
			
			<p>
				@if(!empty($series->user))<br /> <em>Added By : <a href="{{ $series->user->url }}">{{$series->user->name}}</a> </em>@endif
				<br /> <em>Download Count : <b> {{ number_format($series->download_count) }} </b></em>
				<br /> <em>Source : <b>YIFY Torrent / YTS</b></em>
				<br /> <em>Updated & Posted On : {{$series->created_at->format('F d, Y \a\t h:i A')}}</em>
			</p>
		</div>
		<div id="crew" class="col-sm-10 col-md-7 col-lg-offset-1">
			@if(!empty($series->director))
			<div class="directors">
				<h3>Director</h3>
				<div class="list-cast">
					<div class="tableCell">
						<a class="avatar-thumb" href="http://www.imdb.com/find?q={{$series->director}}" target="_blank" title="IMDb Profile"> 
							<img src="{{ (!empty($series->director_meta)) ? $series->director_meta->photo_f : url('img/default_avatar.jpg')}}" alt="{{$series->director}} Picture"> </a>
					</div>
					<div class="list-cast-info tableCell">
						<a class="name-cast" href="{{ route('series.index',['keyword'=>$series->director])}}"><span itemprop="director" itemscope itemtype="http://schema.org/Person"><span itemprop="name">{{$series->director}}</span></span></a>
					</div>
				</div>
			</div>
			@endif
			
			
			@if(!empty($series->cast))
			<div class="actors">
				<h3>Cast</h3>
				@php $casts = explode(',',$series->cast); @endphp
				@forelse($casts as $cast)
				<div class="list-cast">
					<div class="tableCell">
						<a class="avatar-thumb" href="http://www.imdb.com/find?q={{$cast}}" target="_blank" title="IMDb Profile"> <img src="{{ url('img/default_avatar.jpg') }}" alt="{{$cast}} Picture"> </a>
					</div>
					<div class="list-cast-info tableCell">
						<a class="name-cast" href="{{url('movies?keyword='.$cast)}}"><span itemprop="actor" itemscope itemtype="http://schema.org/Person"><span itemprop="name">{{$cast}}</span></span></a>
					</div>
				</div>
				@empty
					<div>No results</div>
				@endforelse
			</div>
			@endif
		</div>
	</div>

	@if($episode->torrents->count() > 0)
	<div id="movie-tech-specs" class="row">
		<h3 class="hidden-xs hidden-sm col-md-5">Tech specs</h3>
		@foreach($episode->torrents as $torrent)
		<span class="tech-quality col-md-2 {{ $loop->iteration == 1 ? 'selected' : '' }}"> {{$torrent->quality.'.'.strtoupper(str_limit($torrent->type,3,''))}} </span>
		@endforeach
		@foreach($episode->torrents as $torrent)
		<div class="tech-spec-info col-xs-20 {{ $loop->iteration > 1 ? 'hidden-tech-info' : '' }}">
			<div class="row">
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"><span title="File Size" class="icon-folder"></span> {{ $torrent->size_f }} <div></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Resolution" class="icon-expand"></span> {{$torrent->resolution}} <div></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Language" class="icon-volume-medium"></span> {{$series->language}} <div></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="MPA Rating" class="icon-eye"></span> {{ (!empty($series->mpa_rating)) ? $series->mpa_rating : 'N/A' }} <div></div> </div>
			</div>
			<div class="row">
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Subtitles" class="glyphicon glyphicon-subtitles"></span> <a href="#subtitles">Subtitles</a> <div class="hidden-md hidden-lg"></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Frame Rate" class="icon-film"></span> {{$torrent->fps}} fps <div class="hidden-md hidden-lg"></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Runtime" class="icon-clock"></span> {{$series->runtime_f}} <div class="visible-xs"></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Peers and Seeds" class="tech-peers-seeds">P/S</span> {{number_format($torrent->peers)}} / {{number_format($torrent->seeds)}} </div>
			</div>
		</div>
		@endforeach

	</div>
	@endif



	@if(config('settings.disqus') == 1)
	<div class="row blog" style="margin-top: 20px;">
		<div class="col-xs-20">
		{!!config('settings.disqus_code')!!}
		</div>
	</div>		
	@endif

@if(config('settings.facebook_comments') == 1)	
	<div class="row blog" style="margin-top: 20px;">
		<div class="col-xs-20">
			<div class="fb-comments" data-href="{{ $series->slug }}" data-width="100%" data-numposts="10" data-colorscheme="dark"></div>
		</div>
	</div>
@endif	

</div>	
@stop