@extends('front.layouts.default')

@section('meta')
	@include('front.inc.default_meta')
@stop


@section('after_styles')
<style type="text/css">	
@media (min-width: 768px)
{
	.poster {
	    height: 255px;
	}
}
</style>
@stop


@section('content')
<div id="main-search" class="content-dark hidden-sm hidden-xs">
	<div class="container">
		<form method="get" action="{{action('SeriesController@index')}}" accept-charset="UTF-8">
			<div id="main-search-fields">
				<p class="pull-left term">Search Term:</p>
				<input name="keyword" placeholder="Search for a series&hellip;" autocomplete="off" type="search" value="{{app('request')->input('keyword')}}">
				<div class="selects-container">
					<p>Genre:</p>
					<select name="genre">
						<option value="">All</option>
						@php
							$selected = app('request')->input('genre'); 
						@endphp							
						@foreach($movie_genres as $genre)
						<option value="{{$genre->name}}" @if($selected == $genre->name) selected @endif>{{$genre->name}}</option>
						@endforeach
					</select>
				</div>
				<div class="selects-container">
					<p>Rating:</p>
					<select name="rating">
						<option value="0">All</option>
						@php
							$selected = app('request')->input('rating'); 
						@endphp
						@for($i = 9; $i > 0 ; $i--)
						<option value="{{$i}}" @if($selected == $i) selected @endif>{{$i}}+</option>
						@endfor

					</select>
				</div>
				<div class="selects-container selects-container-last">
					<p>Order By:</p>
					<select name="order_by">
						@php
							$selected = app('request')->input('order_by'); 
						@endphp						
						<option value="latest" @if($selected == 'latest') selected @endif>Latest</option>
						<option value="oldest" @if($selected == 'oldest') selected @endif>Oldest</option>
						<option value="year" @if($selected == 'year') selected @endif>Year</option>
						<option value="rating" @if($selected == 'rating') selected @endif>Rating</option>
						<option value="alphabetical" @if($selected == 'alphabetical') selected @endif>Alphabetical</option>
						<option value="downloads" @if($selected == 'downloads') selected @endif>Downloads</option>
					</select>
				</div>
			</div>
			<div id="main-search-btn">
				<input class="button-green-download2-big" type="submit" value="Search">
			</div>
		</form>
	</div>
</div>
<div class="browse-content">
	<div class="container">
		<h2>{{number_format($series_count)}} {{Config::Get('settings.site_title')}} Series Found</h2>
		<div>
			{{ $series->appends(Input::except('page'))->links('vendor.pagination.front') }}
		</div>
		<section>
			<div class="row">
				@forelse($series as $s)			
				<div class="browse-movie-wrap col-xs-10 col-sm-4 col-md-5 col-lg-4">
					<a href="{{ $s->url }}" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="{{ url('img/default_thumbnail.svg') }}" data-src="{{ $s->thumbnail }}" alt="{{$s->title_long}} YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">{{$s->rating}} / 10</h4>
                             {!! $s->thumbnail_genres !!}
							<span class="button-green-download2-big">View Details</span>
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="{{ $s->url }}" class="browse-movie-title">{{$s->title}}</a>
						<div class="browse-movie-year">{{$s->year}}</div>						
					</div>
				</div>				
				@empty
				<h1 class="text-center">No results</h1>
				<br/><br/><br/><br/><br/><br/><br/><br/><br/><br/><br/>	
				@endforelse				
			</div><br/><br/><br/><br/>
		</section>
		<div>
			{{ $series->appends(Input::except('page'))->links('vendor.pagination.front') }}
		</div>
	</div>
</div>
@stop